/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QDebug>
#include <QRegion>
#include <QPainter>
#include <QPaintEvent>

#include "qzionclippedgroup.h"
#include "qzionobject_p.h"

QZionClippedGroup::QZionClippedGroup(QZionAbstractCanvas *canvas)
    : QZionGroup(canvas)
{
}

QZionClippedGroup::~QZionClippedGroup()
{
}

QRect QZionClippedGroup::rect() const
{
    QZionObjectPrivate *d_obj = _QZionObject_data;

    return QRect(d_obj->pos.x(), d_obj->pos.y(), _size.width(), _size.height());
}

/*!
  TODO
*/
void QZionClippedGroup::paintInternal(QPainter *p, const QRect &prect,
                                     const QRegion &preg, const QPoint &delta,
                                     double cumulative_opacity)
{
    p->save();

    // clip to bounding rect
    if (p->clipRegion().isEmpty())
        p->setClipRect(this->rect());
    else
        p->setClipRect(this->rect(), Qt::IntersectClip);

    if (!p->clipRegion().isEmpty())
        QZionGroup::paintInternal(p, prect, preg, delta, cumulative_opacity);

    p->restore();
}

void QZionClippedGroup::setClipper(QZionRectangle *rect)
{
    QZionGroup::setClipper(rect);
}
