/*
 * Copyright (C) 2008 Instituto Nokia de Tecnologia. All rights reserved.
 *
 * This file is part of QZion.
 *
 * QZion is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * QZion is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with QZion.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __QZIONMACROS_H__
#define __QZIONMACROS_H__


#define QD_PROPERTY_RD(typ, var, getMethod)              \
    protected: typ var;                                  \
    public: inline typ &getMethod() { return var; }


#define QE_PROPERTY_RD(typ, var, getMethod)              \
    protected: typ var;                                  \
    public: inline typ getMethod() const { return var; }


#define QE_PROPERTY_RW(typ, var, getMethod, setMethod)   \
    protected: typ var;                                  \
    public: inline typ getMethod() const { return var; } \
            inline void setMethod(typ val) { var = val; }


#define QZD(class_name) class_name##Private *d = _##class_name##_data;
#define QZDP(class_name, nm) class_name##Private *nm = _##class_name##_data;

#define QZDP_VAR(vp, class_name, nm) class_name##Private *nm = vp->_##class_name##_data;

#endif
