/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.clusterers;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Tag;
import weka.core.Utils;
import weka.datagenerators.ClusterDefinition;
import weka.datagenerators.ClusterGenerator;
import weka.datagenerators.clusterers.SubspaceClusterDefinition;

public class SubspaceCluster
extends ClusterGenerator {
    static final long serialVersionUID = -3454999858505621128L;
    protected double m_NoiseRate;
    protected ClusterDefinition[] m_Clusters;
    protected int[] m_numValues;
    protected double[] m_globalMinValue;
    protected double[] m_globalMaxValue;
    public static final int UNIFORM_RANDOM = 0;
    public static final int TOTAL_UNIFORM = 1;
    public static final int GAUSSIAN = 2;
    public static final Tag[] TAGS_CLUSTERTYPE = new Tag[]{new Tag(0, "uniform/random"), new Tag(1, "total uniform"), new Tag(2, "gaussian")};
    public static final int CONTINUOUS = 0;
    public static final int INTEGER = 1;
    public static final Tag[] TAGS_CLUSTERSUBTYPE = new Tag[]{new Tag(0, "continuous"), new Tag(1, "integer")};

    public SubspaceCluster() {
        this.setNoiseRate(this.defaultNoiseRate());
    }

    public String globalInfo() {
        return "A data generator that produces data points in hyperrectangular subspace clusters.";
    }

    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe noise rate in percent (default " + this.defaultNoiseRate() + ").\n" + "\tCan be between 0% and 30%. (Remark: The original \n" + "\talgorithm only allows noise up to 10%.)", "P", 1, "-P <num>"));
        result.addElement(new Option("\tA cluster definition of class '" + SubspaceClusterDefinition.class.getName().replaceAll(".*\\.", "") + "'\n" + "\t(definition needs to be quoted to be recognized as \n" + "\ta single argument).", "C", 1, "-C <cluster-definition>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to " + SubspaceClusterDefinition.class.getName() + ":"));
        result.addAll(this.enumToVector(new SubspaceClusterDefinition(this).listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.m_numValues = new int[this.getNumAttributes()];
        for (int i = 0; i < this.getNumAttributes(); ++i) {
            this.m_numValues[i] = 1;
        }
        String tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setNoiseRate(Double.parseDouble(tmpStr));
        } else {
            this.setNoiseRate(this.defaultNoiseRate());
        }
        Vector<SubspaceClusterDefinition> list = new Vector<SubspaceClusterDefinition>();
        int clCount = 0;
        do {
            if ((tmpStr = Utils.getOption('C', options)).length() == 0) continue;
            ++clCount;
            SubspaceClusterDefinition cl = new SubspaceClusterDefinition(this);
            cl.setOptions(Utils.splitOptions(tmpStr));
            list.add(cl);
        } while (tmpStr.length() != 0);
        this.m_Clusters = list.toArray(new ClusterDefinition[list.size()]);
        this.getClusters();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        result.add("-P");
        result.add("" + this.getNoiseRate());
        for (i = 0; i < this.getClusters().length; ++i) {
            result.add("-C");
            result.add(Utils.joinOptions(this.getClusters()[i].getOptions()));
        }
        return result.toArray(new String[result.size()]);
    }

    protected ClusterDefinition[] getClusters() {
        if (this.m_Clusters == null || this.m_Clusters.length == 0) {
            if (this.m_Clusters != null) {
                System.out.println("NOTE: at least 1 cluster definition is necessary, created default one.");
            }
            this.m_Clusters = new ClusterDefinition[]{new SubspaceClusterDefinition(this)};
        }
        return this.m_Clusters;
    }

    protected int defaultNumAttributes() {
        return 1;
    }

    public void setNumAttributes(int numAttributes) {
        super.setNumAttributes(numAttributes);
        this.m_numValues = new int[this.getNumAttributes()];
    }

    public String numAttributesTipText() {
        return "The number of attributes the generated data will contain (Note: they must be covered by the cluster definitions!)";
    }

    protected double defaultNoiseRate() {
        return 0.0;
    }

    public double getNoiseRate() {
        return this.m_NoiseRate;
    }

    public void setNoiseRate(double newNoiseRate) {
        this.m_NoiseRate = newNoiseRate;
    }

    public String noiseRateTipText() {
        return "The noise rate to use.";
    }

    public ClusterDefinition[] getClusterDefinitions() {
        return this.getClusters();
    }

    public void setClusterDefinitions(ClusterDefinition[] value) throws Exception {
        String indexStr = "";
        this.m_Clusters = value;
        for (int i = 0; i < this.getClusters().length; ++i) {
            if (!(this.getClusters()[i] instanceof SubspaceClusterDefinition)) {
                if (indexStr.length() != 0) {
                    indexStr = indexStr + ",";
                }
                indexStr = indexStr + "" + (i + 1);
            }
            this.getClusters()[i].setParent(this);
            this.getClusters()[i].setOptions(this.getClusters()[i].getOptions());
        }
        if (indexStr.length() != 0) {
            throw new Exception("These cluster definitions are not '" + SubspaceClusterDefinition.class.getName() + "': " + indexStr);
        }
    }

    public String clusterDefinitionsTipText() {
        return "The clusters to use.";
    }

    protected boolean checkCoverage() {
        int i;
        int[] count = new int[this.getNumAttributes()];
        for (i = 0; i < this.getNumAttributes(); ++i) {
            for (int n = 0; n < this.getClusters().length; ++n) {
                SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[n];
                Range r = new Range(cl.getAttrIndexRange());
                r.setUpper(this.getNumAttributes());
                if (!r.isInRange(i)) continue;
                int n2 = i;
                count[n2] = count[n2] + 1;
            }
        }
        String attrIndex = "";
        for (i = 0; i < count.length; ++i) {
            if (count[i] != 0) continue;
            if (attrIndex.length() != 0) {
                attrIndex = attrIndex + ",";
            }
            attrIndex = attrIndex + (i + 1);
        }
        if (attrIndex.length() != 0) {
            throw new IllegalArgumentException("The following attributes are not covered by a cluster definition: " + attrIndex + "\n");
        }
        return true;
    }

    public boolean getSingleModeFlag() {
        return false;
    }

    public Instances defineDataFormat() throws Exception {
        Attribute attribute;
        int i;
        this.setOptions(this.getOptions());
        this.checkCoverage();
        Random random = new Random(this.getSeed());
        this.setRandom(random);
        FastVector attributes = new FastVector(3);
        boolean classFlag = this.getClassFlag();
        FastVector classValues = null;
        if (classFlag) {
            classValues = new FastVector(this.getClusters().length);
        }
        FastVector boolValues = new FastVector(2);
        boolValues.addElement("false");
        boolValues.addElement("true");
        FastVector nomValues = null;
        for (i = 0; i < this.getNumAttributes(); ++i) {
            if (this.m_booleanCols.isInRange(i)) {
                attribute = new Attribute("B" + i, boolValues);
            } else if (this.m_nominalCols.isInRange(i)) {
                nomValues = new FastVector(this.m_numValues[i]);
                for (int j = 0; j < this.m_numValues[i]; ++j) {
                    nomValues.addElement("value-" + j);
                }
                attribute = new Attribute("N" + i, nomValues);
            } else {
                attribute = new Attribute("X" + i);
            }
            attributes.addElement(attribute);
        }
        if (classFlag) {
            for (i = 0; i < this.getClusters().length; ++i) {
                classValues.addElement("c" + i);
            }
            attribute = new Attribute("class", classValues);
            attributes.addElement(attribute);
        }
        Instances dataset = new Instances(this.getRelationNameToUse(), attributes, 0);
        if (classFlag) {
            dataset.setClassIndex(this.m_NumAttributes);
        }
        Instances format = new Instances(dataset, 0);
        this.setDatasetFormat(format);
        for (int i2 = 0; i2 < this.getClusters().length; ++i2) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[i2];
            cl.setNumInstances(random);
            cl.setParent(this);
        }
        return dataset;
    }

    public boolean isBoolean(int index) {
        return this.m_booleanCols.isInRange(index);
    }

    public boolean isNominal(int index) {
        return this.m_nominalCols.isInRange(index);
    }

    public int[] getNumValues() {
        return this.m_numValues;
    }

    public Instance generateExample() throws Exception {
        throw new Exception("Examples cannot be generated one by one.");
    }

    public Instances generateExamples() throws Exception {
        Instances format = this.getDatasetFormat();
        Instance example = null;
        if (format == null) {
            throw new Exception("Dataset format not defined.");
        }
        block5: for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            int instNum = cl.getNumInstances();
            String cName = "c" + cNum;
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    for (int i = 0; i < instNum; ++i) {
                        example = this.generateExample(format, this.getRandom(), cl, cName);
                        if (example == null) continue;
                        format.add(example);
                    }
                    continue block5;
                }
                case 1: {
                    if (!cl.isInteger()) {
                        this.generateUniformExamples(format, instNum, cl, cName);
                        continue block5;
                    }
                    this.generateUniformIntegerExamples(format, instNum, cl, cName);
                    continue block5;
                }
                case 2: {
                    this.generateGaussianExamples(format, instNum, this.getRandom(), cl, cName);
                }
            }
        }
        return format;
    }

    private Instance generateExample(Instances format, Random randomG, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        int num = -1;
        Instance example = null;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        example = new Instance(numAtts);
        example.setDataset(format);
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        int clusterI = -1;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (attributes[i]) {
                double value;
                ++clusterI;
                ++num;
                if (this.isBoolean(i) || this.isNominal(i)) {
                    if (minValue[clusterI] == maxValue[clusterI]) {
                        value = minValue[clusterI];
                    } else {
                        int numValues = (int)(maxValue[clusterI] - minValue[clusterI] + 1.0);
                        value = randomG.nextInt(numValues);
                        value += minValue[clusterI];
                    }
                } else {
                    value = randomG.nextDouble() * (maxValue[num] - minValue[num]) + minValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                }
                example.setValue(i, value);
                continue;
            }
            example.setMissing(i);
        }
        if (this.getClassFlag()) {
            example.setClassValue(cName);
        }
        return example;
    }

    private void generateUniformExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        Instance example = null;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        example = new Instance(numAtts);
        example.setDataset(format);
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        double[] diff = new double[minValue.length];
        for (int i = 0; i < minValue.length; ++i) {
            diff[i] = maxValue[i] - minValue[i];
        }
        for (int j = 0; j < numInstances; ++j) {
            int num = -1;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (attributes[i]) {
                    double value = minValue[++num] + diff[num] * ((double)j / (double)(numInstances - 1));
                    example.setValue(i, value);
                    continue;
                }
                example.setMissing(i);
            }
            if (this.getClassFlag()) {
                example.setClassValue(cName);
            }
            format.add(example);
        }
    }

    private void generateUniformIntegerExamples(Instances format, int numInstances, SubspaceClusterDefinition cl, String cName) {
        Instance example = null;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        example = new Instance(numAtts);
        example.setDataset(format);
        boolean[] attributes = cl.getAttributes();
        double[] minValue = cl.getMinValue();
        double[] maxValue = cl.getMaxValue();
        int[] minInt = new int[minValue.length];
        int[] maxInt = new int[maxValue.length];
        int[] intValue = new int[maxValue.length];
        int[] numInt = new int[minValue.length];
        int num = 1;
        for (int i = 0; i < minValue.length; ++i) {
            minInt[i] = (int)Math.ceil(minValue[i]);
            maxInt[i] = (int)Math.floor(maxValue[i]);
            numInt[i] = maxInt[i] - minInt[i] + 1;
            num *= numInt[i];
        }
        int numEach = numInstances / num;
        int rest = numInstances - numEach * num;
        for (int i = 0; i < this.m_NumAttributes; ++i) {
            if (attributes[i]) {
                example.setValue(i, (double)minInt[i]);
                intValue[i] = minInt[i];
                continue;
            }
            example.setMissing(i);
        }
        if (this.getClassFlag()) {
            example.setClassValue(cName);
        }
        int added = 0;
        int attr = 0;
        do {
            for (int k = 0; k < numEach; ++k) {
                format.add(example);
                example = (Instance)example.copy();
                ++added;
            }
            if (rest > 0) {
                format.add(example);
                example = (Instance)example.copy();
                ++added;
                --rest;
            }
            if (added >= numInstances) break;
            boolean done = false;
            do {
                if (attributes[attr] && intValue[attr] + 1 <= maxInt[attr]) {
                    int n = attr;
                    intValue[n] = intValue[n] + 1;
                    done = true;
                    continue;
                }
                ++attr;
            } while (!done);
            example.setValue(attr, (double)intValue[attr]);
        } while (added < numInstances);
    }

    private void generateGaussianExamples(Instances format, int numInstances, Random random, SubspaceClusterDefinition cl, String cName) {
        boolean makeInteger = cl.isInteger();
        Instance example = null;
        int numAtts = this.m_NumAttributes;
        if (this.getClassFlag()) {
            ++numAtts;
        }
        example = new Instance(numAtts);
        example.setDataset(format);
        boolean[] attributes = cl.getAttributes();
        double[] meanValue = cl.getMeanValue();
        double[] stddevValue = cl.getStddevValue();
        for (int j = 0; j < numInstances; ++j) {
            int num = -1;
            for (int i = 0; i < this.m_NumAttributes; ++i) {
                if (attributes[i]) {
                    double value = meanValue[++num] + random.nextGaussian() * stddevValue[num];
                    if (makeInteger) {
                        value = Math.round(value);
                    }
                    example.setValue(i, value);
                    continue;
                }
                example.setMissing(i);
            }
            if (this.getClassFlag()) {
                example.setClassValue(cName);
            }
            format.add(example);
        }
    }

    public String generateFinished() throws Exception {
        return "";
    }

    public String generateStart() {
        StringBuffer docu = new StringBuffer();
        int sumInst = 0;
        for (int cNum = 0; cNum < this.getClusters().length; ++cNum) {
            SubspaceClusterDefinition cl = (SubspaceClusterDefinition)this.getClusters()[cNum];
            docu.append("%\n");
            docu.append("% Cluster: c" + cNum + "   ");
            switch (cl.getClusterType().getSelectedTag().getID()) {
                case 0: {
                    docu.append("Uniform Random");
                    break;
                }
                case 1: {
                    docu.append("Total Random");
                    break;
                }
                case 2: {
                    docu.append("Gaussian");
                }
            }
            if (cl.isInteger()) {
                docu.append(" / INTEGER");
            }
            docu.append("\n% ----------------------------------------------\n");
            docu.append("%" + cl.attributesToString());
            docu.append("\n% Number of Instances:            " + cl.getInstNums() + "\n");
            docu.append("% Generated Number of Instances:  " + cl.getNumInstances() + "\n");
            sumInst += cl.getNumInstances();
        }
        docu.append("%\n% ----------------------------------------------\n");
        docu.append("% Total Number of Instances: " + sumInst + "\n");
        docu.append("%                            in " + this.getClusters().length + " Cluster(s)\n%");
        return docu.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }

    public static void main(String[] args) {
        SubspaceCluster.runDataGenerator(new SubspaceCluster(), args);
    }
}

