/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.TransformationDictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerivedFieldMetaInfo
extends FieldMetaInfo
implements Serializable {
    protected String m_displayName = null;
    protected ArrayList<FieldMetaInfo.Value> m_values = new ArrayList();
    protected Expression m_expression;

    public DerivedFieldMetaInfo(Element derivedField, ArrayList<Attribute> fieldDefs, TransformationDictionary transDict) throws Exception {
        super(derivedField);
        NodeList valL;
        String displayName = derivedField.getAttribute("displayName");
        if (displayName != null && displayName.length() > 0) {
            this.m_displayName = displayName;
        }
        if ((valL = derivedField.getElementsByTagName("Value")).getLength() > 0) {
            for (int i = 0; i < valL.getLength(); ++i) {
                Node valueN = valL.item(i);
                if (valueN.getNodeType() != 1) continue;
                FieldMetaInfo.Value v = new FieldMetaInfo.Value((Element)valueN);
                this.m_values.add(v);
            }
        }
        this.m_expression = Expression.getExpression(derivedField, this.m_optype, fieldDefs, transDict);
    }

    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        this.m_expression.setFieldDefs(fieldDefs);
    }

    @Override
    public Attribute getFieldAsAttribute() {
        return this.m_expression.getOutputDef().copy(this.m_fieldName);
    }

    public double getDerivedValue(double[] incoming) throws Exception {
        return this.m_expression.getResult(incoming);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getFieldAsAttribute() + "\nexpression:\n");
        buff.append(this.m_expression + "\n");
        return buff.toString();
    }
}

