/*
 * ctlp-subs.c	Here's where most SIOC* calls for ctlportslave live.
 *
 * Version:	@(#)ctlp-subs.c  1.10  13-Jan-1998  miquels@cistron.nl
 *
 */
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <termios.h>
#include <sys/stat.h>
#include <time.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#if defined(__GLIBC__)
#  include <net/if_ppp.h>
#else
#  include <linux/if.h>
#  include <linux/ppp_defs.h>
#  include <linux/if_ppp.h>
#endif

#include "server.h"

#define MAX_IFS 128

/*
 *	Find the idle time of a certain device, returns -1 on error.
 */
int idle_stat(const char *dev)
{
	char buf[128];
	int fd;
	struct termios tty;
	struct ppp_idle ppp_idle;
	struct stat st;
	time_t now;
	int rc = 0;

	if (dev[0] != '/') {
		snprintf(buf, sizeof (buf), "/dev/%s", dev);
		dev = buf;
	}
	if ((fd = open(dev, O_RDONLY|O_NONBLOCK)) < 0) {
		return -1;
	}
	if (tcgetattr(fd, &tty) < 0) {
		perror(dev);
		close(fd);
		return -1;
	}
	switch(tty.c_line) {
		case N_TTY:
			if (fstat(fd, &st) < 0) break;
			now = time(NULL);
			rc = now - st.st_mtime;
			break;
		case N_PPP:
			if (ioctl(fd, PPPIOCGIDLE, &ppp_idle) == 0) {
				if (ppp_idle.recv_idle < ppp_idle.xmit_idle)
					rc = ppp_idle.recv_idle;
				else
					rc = ppp_idle.xmit_idle;
			}
			break;
		default:
			break;
	}

	close(fd);

	return rc;
}


/*
 *	Find the device with a certain IP address.
 *	Return packets in/out if we can retrieve such information.
 */
int traffic_stats(int sockfd, struct in_addr saddr, int *in, int *out)
{
	int ifs_len;
	struct ifreq *ifr, *ifs;
	struct ifconf ifc;
	struct in_addr ina;
	int ret = -1;
	char buf[256];
	char *p;
	FILE *f;

	*in = *out = 0;

	ifs_len = MAX_IFS * sizeof (struct ifreq);
	ifs = (struct ifreq *) xmalloc(ifs_len);
	ifc.ifc_len = ifs_len;
	ifc.ifc_req = ifs;

	if (ioctl(sockfd, SIOCGIFCONF, &ifc) < 0) {
		perror("ioctl(SIOCGIFCONF)");
		free(ifs);
		return -1;
	}
	ifs_len = ifc.ifc_len;

	for (ifr = ifc.ifc_req; ifs_len > 0; ifr++) {
		ifs_len -= sizeof(struct ifreq);
		ifr->ifr_dstaddr.sa_family = AF_INET;
		if (ioctl(sockfd, SIOCGIFDSTADDR, ifr) < 0)
			continue;
		if (ifr->ifr_dstaddr.sa_family != AF_INET)
			continue;
		ina = ((struct sockaddr_in *) &ifr->ifr_dstaddr)->sin_addr;
		/*printf("CHECK: %s %s\n", ifr->ifr_name, inet_ntoa(ina));*/
		if (ina.s_addr == saddr.s_addr) {
			ret = 0;
			break;
		}
	}
		
	if (ret) {
		free(ifs);
		return ret;
	}


	if ((f = fopen ("/proc/net/dev", "r"))) {
		while (fgets (buf, sizeof(buf), f)) {
			p = strtok (buf, ":");
			while (*p == ' ')	p++;	/* Trim leading spaces */
			if (strcmp(ifr->ifr_name, p) == 0) {
				int x;
				p = strtok ((char *) 0, " \t\r\n");
				*in = strtoul(p, NULL, 10);
				for (x = 2; x < 10; x++) p = strtok ((char *) 0, " \t\r\n");
				*out = strtoul(p, NULL, 10);
				break;
			}
		}
		fclose (f);
	}

	free(ifs);

	return 0;
}



#ifdef STANDALONE

int main(int argc, char **argv)
{
	struct in_addr ina;
	int r, in, out;
	int sockfd;

	sockfd = socket(AF_INET, SOCK_DGRAM, 0);
	inet_aton(argv[1], &ina);
	r = traffic_stats(sockfd, ina, &in, &out);
	printf("r = %d, in = %d, out = %d\n", r, in, out);

	return 0;
}
#endif

