/*	Sources_Table

PIRL CVS ID: Sources_Table.java,v 1.6 2012/04/16 06:04:10 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/
package PIRL.Conductor;

import	org.jdesktop.swingx.JXTable;

import	javax.swing.JTable;
import	javax.swing.ListSelectionModel;
import	javax.swing.table.TableCellRenderer;
import	javax.swing.JLabel;
import	javax.swing.BorderFactory;
import	javax.swing.JViewport;
import	java.awt.Component;
import	java.awt.Color;
import	java.awt.Font;
import	java.awt.Point;
import	java.awt.Rectangle;
import	java.awt.event.MouseEvent;
import	java.awt.event.MouseAdapter;
import	java.util.Vector;


/**	A <i>Sources_Table</i> is a table view of a Sources_Table_Model.
<p>
	@author	Bradford Castalia, UA/HiROC
	@version 1.6
*/
public class Sources_Table
	extends JXTable
{
/**	Class identification name with source code version and date.
*/
public static final String
	ID = "PIRL.Conductor.Sources_Table (1.6 2012/04/16 06:04:10)";


private Font
	Emphasis_Font;


//  DEBUG control.
private static final int
	DEBUG_OFF			= 0,
	DEBUG_CONSTRUCTOR	= 1 << 0,
	DEBUG_ACCESSORS		= 1 << 1,
	DEBUG_RENDERER		= 1 << 2,
	DEBUG_ALL			= -1,

	DEBUG				= DEBUG_OFF;

/*==============================================================================
	Constructors
*/
public Sources_Table
	(
	Sources_Table_Model	table_model
	)
{
super (table_model);

setColumnSelectionAllowed (true);
setRowSelectionAllowed (false);
getColumnModel ().getSelectionModel ()
	.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
addMouseListener (new Table_Mouse_Listener ());
setBackground (Colors.TABLE);
getTableHeader ().setBackground (Colors.TABLE_HEADER);
Emphasis_Font = getFont ().deriveFont (Font.BOLD);
/*
	WARNING: These are JXTable specific methods.
*/
setColumnControlVisible (true);
setSortable (false);

setDefaultRenderer (String.class, new Sources_Table_Cell_Renderer ());
}

/*==============================================================================
	Accessors
*/

/*	If not provided by the base class.
public int convertRowIndexToModel
	(
	int		view_row
	)
{return view_row;}
*/

/*==============================================================================
	Sources_Table_Cell_Renderer
*/
private class Sources_Table_Cell_Renderer
	extends JLabel
	implements TableCellRenderer
{
public Sources_Table_Cell_Renderer ()
{
setOpaque (true);
setBorder (BorderFactory.createEmptyBorder (0, 5, 0, 0));
setFont (Emphasis_Font);
}


public Component getTableCellRendererComponent
	(
	JTable	table,
	Object	value,
	boolean	selected,
	boolean	focused,
	int		row,
	int		column
	)
{
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		(">>> Sources_Table_Cell_Renderer: "
			+ row + '/' + ((JXTable)table).convertRowIndexToModel (row) + ','
			+ column + '/' + table.convertColumnIndexToModel (column) + ' '
			+ value);
row = ((JXTable)table).convertRowIndexToModel (row);
column = table.convertColumnIndexToModel (column);
Sources_Table_Model
	model = (Sources_Table_Model)table.getModel ();
Vector
	record = (Vector)model.Record (row);
Color
	color = table.getBackground ();
String
	field = (String)record.get (Conductor.CONDUCTOR_ID_FIELD),
	annotation = null;
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		("    " + Conductor.CONDUCTOR_ID_FIELD + ": " + field);
if (field != null &&
	field.length () != 0)
	{
	//	Acquired record.
	if (row == model.Current_Row)
		//	The currently selected source record.
		color = Colors.CURRENT_RECORD;
	else
		color = Colors.PROCESSED_RECORD;

	if (column == Conductor.STATUS_FIELD)
		{
		field = Current_Status ((String)record.get (Conductor.STATUS_FIELD));
		if ((DEBUG & DEBUG_RENDERER) != 0)
			System.out.println
				("    " + Conductor.STATUS_FIELD + ": " + field);
		if (field != null)
			{
			int
				code = Conductor.PROCEDURE_FAILURE + 1;
			try {code = Conductor.Status_Conductor_Code (field);}
			catch (NumberFormatException exception) {}
			if (code <= Conductor.PROCEDURE_FAILURE)
				{
				annotation =
					Conductor.Status_Conductor_Code_Description (code);
				if (code != Conductor.PROCEDURE_SUCCESS)
					{
					//	Failure status.
					if (code == Conductor.PROCEDURE_FAILURE)
						color = Colors.FAILURE_STATUS_FIELD;
					else
						color = Colors.FAILED_SOURCE_FIELD;
					}
				}
			}
		}
	}

if (selected)
	{
	if (color.getRed () > 200 &&
		color.getGreen () > 200 &&
		color.getBlue () > 200)
		color = color.darker ();
	else
		color = color.brighter ();
	}
setBackground (color);
setValue (value);
setToolTipText (annotation);
if ((DEBUG & DEBUG_RENDERER) != 0)
	System.out.println
		("<<< Sources_Table_Cell_Renderer");
return this;
}


public void setValue
	(
	Object	value
	)
{setText ((value == null) ? "" : value.toString ());}

}	//	Sources_Table_Cell_Renderer


private static String Current_Status
	(
	String	status_field_value
	)
{
String
	status = null;
Vector
	status_indicators = Conductor.Status_Indicators (status_field_value);
if (! status_indicators.isEmpty ())
	status = (String)status_indicators.lastElement ();
return status;
}

/**	Scrolls a table to show a specified row.
<p>
	If the table is not contained withing a scrollable pane (typically
	a JScrollPane) nothing is done. If the specified row is already
	visible nothing is done.
<p>
	@param	table	The JTable to have the row set visible.
	@param	row	The row index, where zero is the top row, of
		the row to be made visible. If the row is less than zero the
		top row will be made visible. If the row is greater than or
		equal to the number of rows in the table the last row will be
		make visible.
*/
public static void Show_Table_Row
	(
	JTable	table,
	int		row
	)
{
if (! (table.getParent () instanceof JViewport))
	return;

JViewport
	viewport = (JViewport)table.getParent ();
Point
	point = viewport.getViewPosition ();
Rectangle
	rectangle = table.getCellRect (row, 0, true);
rectangle.setLocation (rectangle.x - point.x, rectangle.y - point.y);
viewport.scrollRectToVisible (rectangle);
}

/**	Tests if a specified row of a table is visible.
<p>
	False will be returned if the table is not contained within a
	scrollable pane (typically a JScrollPane), the table has no rows, the
	row index is less than zero or is greater than or equal to the number
	of rows in the table.
<p>
	A row is visible if the entire row height is visible even if any part
	of the row width is not visible.
<p>
	@param	table	The JTable to have the row set visible.
	@param	row	The row index, where zero is the top row, of
		the row to test.
*/
public static boolean Table_Row_Is_Visible
	(
	JTable	table,
	int		row
	)
{
if (! (table.getParent () instanceof JViewport))
	return false;

int
	rows = table.getRowCount () - 1;
if (rows < 0 ||
	row < 0 ||
	row > rows)
	return false;

JViewport
	viewport = (JViewport)table.getParent ();
Rectangle
	cell = table.getCellRect (row, 0, true),
	view = new Rectangle
		(viewport.getViewPosition (), viewport.getExtentSize ());
if (cell.y < view.y ||
	(cell.y + cell.height) > (view.y + view.height))
	return false;
return true;
}


}
