/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test base
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "pgmcheck.h"
#include <pgm/pgm.h>

/* FIXME: maybe we could/should add a fork+main loop here */
void
pgm_check_standard_init (void)
{
  pgm_init_check (NULL, NULL);
}

void
pgm_check_standard_shutdown (void)
{
  pgm_deinit ();
}


/*
 * returns TRUE if there is no PGM_CHECKS environment variable, or if it is a
 * comma-separated list containing func_name, FALSE otherwise.
 */
gboolean
_pgm_check_run_test_func (const gchar * func_name)
{
  const gchar *gst_checks;
  gboolean res = FALSE;
  gchar **funcs, **f;
  const gchar *pgm_checks = NULL;

  pgm_checks = g_getenv ("PGM_CHECKS");

  /* no filter specified => run all checks */
  if (pgm_checks == NULL || *pgm_checks == '\0')
    return TRUE;

  /* only run specified functions */
  funcs = g_strsplit (pgm_checks, ",", -1);
  for (f = funcs; f != NULL && *f != NULL; ++f) {
    if (strcmp (*f, func_name) == 0) {
      res = TRUE;
      break;
    }
  }
  g_strfreev (funcs);
  return res;
}
