SELECT set_sphere_output_precision(8);

CREATE TABLE test_boxes (
    b sbox
);

COPY test_boxes (b) FROM stdin;
( (0.349065850398866, 0.174532925199433), (0.350065850398866, 0.174632925199433) )
( (1.59875999207035, 0.771416330759722), (1.5997599920703498, 0.771516330759722) )
( (1.59876348272885, 0.77141458543047), (1.5997634827288498, 0.77151458543047) )
( (1.59876697338736, 0.771412840101218), (1.5997669733873598, 0.771512840101218) )
( (1.59877046404586, 0.771411094771966), (1.5997704640458599, 0.771511094771966) )
( (1.59877395470437, 0.771409349442714), (1.59977395470437, 0.771509349442714) )
( (1.59877744536287, 0.771407604113461), (1.59977744536287, 0.771507604113461) )
( (1.59878093602137, 0.77140585878421), (1.59978093602137, 0.77150585878421) )
( (1.59878442667988, 0.771404113454958), (1.59978442667988, 0.771504113454958) )
( (1.59878791733838, 0.771402368125706), (1.59978791733838, 0.7715023681257059) )
( (1.59879140799689, 0.771400622796454), (1.5997914079968898, 0.771500622796454) )
( (1.59879489865539, 0.771398877467202), (1.5997948986553898, 0.771498877467202) )
( (1.59879838931389, 0.77139713213795), (1.5997983893138898, 0.77149713213795) )
( (1.5988018799724, 0.771395386808698), (1.5998018799723999, 0.771495386808698) )
( (1.5988053706309, 0.771393641479446), (1.5998053706309, 0.771493641479446) )
( (1.59880886128941, 0.771391896150194), (1.59980886128941, 0.771491896150194) )
( (1.59881235194791, 0.771390150820941), (1.59981235194791, 0.771490150820941) )
( (1.59881584260641, 0.77138840549169), (1.59981584260641, 0.77148840549169) )
( (1.59881933326492, 0.771386660162438), (1.59981933326492, 0.7714866601624379) )
( (1.59882282392342, 0.771384914833186), (1.5998228239234198, 0.771484914833186) )
( (1.59882631458193, 0.771383169503934), (1.5998263145819298, 0.771483169503934) )
( (1.59882980524043, 0.771381424174682), (1.5998298052404298, 0.771481424174682) )
( (1.59883329589893, 0.77137967884543), (1.5998332958989299, 0.77147967884543) )
( (1.59883678655744, 0.771377933516178), (1.5998367865574399, 0.771477933516178) )
( (1.59884027721594, 0.771376188186926), (1.59984027721594, 0.771476188186926) )
( (1.59884376787445, 0.771374442857673), (1.59984376787445, 0.771474442857673) )
( (1.59884725853295, 0.771372697528422), (1.59984725853295, 0.771472697528422) )
( (1.59885074919145, 0.77137095219917), (1.59985074919145, 0.77147095219917) )
( (1.59885423984996, 0.771369206869918), (1.5998542398499598, 0.7714692068699179) )
( (1.59885773050846, 0.771367461540666), (1.5998577305084598, 0.771467461540666) )
( (1.59886122116697, 0.771365716211414), (1.5998612211669698, 0.771465716211414) )
( (1.59886471182547, 0.771363970882162), (1.5998647118254699, 0.771463970882162) )
( (1.59886820248397, 0.77136222555291), (1.5998682024839699, 0.77146222555291) )
( (1.59887169314248, 0.771360480223658), (1.59987169314248, 0.771460480223658) )
( (1.59887518380098, 0.771358734894406), (1.59987518380098, 0.771458734894406) )
( (1.59887867445948, 0.771356989565154), (1.59987867445948, 0.771456989565154) )
( (1.59888216511799, 0.771355244235902), (1.59988216511799, 0.771455244235902) )
( (1.59888565577649, 0.77135349890665), (1.5998856557764898, 0.7714534989066499) )
( (1.598889146435, 0.771351753577398), (1.5998891464349998, 0.771451753577398) )
( (1.5988926370935, 0.771350008248146), (1.5998926370934998, 0.771450008248146) )
( (1.59889612775201, 0.771348262918894), (1.5998961277520098, 0.771448262918894) )
( (1.59889961841051, 0.771346517589642), (1.5998996184105099, 0.771446517589642) )
( (1.59890310906901, 0.77134477226039), (1.59990310906901, 0.77144477226039) )
( (1.59890659972752, 0.771343026931138), (1.59990659972752, 0.771443026931138) )
( (1.59891009038602, 0.771341281601886), (1.59991009038602, 0.771441281601886) )
( (1.59891358104452, 0.771339536272634), (1.59991358104452, 0.771439536272634) )
( (1.59891707170303, 0.771337790943382), (1.59991707170303, 0.7714377909433819) )
( (1.59892056236153, 0.77133604561413), (1.5999205623615298, 0.77143604561413) )
( (1.59892405302004, 0.771334300284878), (1.5999240530200398, 0.771434300284878) )
( (1.59892754367854, 0.771332554955626), (1.5999275436785398, 0.771432554955626) )
( (1.59893103433705, 0.771330809626374), (1.5999310343370499, 0.771430809626374) )
( (1.59893452499555, 0.771329064297122), (1.59993452499555, 0.771429064297122) )
( (1.59893801565405, 0.77132731896787), (1.59993801565405, 0.77142731896787) )
( (1.59894150631256, 0.771325573638618), (1.59994150631256, 0.771425573638618) )
( (1.59894499697106, 0.771323828309366), (1.59994499697106, 0.771423828309366) )
( (1.59894848762957, 0.771322082980114), (1.59994848762957, 0.7714220829801139) )
( (1.59895197828807, 0.771320337650862), (1.5999519782880698, 0.771420337650862) )
( (1.59895546894657, 0.77131859232161), (1.5999554689465698, 0.77141859232161) )
( (3.61121537674092, -1.33598496521933), (3.6122153767409197, -1.33588496521933) )
( (3.61121886739942, -1.33598321989008), (3.6122188673994198, -1.33588321989008) )
( (3.61122235805792, -1.33598147456083), (3.61222235805792, -1.33588147456083) )
( (3.61122584871643, -1.33597972923158), (3.61222584871643, -1.33587972923158) )
( (3.61122933937493, -1.33597798390233), (3.61222933937493, -1.33587798390233) )
( (3.61123283003344, -1.33597623857307), (3.61223283003344, -1.33587623857307) )
( (3.61123632069194, -1.33597449324382), (3.61223632069194, -1.33587449324382) )
( (3.61123981135044, -1.33597274791457), (3.61223981135044, -1.33587274791457) )
( (3.61124330200895, -1.33597100258532), (3.6122433020089497, -1.33587100258532) )
( (3.61124679266745, -1.33596925725607), (3.6122467926674497, -1.33586925725607) )
( (3.61125028332595, -1.33596751192682), (3.6122502833259498, -1.33586751192682) )
( (3.61125377398446, -1.33596576659756), (3.61225377398446, -1.33586576659756) )
( (3.61125726464296, -1.33596402126831), (3.61225726464296, -1.33586402126831) )
( (3.61126075530147, -1.33596227593906), (3.61226075530147, -1.33586227593906) )
( (3.61126424595997, -1.33596053060981), (3.61226424595997, -1.33586053060981) )
( (3.61126773661847, -1.33595878528056), (3.61226773661847, -1.33585878528056) )
( (3.61127122727698, -1.3359570399513), (3.6122712272769797, -1.3358570399513001) )
( (3.61127471793548, -1.33595529462205), (3.6122747179354797, -1.33585529462205) )
( (3.61127820859399, -1.3359535492928), (3.61227820859399, -1.3358535492928) )
\.

CREATE OR REPLACE FUNCTION qnodes(q text) RETURNS text
LANGUAGE 'plpgsql' AS
$$
DECLARE
  exp TEXT;
  mat TEXT[];
  ret TEXT[];
BEGIN
  FOR exp IN EXECUTE 'EXPLAIN ' || q
  LOOP
    --RAISE NOTICE 'EXP: %', exp;
    mat := regexp_matches(exp, ' *(?:-> *)?(.*Scan on (test_boxes|test_boxes_brin_idx))');
    --RAISE NOTICE 'MAT: %', mat;
    IF mat IS NOT NULL THEN
      ret := array_append(ret, mat[1]);
    END IF;
    --RAISE NOTICE 'RET: %', ret;
  END LOOP;
  RETURN array_to_string(ret,',');
END;
$$;

CREATE INDEX test_boxes_brin_idx ON test_boxes USING brin (b);

SET enable_indexscan = OFF;
SET enable_bitmapscan = OFF;
SET enable_seqscan = ON;

SELECT 'scan_seq', qnodes('SELECT * FROM test_boxes WHERE b <@ sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_boxes WHERE b <@ sbox '( (10d,10d), (20d,20d) )';

SELECT 'scan_seq', qnodes('SELECT * FROM test_boxes WHERE b && sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_boxes WHERE b && sbox '( (10d,10d), (20d,20d) )';

SET enable_indexscan = OFF;
SET enable_bitmapscan = ON;
SET enable_seqscan = OFF;

SELECT 'scan_idx', qnodes('SELECT * FROM test_boxes WHERE b <@ sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_boxes WHERE b <@ sbox '( (10d,10d), (20d,20d) )';

SELECT 'scan_idx', qnodes('SELECT * FROM test_boxes WHERE b && sbox ''( (10d,10d), (20d,20d) )''');
SELECT * FROM test_boxes WHERE b && sbox '( (10d,10d), (20d,20d) )';

---- cleanup
DROP INDEX test_boxes_brin_idx;
DROP TABLE test_boxes;
DROP FUNCTION qnodes(text);

SET enable_indexscan = ON;
SET enable_bitmapscan = ON;
SET enable_seqscan = ON;
