/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../src/p2kmoto.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void onFile(p2k_fileInfo nfo)
{
	printf("%4d %6ld %3d %3d %s\n",nfo.id, nfo.size, nfo.owner, nfo.attr, nfo.name );
}

int main(void)
{
	
	printf("P2k Test\n");
	p2k_init();
	
	printf("Device list:\n");
	p2k_devInfo * nfo;
	int i=0;

	nfo=p2k_getDevList();	
		
	while (nfo[i].vendor>=0)
	{
		printf("%04x:%04x: [%s] [%s]\n", nfo[i].vendor, nfo[i].product,
			   nfo[i].manufacturerStr, nfo[i].productStr);
		i++;
	}
	
	int state=p2k_findPhone();
	
	if (state==P2K_PHONE_AT)
	{
		//We must switch phone to p2k mode by sending AT+MODE=8 command.
		printf("Switching to P2K...\n");
		// This is hardcode to /dev/ttyACM0
		system("echo \"AT+MODE=8\" > /dev/ttyACM0");
		// Wait when phone change mode...
		sleep(5);
		state=p2k_findPhone();
	}	
	
	if (state==P2K_PHONE_NONE)
	{
		printf("No phone found.\n");
		return;
	}
	
	printf("P2k Phone found\n\n");
	p2k_openPhone();	
	long sz;
	char s[200];
	if (p2k_getPhoneModel((unsigned char *)s)>0)
		printf("Phone Model: %s\n", s);
	else
		printf("Can not get phone model\n");
	
	if (p2k_getDriveName(s)>0)
		printf("Drive: %s\n", s);
	else
		printf("Can not get drive name\n");
	
	sz=p2k_freeSpace(s);
	if (sz>0)
		printf("Free space: %ld bytes\n", sz);
	else
		printf("Can not get free space");
	
	sz=p2k_fileCount();
	if (sz>0)
		printf("File count: %ld bytes\n", sz);
	else
		printf("Can not get file count");
	
	p2k_fileList(onFile);
			
	p2k_closePhone();
}
