'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No warranty. None. Use at your own risk.
'\"
.TH DS1993 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS1993
\- 4kbit Memory iButton
.SH SYNOPSIS
Non-volatile memory.
.PP
.B 06
[.]XXXXXXXXXXXX[XX][/[
.B memory
|
.B pages/page.[0-15|ALL]
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 06
DS1996
.SH SPECIAL PROPERTIES
.SS memory
.I read-write, binary
.br
512 bytes of memory.
.SS pages/page.0 ... pages/page.15 pages/page.ALL
.I read-write, binary
.br
Memory is split into 16 pages of 32 bytes each.
.I ALL
is an aggregate of the pages. Each page is accessed sequentially.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None.
.SH DESCRIPTION
.so man3/description.3so
.SS DS1993
The
.B DS1993 (3)
is an iButton with static memory. Data is read/written with error checking (transparent to the user).
The
.B DS1992
,
.B DS1993
,
.B DS1995
, and
.B DS1996
differ in their function by the amount of on-board memory they possess. (The internal protocols are slightly different, but the
.I OWFS
system handles this automatically.)
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS1992-DS1993.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
