/*
 * Correctly rounded arcsine
 *
 * Copyright (C) 2004-2011 David Defour, Catherine Daramy-Loirat,
 * Florent de Dinechin, Matthieu Gallet, Nicolas Gast, Christoph Quirin Lauter,
 * and Jean-Michel Muller
 *
 * This file is part of crlibm, the correctly rounded mathematical library,
 * which has been developed by the Arénaire project at École normale supérieure
 * de Lyon.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "crlibm.h"
#include "crlibm_private.h"

/* File generated by maple/asin-td.mpl */

/* High order words of interval bounds (low order word is 0) */
#define BOUND1 0x3FC7AE14
#define BOUND2 0x3FD32E91
#define BOUND3 0x3FD9CA24
#define BOUND4 0x3FDF90B3
#define BOUND5 0x3FE23ADC
#define BOUND6 0x3FE4781D
#define BOUND7 0x3FE647BB
#define BOUND8 0x3FE7BC81
#define BOUND9 0x3FE8F5C2
#define EXTRABOUND 0x3F500000


/* Pi/2 as a triple-double*/
#define PIHALFH 1.57079632679489655799898173427209258079528808593750e+00
#define PIHALFM 6.12323399573676603586882014729198302312846062338790e-17
#define PIHALFL -1.49738490485916983294350817710599200835275047616952e-33


/* Indices to the following table */
#define TBLIDX2 36
#define TBLIDX3 97
#define TBLIDX4 158
#define TBLIDX5 219
#define TBLIDX6 280
#define TBLIDX7 341
#define TBLIDX8 402
#define TBLIDX9 463
#define TBLIDX10 524


/* Table with midpoints and polynomial coefficients */
static const double tbl[580] = {
1.66666666666666657414808128123695496469736099243164e-01, 	/* 0, accPolyLowC3h, quickPolyLowC3h */
9.25185853854297065661561206416060845590588197735272e-18, 	/* 1, accPolyLowC3m, quickPolyLowC3l */
5.13580782192052290146917464639635163327575367072527e-34, 	/* 2, accPolyLowC3l */
7.49999999999999972244424384371086489409208297729492e-02, 	/* 3, accPolyLowC5h, quickPolyLowC5h */
2.77555756156289150513347472120591902572823540679419e-18, 	/* 4, accPolyLowC5m, quickPolyLowC5l */
-1.43929408167863119589461549455410834291155585333144e-34, 	/* 5, accPolyLowC5l */
4.46428571428571438484134148438897682353854179382324e-02, 	/* 6, accPolyLowC7h, quickPolyLowC7h */
-9.91270557701064540788749549275225920938048550224136e-19, 	/* 7, accPolyLowC7m, quickPolyLowC7l */
3.33748090721822991762574824757600091731436462508019e-35, 	/* 8, accPolyLowC7l */
3.03819444444444440589503386718206456862390041351318e-02, 	/* 9, accPolyLowC9h, quickPolyLowC9h */
3.85494105812324030564107341625454073114449944250081e-19, 	/* 10, accPolyLowC9m, quickPolyLowC9l */
-1.43865090242821346711405668429425189868490718470116e-36, 	/* 11, accPolyLowC9l */
2.23721590909090918553037141691675060428678989410400e-02, 	/* 12, accPolyLowC11h, quickPolyLowC11h */
-9.46212831143868745925658651601400487408631908148174e-19, 	/* 13, accPolyLowC11m, quickPolyLowC11l */
2.71756033709005426155900473576766627205226477546134e-36, 	/* 14, accPolyLowC11l */
1.73527644230769238775646812200648128055036067962646e-02, 	/* 15, accPolyLowC13h, quickPolyLowC13h */
-8.00631194349979385750725428497500824341216859291999e-19, 	/* 16, accPolyLowC13m */
1.39648437500000006938893903907228377647697925567627e-02, 	/* 17, accPolyLowC15h, quickPolyLowC15h */
-6.96640576418186252434826298980545123112053091491650e-19, 	/* 18, accPolyLowC15m */
1.15518008961397068007359578700743441004306077957153e-02, 	/* 19, accPolyLowC17h, quickPolyLowC17h */
-4.10583074045422929898575008733550170923265860856307e-19, 	/* 20, accPolyLowC17m */
9.76160952919401074534544449079476180486381053924561e-03, 	/* 21, accPolyLowC19h, quickPolyLowC19h */
3.58257464358998522024321439568214748872569190564464e-19, 	/* 22, accPolyLowC19m */
8.39033580962353364718353532225592061877250671386719e-03, 	/* 23, accPolyLowC21h, quickPolyLowC21h */
7.09494992486164270601178799400238696830257336508353e-20, 	/* 24, accPolyLowC21m */
7.31252587309846099200560942676929698791354894638062e-03, 	/* 25, accPolyLowC23h */
3.10147942381298802750887889395221073583507364742961e-19, 	/* 26, accPolyLowC23m */
6.44721034012319445943850482194648066069930791854858e-03, 	/* 27, accPolyLowC25h */
5.74003646399263555560876781669321644585579633712769e-03, 	/* 28, accPolyLowC27h */
5.15334845775329911110596015078044729307293891906738e-03, 	/* 29, accPolyLowC29h */
4.65922376559379288613049752143524528946727514266968e-03, 	/* 30, accPolyLowC31h */
4.25648267385331235956869022629689425230026245117188e-03, 	/* 31, accPolyLowC33h */
3.70384206863821549560178425508638611063361167907715e-03, 	/* 32, accPolyLowC35h */
4.76149788232017000255691385746104060672223567962646e-03, 	/* 33, accPolyLowC37h */
1.01829039548491739886060258868383243680000305175781e+00, 	/* 34, RN rounding constant quick poly low*/
9.99456520626465193846360776661410034560333454445527e-19, 	/* 35, RD rounding constant quick poly low*/
2.42358565330489938993707710324088111519813537597656e-01, 	/* 36, midpoint in interval 2*/
2.44796158322043572175275016888917889446020126342773e-01, 	/* 37, accPolyMid2C0h, quickPolyMid2C0h */
-7.80764437719474476036120943295127199090063761923808e-18, 	/* 38, accPolyMid2C0m, quickPolyMid2C0l */
1.03072939530366736171629327145637944340705871582031e+00, 	/* 39, accPolyMid2C1h, quickPolyMid2C1h */
-8.85738929015520959086405013050480695702241994387953e-17, 	/* 40, accPolyMid2C1m, quickPolyMid2C1l */
-3.43332793693232296155057781643135490790330671255580e-33, 	/* 41, accPolyMid2C1l */
1.32697384480218755209435244069027248769998550415039e-01, 	/* 42, accPolyMid2C2h, quickPolyMid2C2h */
-3.05519908299053827321743308736081906443885446585898e-18, 	/* 43, accPolyMid2C2m, quickPolyMid2C2l */
1.84968471282800310046349200266639560111473343387153e-34, 	/* 44, accPolyMid2C2l */
2.16675601140875473404889817174989730119705200195312e-01, 	/* 45, accPolyMid2C3h, quickPolyMid2C3h */
-1.09855192148394476119822843562855651270724326884774e-18, 	/* 46, accPolyMid2C3m, quickPolyMid2C3l */
1.30965185306611444030805369954695892224998714815939e-35, 	/* 47, accPolyMid2C3l */
1.16730419643667523987851097899692831560969352722168e-01, 	/* 48, accPolyMid2C4h, quickPolyMid2C4h */
4.87619704882669077472238320833491156897798846867617e-18, 	/* 49, accPolyMid2C4m, quickPolyMid2C4l */
2.44421677078199513698242322477237313066476585423275e-34, 	/* 50, accPolyMid2C4l */
1.45667026718228842518954024853883311152458190917969e-01, 	/* 51, accPolyMid2C5h, quickPolyMid2C5h */
5.36594969153474426628449995112694156468179831261122e-19, 	/* 52, accPolyMid2C5m, quickPolyMid2C5l */
8.48516201835513020738766305454795330663195678132569e-36, 	/* 53, accPolyMid2C5l */
1.22401266966440255834491779296513414010405540466309e-01, 	/* 54, accPolyMid2C6h, quickPolyMid2C6h */
-2.20822551943355103564859204431825679093840107651564e-19, 	/* 55, accPolyMid2C6m, quickPolyMid2C6l */
-8.07441439403117291580512089023909180599052269668925e-36, 	/* 56, accPolyMid2C6l */
1.41642750696223979067767118067422416061162948608398e-01, 	/* 57, accPolyMid2C7h, quickPolyMid2C7h */
8.52401858052517523392878261510621535534995050169401e-18, 	/* 58, accPolyMid2C7m, quickPolyMid2C7l */
1.42861418735328621343327881731966044753789901733398e-01, 	/* 59, accPolyMid2C8h, quickPolyMid2C8h */
-1.33006668328318919665132697553096363383321713310227e-17, 	/* 60, accPolyMid2C8m */
1.63718343060216098283632391030550934374332427978516e-01, 	/* 61, accPolyMid2C9h, quickPolyMid2C9h */
6.13394557799256408251130704849071363459255390907063e-18, 	/* 62, accPolyMid2C9m */
1.79592723769284340340490757625957485288381576538086e-01, 	/* 63, accPolyMid2C10h, quickPolyMid2C10h */
-1.30198260064097970981442998070110461849845662150849e-17, 	/* 64, accPolyMid2C10m */
2.07951828711086583734157784419949166476726531982422e-01, 	/* 65, accPolyMid2C11h, quickPolyMid2C11h */
-1.26159975996932877835486818675875580593424383227469e-17, 	/* 66, accPolyMid2C11m */
2.38247271379822073145149374795437324792146682739258e-01, 	/* 67, accPolyMid2C12h, quickPolyMid2C12h */
6.62361216505959744828122635016705548667940611263800e-18, 	/* 68, accPolyMid2C12m */
2.79893913215572998076652311283396556973457336425781e-01, 	/* 69, accPolyMid2C13h, quickPolyMid2C13h */
-2.24149827195062967543013296493616902343167004009288e-17, 	/* 70, accPolyMid2C13m */
3.28958991769599307097848850389709696173667907714844e-01, 	/* 71, accPolyMid2C14h, quickPolyMid2C14h */
-1.05211249452308945191032281708802957418482198191124e-17, 	/* 72, accPolyMid2C14m */
3.91766249806127564436764032507198862731456756591797e-01, 	/* 73, accPolyMid2C15h */
-2.02194096713130520849748106020797136930683180643846e-17, 	/* 74, accPolyMid2C15m */
4.68246642053942785377529389734263531863689422607422e-01, 	/* 75, accPolyMid2C16h */
5.64148787932559847568825261987512931227684020996094e-01, 	/* 76, accPolyMid2C17h */
6.82488400757435664800709673727396875619888305664062e-01, 	/* 77, accPolyMid2C18h */
8.30182127559316640486031246837228536605834960937500e-01, 	/* 78, accPolyMid2C19h */
1.01367533043020308092252435017144307494163513183594e+00, 	/* 79, accPolyMid2C20h */
1.24281078928695176699648072826676070690155029296875e+00, 	/* 80, accPolyMid2C21h */
1.52877587404435177909078902303008362650871276855469e+00, 	/* 81, accPolyMid2C22h */
1.88667637664635656769007709954166784882545471191406e+00, 	/* 82, accPolyMid2C23h */
2.33494551765288571587575461308006197214126586914062e+00, 	/* 83, accPolyMid2C24h */
2.89749244536000327698843648249749094247817993164062e+00, 	/* 84, accPolyMid2C25h */
3.60426450740106130155027130967937409877777099609375e+00, 	/* 85, accPolyMid2C26h */
4.49361107526955017021919047692790627479553222656250e+00, 	/* 86, accPolyMid2C27h */
5.61406255377128715622347954194992780685424804687500e+00, 	/* 87, accPolyMid2C28h */
7.02754870503224271516273802262730896472930908203125e+00, 	/* 88, accPolyMid2C29h */
8.81280667340759649164283473510295152664184570312500e+00, 	/* 89, accPolyMid2C30h */
1.10704407960507111852166417520493268966674804687500e+01, 	/* 90, accPolyMid2C31h */
1.39282518419665830577969245496205985546112060546875e+01, 	/* 91, accPolyMid2C32h */
1.75308292529565719064521545078605413436889648437500e+01, 	/* 92, accPolyMid2C33h */
2.21169075633838900785121950320899486541748046875000e+01, 	/* 93, accPolyMid2C34h */
2.93386309556562245859367976663634181022644042968750e+01, 	/* 94, accPolyMid2C35h */
1.01656637119000103908206256164703518152236938476562e+00, 	/* 95, RN rounding constant quick poly middle 2*/
9.05249299973766985475925981961240072045593429326050e-19, 	/* 96, RD rounding constant quick poly middle 2*/
3.51339936256424290039745983449392952024936676025391e-01, 	/* 97, midpoint in interval 3*/
3.59001896704258527392994437832385301589965820312500e-01, 	/* 98, accPolyMid3C0h, quickPolyMid3C0h */
7.25234535377983806008993135801969933842904099082037e-20, 	/* 99, accPolyMid3C0m, quickPolyMid3C0l */
1.06809311097735548656828541425056755542755126953125e+00, 	/* 100, accPolyMid3C1h, quickPolyMid3C1h */
8.06569140638077604165107730077659782400969546746483e-17, 	/* 101, accPolyMid3C1m, quickPolyMid3C1l */
-5.04406564603486171676187418521136112402329884904383e-33, 	/* 102, accPolyMid3C1l */
2.14054747447713134000935042422497645020484924316406e-01, 	/* 103, accPolyMid3C2h, quickPolyMid3C2h */
9.76056255097027764696827253384241478483311533093656e-18, 	/* 104, accPolyMid3C2m, quickPolyMid3C2l */
-7.76857615284538540734861101748988881714638362963881e-35, 	/* 105, accPolyMid3C2l */
2.88880884175958529969108212753781117498874664306641e-01, 	/* 106, accPolyMid3C3h, quickPolyMid3C3h */
2.22181200821645624650165429361546283225838059740631e-17, 	/* 107, accPolyMid3C3m, quickPolyMid3C3l */
-1.14368045348414878337189405350442917783836545775590e-33, 	/* 108, accPolyMid3C3l */
2.26134851489718013972662902233423665165901184082031e-01, 	/* 109, accPolyMid3C4h, quickPolyMid3C4h */
-8.04753534970505104224953947907869405284151781535028e-18, 	/* 110, accPolyMid3C4m, quickPolyMid3C4l */
4.22557384286705919324956002465313457843707737945963e-34, 	/* 111, accPolyMid3C4l */
2.75196923580072527748541233449941501021385192871094e-01, 	/* 112, accPolyMid3C5h, quickPolyMid3C5h */
-1.17338666986909136966078634618924264888220762222419e-18, 	/* 113, accPolyMid3C5m, quickPolyMid3C5l */
-4.68757737099062213529607300203132104484914350463871e-35, 	/* 114, accPolyMid3C5l */
3.03044495521890500100425924756564199924468994140625e-01, 	/* 115, accPolyMid3C6h, quickPolyMid3C6h */
-2.27411416594910816511289518687103845115091724313899e-17, 	/* 116, accPolyMid3C6m, quickPolyMid3C6l */
2.34762544350785348445971766662785127027332739123595e-34, 	/* 117, accPolyMid3C6l */
3.77749573081396394780284708758699707686901092529297e-01, 	/* 118, accPolyMid3C7h, quickPolyMid3C7h */
7.89247891096042648893247867692397394548591651092283e-18, 	/* 119, accPolyMid3C7m, quickPolyMid3C7l */
4.68287147615184806692667507377336733043193817138672e-01, 	/* 120, accPolyMid3C8h, quickPolyMid3C8h */
1.75668374099909928545987828472120658936175220036884e-17, 	/* 121, accPolyMid3C8m */
6.06111063535901939403061078337486833333969116210938e-01, 	/* 122, accPolyMid3C9h, quickPolyMid3C9h */
1.72730090011832304135009947489517024111046794620020e-17, 	/* 123, accPolyMid3C9m */
7.92895790821915635859795656870119273662567138671875e-01, 	/* 124, accPolyMid3C10h, quickPolyMid3C10h */
4.98295614974968378037947765656866085023078681863398e-17, 	/* 125, accPolyMid3C10m */
1.05810730062141522545005045685684308409690856933594e+00, 	/* 126, accPolyMid3C11h, quickPolyMid3C11h */
8.05577049603995800072512132781137905047707942749781e-17, 	/* 127, accPolyMid3C11m */
1.42745521004660447239587028889218345284461975097656e+00, 	/* 128, accPolyMid3C12h, quickPolyMid3C12h */
-4.55985728468522936328504707804310204497673421624067e-17, 	/* 129, accPolyMid3C12m */
1.94854789175488596342233904579188674688339233398438e+00, 	/* 130, accPolyMid3C13h, quickPolyMid3C13h */
3.84783704422594121999348237839996274693704597202448e-17, 	/* 131, accPolyMid3C13m */
2.68312408725385909136207374103832989931106567382812e+00, 	/* 132, accPolyMid3C14h, quickPolyMid3C14h */
-3.56068007836116005017028996147996121343986693197868e-17, 	/* 133, accPolyMid3C14m */
3.72473732217660824517224682494997978210449218750000e+00, 	/* 134, accPolyMid3C15h */
-5.87298986037438700709055565377465605786708153319628e-17, 	/* 135, accPolyMid3C15m */
5.20573944915823361156981263775378465652465820312500e+00, 	/* 136, accPolyMid3C16h */
7.31989734855592644180433126166462898254394531250000e+00, 	/* 137, accPolyMid3C17h */
1.03473141302088169624084912356920540332794189453125e+01, 	/* 138, accPolyMid3C18h */
1.46964937699531184023271634941920638084411621093750e+01, 	/* 139, accPolyMid3C19h */
2.09624579630017748854697856586426496505737304687500e+01, 	/* 140, accPolyMid3C20h */
3.00147629377676423700904706493020057678222656250000e+01, 	/* 141, accPolyMid3C21h */
4.31254748908798717366153141483664512634277343750000e+01, 	/* 142, accPolyMid3C22h */
6.21591110441626426563743734732270240783691406250000e+01, 	/* 143, accPolyMid3C23h */
8.98523523311889533715657307766377925872802734375000e+01, 	/* 144, accPolyMid3C24h */
1.30228138287161243624723283573985099792480468750000e+02, 	/* 145, accPolyMid3C25h */
1.89208159704443204418566892854869365692138671875000e+02, 	/* 146, accPolyMid3C26h */
2.75520543663640125942038139328360557556152343750000e+02, 	/* 147, accPolyMid3C27h */
4.02045721388318213485035812482237815856933593750000e+02, 	/* 148, accPolyMid3C28h */
5.87814144421144646912580356001853942871093750000000e+02, 	/* 149, accPolyMid3C29h */
8.60974558223577218996069859713315963745117187500000e+02, 	/* 150, accPolyMid3C30h */
1.26323081508058703548158518970012664794921875000000e+03, 	/* 151, accPolyMid3C31h */
1.85633061099108476810215506702661514282226562500000e+03, 	/* 152, accPolyMid3C32h */
2.72831792235129523760406300425529479980468750000000e+03, 	/* 153, accPolyMid3C33h */
4.02017366871190233723609708249568939208984375000000e+03, 	/* 154, accPolyMid3C34h */
6.26169941241203287063399329781532287597656250000000e+03, 	/* 155, accPolyMid3C35h */
1.01822826558956558429258620890323072671890258789062e+00, 	/* 156, RN rounding constant quick poly middle 3*/
9.96061507703610851328544443284249848383807032724405e-19, 	/* 157, RD rounding constant quick poly middle 3*/
4.48084712028450460330475380033021792769432067871094e-01, 	/* 158, midpoint in interval 4*/
4.64621784296265272207193675058078952133655548095703e-01, 	/* 159, accPolyMid4C0h, quickPolyMid4C0h */
5.46463478154141631687941857567549378870836612391668e-19, 	/* 160, accPolyMid4C0m, quickPolyMid4C0l */
1.11857936563137916330390453367726877331733703613281e+00, 	/* 161, accPolyMid4C1h, quickPolyMid4C1h */
-7.52084787570938032181667127523977366268049041253541e-17, 	/* 162, accPolyMid4C1m, quickPolyMid4C1l */
-2.09600667283052949148765250630641631769479132030207e-33, 	/* 163, accPolyMid4C1l */
3.13567137932624417917537584798992611467838287353516e-01, 	/* 164, accPolyMid4C2h, quickPolyMid4C2h */
-4.41710443385272069717070263863657699262849649693148e-18, 	/* 165, accPolyMid4C2m, quickPolyMid4C2l */
-1.66857777421172326251970639278136259133415308172276e-34, 	/* 166, accPolyMid4C2l */
4.09066962553200574870260197712923400104045867919922e-01, 	/* 167, accPolyMid4C3h, quickPolyMid4C3h */
-1.77243968292023797220078441566237340174840093946990e-17, 	/* 168, accPolyMid4C3m, quickPolyMid4C3l */
1.04993340346633219191766382762445818927028795922212e-33, 	/* 169, accPolyMid4C3l */
4.17460970109683637829789404349867254495620727539062e-01, 	/* 170, accPolyMid4C4h, quickPolyMid4C4h */
1.39418041407988360348752433713233257018150500547568e-17, 	/* 171, accPolyMid4C4m, quickPolyMid4C4l */
1.44515287253394191526867297316859284672731580248765e-33, 	/* 172, accPolyMid4C4l */
5.57995436127318722441259524202905595302581787109375e-01, 	/* 173, accPolyMid4C5h, quickPolyMid4C5h */
4.36037702989507667583407786816694605825360677277616e-17, 	/* 174, accPolyMid4C5m, quickPolyMid4C5l */
-1.19172250052693786129959971158569652849573416545361e-33, 	/* 175, accPolyMid4C5l */
7.47841169204912281642805282899644225835800170898438e-01, 	/* 176, accPolyMid4C6h, quickPolyMid4C6h */
-6.76313448015089834151929838334258544557222273487418e-18, 	/* 177, accPolyMid4C6m, quickPolyMid4C6l */
-3.47721914174083040302762713955940912153154957518196e-34, 	/* 178, accPolyMid4C6l */
1.07444730844797153856973181973444297909736633300781e+00, 	/* 179, accPolyMid4C7h, quickPolyMid4C7h */
7.55340134261966180374112563614849022138812950329448e-17, 	/* 180, accPolyMid4C7m, quickPolyMid4C7l */
1.58041645549890685806815326941432431340217590332031e+00, 	/* 181, accPolyMid4C8h, quickPolyMid4C8h */
4.80894355381610072868748091065730787867334028863435e-17, 	/* 182, accPolyMid4C8m */
2.39169226022640657447482226416468620300292968750000e+00, 	/* 183, accPolyMid4C9h, quickPolyMid4C9h */
1.26753183127964275508490032426937968441812593935712e-16, 	/* 184, accPolyMid4C9m */
3.68572936227336489523054297023918479681015014648438e+00, 	/* 185, accPolyMid4C10h, quickPolyMid4C10h */
-1.41660589025860946857878120315437315934718409357086e-16, 	/* 186, accPolyMid4C10m */
5.77285150262833735013145997072570025920867919921875e+00, 	/* 187, accPolyMid4C11h, quickPolyMid4C11h */
-2.16740363176565772841534018366824459554498708631527e-16, 	/* 188, accPolyMid4C11m */
9.15766592727227646264509530737996101379394531250000e+00, 	/* 189, accPolyMid4C12h, quickPolyMid4C12h */
4.37180613264180824186691777532090455983551321485214e-16, 	/* 190, accPolyMid4C12m */
1.46862422532599090629901184001937508583068847656250e+01, 	/* 191, accPolyMid4C13h, quickPolyMid4C13h */
7.89614550363306335166404831558856161121412865593061e-16, 	/* 192, accPolyMid4C13m */
2.37692237950290667924946319544687867164611816406250e+01, 	/* 193, accPolyMid4C14h, quickPolyMid4C14h */
-3.50255834101571646092598176937562449597971181913456e-16, 	/* 194, accPolyMid4C14m */
3.87753699929054533868111320771276950836181640625000e+01, 	/* 195, accPolyMid4C15h */
5.67060321723933067329766411373458413340348986762113e-16, 	/* 196, accPolyMid4C15m */
6.36909499334141528947839105967432260513305664062500e+01, 	/* 197, accPolyMid4C16h */
1.05248620915111246176820714026689529418945312500000e+02, 	/* 198, accPolyMid4C17h */
1.74851057791898000459696049802005290985107421875000e+02, 	/* 199, accPolyMid4C18h */
2.91864013611726591079786885529756546020507812500000e+02, 	/* 200, accPolyMid4C19h */
4.89259682748188197365379892289638519287109375000000e+02, 	/* 201, accPolyMid4C20h */
8.23309003242859603233227971941232681274414062500000e+02, 	/* 202, accPolyMid4C21h */
1.39025484827954846878128591924905776977539062500000e+03, 	/* 203, accPolyMid4C22h */
2.35504246227568182803224772214889526367187500000000e+03, 	/* 204, accPolyMid4C23h */
4.00090205201026492431992664933204650878906250000000e+03, 	/* 205, accPolyMid4C24h */
6.81504309301592911651823669672012329101562500000000e+03, 	/* 206, accPolyMid4C25h */
1.16369648030766729789320379495620727539062500000000e+04, 	/* 207, accPolyMid4C26h */
1.99154708390699779556598514318466186523437500000000e+04, 	/* 208, accPolyMid4C27h */
3.41546126991757555515505373477935791015625000000000e+04, 	/* 209, accPolyMid4C28h */
5.86883344113872444722801446914672851562500000000000e+04, 	/* 210, accPolyMid4C29h */
1.01027682393336552195250988006591796875000000000000e+05, 	/* 211, accPolyMid4C30h */
1.74209975080082920612767338752746582031250000000000e+05, 	/* 212, accPolyMid4C31h */
3.00874278784890950191766023635864257812500000000000e+05, 	/* 213, accPolyMid4C32h */
5.19633023773909430019557476043701171875000000000000e+05, 	/* 214, accPolyMid4C33h */
8.99866392232198733836412429809570312500000000000000e+05, 	/* 215, accPolyMid4C34h */
1.65235977806337876245379447937011718750000000000000e+06, 	/* 216, accPolyMid4C35h */
1.01836010491198658556299960764590650796890258789062e+00, 	/* 217, RN rounding constant quick poly middle 4*/
1.00326570788492020170486150590740535840759810902416e-18, 	/* 218, RD rounding constant quick poly middle 4*/
5.31445860862679642089290155126946046948432922363281e-01, 	/* 219, midpoint in interval 5*/
5.60306504963744567149319664167705923318862915039062e-01, 	/* 220, accPolyMid5C0h, quickPolyMid5C0h */
-1.08630439217163180480513733763948654678554607776160e-20, 	/* 221, accPolyMid5C0m, quickPolyMid5C0l */
1.18050895658762322604218297783518210053443908691406e+00, 	/* 222, accPolyMid5C1h, quickPolyMid5C1h */
-3.44936676454714048889716658635127499762917269870727e-17, 	/* 223, accPolyMid5C1m, quickPolyMid5C1l */
-2.49069456197248953275668118371299181194287558355700e-33, 	/* 224, accPolyMid5C1l */
4.37156452058995781406736114149680361151695251464844e-01, 	/* 225, accPolyMid5C2h, quickPolyMid5C2h */
4.12350542001181384975859432610288269290340424486530e-18, 	/* 226, accPolyMid5C2m, quickPolyMid5C2l */
2.73553164822567581206451159459555826955342358406517e-34, 	/* 227, accPolyMid5C2l */
5.97961581435785594074161508615361526608467102050781e-01, 	/* 228, accPolyMid5C3h, quickPolyMid5C3h */
1.15786235462823532242451850040378867919657187923266e-17, 	/* 229, accPolyMid5C3m, quickPolyMid5C3l */
6.70476163820618923333949946465040969013104876616743e-34, 	/* 230, accPolyMid5C3l */
7.56654591443305823972309553937520831823348999023438e-01, 	/* 231, accPolyMid5C4h, quickPolyMid5C4h */
5.63361768523770903650379304980880430544181403662856e-18, 	/* 232, accPolyMid5C4m, quickPolyMid5C4l */
3.52518369310847108975654467573884198459173315811765e-35, 	/* 233, accPolyMid5C4l */
1.15954888868330963092034835426602512598037719726562e+00, 	/* 234, accPolyMid5C5h, quickPolyMid5C5h */
-2.13088606479945404910718732635657047999226786224539e-17, 	/* 235, accPolyMid5C5m, quickPolyMid5C5l */
1.01155988751211667735165829625236622533486662424891e-33, 	/* 236, accPolyMid5C5l */
1.85057068266552660062984614341985434293746948242188e+00, 	/* 237, accPolyMid5C6h, quickPolyMid5C6h */
-4.13756595773451122099466439202037064387337671566669e-18, 	/* 238, accPolyMid5C6m, quickPolyMid5C6l */
3.02843501360506226132120912500822054694900989592884e-34, 	/* 239, accPolyMid5C6l */
3.11563743870884257702869035711046308279037475585938e+00, 	/* 240, accPolyMid5C7h, quickPolyMid5C7h */
-5.06302300821373603583774676357699499992045551579126e-17, 	/* 241, accPolyMid5C7m, quickPolyMid5C7l */
5.40761322601296168244289219728671014308929443359375e+00, 	/* 242, accPolyMid5C8h, quickPolyMid5C8h */
2.97487923575735998744301300115136435889001285861472e-16, 	/* 243, accPolyMid5C8m */
9.62995354897343425193412258522585034370422363281250e+00, 	/* 244, accPolyMid5C9h, quickPolyMid5C9h */
4.55607422255092503960684830342258039056296500032145e-16, 	/* 245, accPolyMid5C9m */
1.74836661195630966858516330830752849578857421875000e+01, 	/* 246, accPolyMid5C10h, quickPolyMid5C10h */
1.43590320985440421817158000882140332196152266840822e-15, 	/* 247, accPolyMid5C10m */
3.22483723360128990975681517738848924636840820312500e+01, 	/* 248, accPolyMid5C11h, quickPolyMid5C11h */
-3.34403568343416729924334128939506733422536740966968e-15, 	/* 249, accPolyMid5C11m */
6.02553715792408368656651873607188463211059570312500e+01, 	/* 250, accPolyMid5C12h, quickPolyMid5C12h */
3.10919444878682139369989784864394611534570535618660e-15, 	/* 251, accPolyMid5C12m */
1.13813051318643047693512926343828439712524414062500e+02, 	/* 252, accPolyMid5C13h, quickPolyMid5C13h */
-1.71698317353737059559128975443274184793142084909379e-15, 	/* 253, accPolyMid5C13m */
2.16961936728312849709254805929958820343017578125000e+02, 	/* 254, accPolyMid5C14h, quickPolyMid5C14h */
8.27079867974059458294192504441253562124411295719550e-15, 	/* 255, accPolyMid5C14m */
4.16880179488225451223115669563412666320800781250000e+02, 	/* 256, accPolyMid5C15h */
-2.58735460985196142054738964992050729251298751831811e-14, 	/* 257, accPolyMid5C15m */
8.06537874996876666955358814448118209838867187500000e+02, 	/* 258, accPolyMid5C16h */
1.56984649251497876321082003414630889892578125000000e+03, 	/* 259, accPolyMid5C17h */
3.07188686658870074097649194300174713134765625000000e+03, 	/* 260, accPolyMid5C18h */
6.03970064736507720226654782891273498535156250000000e+03, 	/* 261, accPolyMid5C19h */
1.19254227020427806564839556813240051269531250000000e+04, 	/* 262, accPolyMid5C20h */
2.36373073951149926870130002498626708984375000000000e+04, 	/* 263, accPolyMid5C21h */
4.70144622759458434302359819412231445312500000000000e+04, 	/* 264, accPolyMid5C22h */
9.38077422737224260345101356506347656250000000000000e+04, 	/* 265, accPolyMid5C23h */
1.87716130978103727102279663085937500000000000000000e+05, 	/* 266, accPolyMid5C24h */
3.76631599838992522563785314559936523437500000000000e+05, 	/* 267, accPolyMid5C25h */
7.57518066926909843459725379943847656250000000000000e+05, 	/* 268, accPolyMid5C26h */
1.52703698454281571321189403533935546875000000000000e+06, 	/* 269, accPolyMid5C27h */
3.08471154002460883930325508117675781250000000000000e+06, 	/* 270, accPolyMid5C28h */
6.24343584097426943480968475341796875000000000000000e+06, 	/* 271, accPolyMid5C29h */
1.26595813738393746316432952880859375000000000000000e+07, 	/* 272, accPolyMid5C30h */
2.57133891378295645117759704589843750000000000000000e+07, 	/* 273, accPolyMid5C31h */
5.23093272367429584264755249023437500000000000000000e+07, 	/* 274, accPolyMid5C32h */
1.06415184183835312724113464355468750000000000000000e+08, 	/* 275, accPolyMid5C33h */
2.17067016530691206455230712890625000000000000000000e+08, 	/* 276, accPolyMid5C34h */
4.69394759797544836997985839843750000000000000000000e+08, 	/* 277, accPolyMid5C35h */
1.01534217846377439187222080363426357507705688476562e+00, 	/* 278, RN rounding constant quick poly middle 5*/
8.45008379631082379626014328492746516799371469048044e-19, 	/* 279, RD rounding constant quick poly middle 5*/
6.04673624038476131836716831458033993840217590332031e-01, 	/* 280, midpoint in interval 6*/
6.49356027282211423212743284238968044519424438476562e-01, 	/* 281, accPolyMid6C0h, quickPolyMid6C0h */
-1.25840412187919035681267493345871686399113240956856e-20, 	/* 282, accPolyMid6C0m, quickPolyMid6C0l */
1.25553477869155938329015498311491683125495910644531e+00, 	/* 283, accPolyMid6C1h, quickPolyMid6C1h */
5.00523898265236280615595780032763663310079252366513e-17, 	/* 284, accPolyMid6C1m, quickPolyMid6C1l */
2.70452092654099855316456962656407597917508288905533e-33, 	/* 285, accPolyMid6C1l */
5.98380278107774499218862729321699589490890502929688e-01, 	/* 286, accPolyMid6C2h, quickPolyMid6C2h */
3.73915919375620074681511372815883902051293891666555e-18, 	/* 287, accPolyMid6C2m, quickPolyMid6C2l */
1.02836809807342008154037540277599096854529496615931e-34, 	/* 288, accPolyMid6C2l */
9.00232892880871604646131345361936837434768676757812e-01, 	/* 289, accPolyMid6C3h, quickPolyMid6C3h */
-1.70995008965645412422671790545314082452432030961170e-17, 	/* 290, accPolyMid6C3m, quickPolyMid6C3l */
1.26596066229657064182610642365044212709535948254084e-33, 	/* 291, accPolyMid6C3l */
1.38703629702026587366958665370475500822067260742188e+00, 	/* 292, accPolyMid6C4h, quickPolyMid6C4h */
3.98819447215487913236315415179165676291502931117595e-17, 	/* 293, accPolyMid6C4m, quickPolyMid6C4l */
-6.55797179513908183565792353381331895988112885430413e-34, 	/* 294, accPolyMid6C4l */
2.48954277308397298185127510805614292621612548828125e+00, 	/* 295, accPolyMid6C5h, quickPolyMid6C5h */
9.74092851599686234698415065747156883706428073441651e-17, 	/* 296, accPolyMid6C5m, quickPolyMid6C5l */
1.56743989943601791748641837689163542493404742470630e-33, 	/* 297, accPolyMid6C5l */
4.72562522409656082800211152061820030212402343750000e+00, 	/* 298, accPolyMid6C6h, quickPolyMid6C6h */
6.88679830761278595465306080986277758416307765996557e-18, 	/* 299, accPolyMid6C6m, quickPolyMid6C6l */
-9.47395090301458455484031652124848364407920780715874e-35, 	/* 300, accPolyMid6C6l */
9.41432957016690785678747488418594002723693847656250e+00, 	/* 301, accPolyMid6C7h, quickPolyMid6C7h */
8.62157085484702984705473460305131094967840256568931e-16, 	/* 302, accPolyMid6C7m, quickPolyMid6C7l */
1.93709907584273430813937011407688260078430175781250e+01, 	/* 303, accPolyMid6C8h, quickPolyMid6C8h */
-1.40839418808440953673043657798045432960211596437085e-16, 	/* 304, accPolyMid6C8m */
4.08734031574560177091370860580354928970336914062500e+01, 	/* 305, accPolyMid6C9h, quickPolyMid6C9h */
-2.98667469102598629922297846034715799734023919430673e-16, 	/* 306, accPolyMid6C9m */
8.79464044588732321017232607118785381317138671875000e+01, 	/* 307, accPolyMid6C10h, quickPolyMid6C10h */
3.61512961738881992095483091045503569454095245351219e-16, 	/* 308, accPolyMid6C10m */
1.92241339189846911494896630756556987762451171875000e+02, 	/* 309, accPolyMid6C11h, quickPolyMid6C11h */
6.61037281166591217605498682969545683054486597679533e-15, 	/* 310, accPolyMid6C11m */
4.25700873706194784062972757965326309204101562500000e+02, 	/* 311, accPolyMid6C12h, quickPolyMid6C12h */
-6.48144847243744916328196408044704617877580310816854e-15, 	/* 312, accPolyMid6C12m */
9.52958531675870517574367113411426544189453125000000e+02, 	/* 313, accPolyMid6C13h, quickPolyMid6C13h */
-3.41559781098088121115265032630996540232080319228480e-15, 	/* 314, accPolyMid6C13m */
2.15300037043921429358306340873241424560546875000000e+03, 	/* 315, accPolyMid6C14h, quickPolyMid6C14h */
-4.69254271757335955512545725611899433103182087412275e-14, 	/* 316, accPolyMid6C14m */
4.90290875724837587767979130148887634277343750000000e+03, 	/* 317, accPolyMid6C15h */
-4.54544125910656089453646656943432828883091406657613e-13, 	/* 318, accPolyMid6C15m */
1.12422266608999743766617029905319213867187500000000e+04, 	/* 319, accPolyMid6C16h */
2.59341556033402121101971715688705444335937500000000e+04, 	/* 320, accPolyMid6C17h */
6.01463753209276546840555965900421142578125000000000e+04, 	/* 321, accPolyMid6C18h */
1.40155647347781836288049817085266113281250000000000e+05, 	/* 322, accPolyMid6C19h */
3.27990517748617625329643487930297851562500000000000e+05, 	/* 323, accPolyMid6C20h */
7.70511269948243047110736370086669921875000000000000e+05, 	/* 324, accPolyMid6C21h */
1.81638100581354671157896518707275390625000000000000e+06, 	/* 325, accPolyMid6C22h */
4.29545835214607417583465576171875000000000000000000e+06, 	/* 326, accPolyMid6C23h */
1.01875211922164466232061386108398437500000000000000e+07, 	/* 327, accPolyMid6C24h */
2.42259292905952110886573791503906250000000000000000e+07, 	/* 328, accPolyMid6C25h */
5.77502706188629567623138427734375000000000000000000e+07, 	/* 329, accPolyMid6C26h */
1.37977551882563471794128417968750000000000000000000e+08, 	/* 330, accPolyMid6C27h */
3.30348046445899784564971923828125000000000000000000e+08, 	/* 331, accPolyMid6C28h */
7.92463843911740779876708984375000000000000000000000e+08, 	/* 332, accPolyMid6C29h */
1.90447027047677397727966308593750000000000000000000e+09, 	/* 333, accPolyMid6C30h */
4.58479383261657714843750000000000000000000000000000e+09, 	/* 334, accPolyMid6C31h */
1.10545369624155406951904296875000000000000000000000e+10, 	/* 335, accPolyMid6C32h */
2.66385731955786666870117187500000000000000000000000e+10, 	/* 336, accPolyMid6C33h */
6.43976383194783477783203125000000000000000000000000e+10, 	/* 337, accPolyMid6C34h */
1.66775070729799957275390625000000000000000000000000e+11, 	/* 338, accPolyMid6C35h */
1.02820225588634994728920446505071595311164855957031e+00, 	/* 339, RN rounding constant quick poly middle 6*/
1.54107813388901044122294580378974284123051351850249e-18, 	/* 340, RD rounding constant quick poly middle 6*/
6.67959213256959061233430929860332980751991271972656e-01, 	/* 341, midpoint in interval 7*/
7.31463137281961883751080222282325848937034606933594e-01, 	/* 342, accPolyMid7C0h, quickPolyMid7C0h */
8.54719742452471207894475172794621662948903828511743e-18, 	/* 343, accPolyMid7C0m, quickPolyMid7C0l */
1.34372862717732943771409281907835975289344787597656e+00, 	/* 344, accPolyMid7C1h, quickPolyMid7C1h */
-9.37080278359462608557638680730489336344772507156678e-17, 	/* 345, accPolyMid7C1m, quickPolyMid7C1l */
-3.73014429525577422762683976038701673929582903516469e-33, 	/* 346, accPolyMid7C1l */
8.10316454021746457314634426438715308904647827148438e-01, 	/* 347, accPolyMid7C2h, quickPolyMid7C2h */
2.83724520944754281479328686665519600224801269794297e-17, 	/* 348, accPolyMid7C2m, quickPolyMid7C2l */
5.82045706927347254178829289360700371297572159541923e-34, 	/* 349, accPolyMid7C2l */
1.38167386397960734178980146680260077118873596191406e+00, 	/* 350, accPolyMid7C3h, quickPolyMid7C3h */
2.02013329353188582679931981349209152232167295906717e-17, 	/* 351, accPolyMid7C3m, quickPolyMid7C3l */
6.40114855650846168897999343294667085370954557070054e-34, 	/* 352, accPolyMid7C3l */
2.57070122683855739609271040535531938076019287109375e+00, 	/* 353, accPolyMid7C4h, quickPolyMid7C4h */
-1.97101208773651620042078427599655545421327570922328e-16, 	/* 354, accPolyMid7C4m, quickPolyMid7C4l */
-5.16498810795509657208158829628186048443297866770160e-33, 	/* 355, accPolyMid7C4l */
5.46327133150128840810566543950699269771575927734375e+00, 	/* 356, accPolyMid7C5h, quickPolyMid7C5h */
4.46002282634806142830756936399426613343260291679165e-17, 	/* 357, accPolyMid7C5m, quickPolyMid7C5l */
1.00630542800586945033209683978834296850153546719007e-33, 	/* 358, accPolyMid7C5l */
1.23592045140328163910226066946052014827728271484375e+01, 	/* 359, accPolyMid7C6h, quickPolyMid7C6h */
-6.31168277706663387163074158423931222709606927382536e-16, 	/* 360, accPolyMid7C6m, quickPolyMid7C6l */
-2.86577343636081880556771704346742846876298657614067e-32, 	/* 361, accPolyMid7C6l */
2.92955857889283457495821494376286864280700683593750e+01, 	/* 362, accPolyMid7C7h, quickPolyMid7C7h */
1.68044477586948138119056363287999050823887212287311e-15, 	/* 363, accPolyMid7C7m, quickPolyMid7C7l */
7.17613428086569200559097225777804851531982421875000e+01, 	/* 364, accPolyMid7C8h, quickPolyMid7C8h */
6.23119826880857970524569208326049427014155061843592e-15, 	/* 365, accPolyMid7C8m */
1.80247733513940403327069361694157123565673828125000e+02, 	/* 366, accPolyMid7C9h, quickPolyMid7C9h */
5.02375884230076452151557056132473497202104361844532e-15, 	/* 367, accPolyMid7C9m */
4.61706463186508131002483423799276351928710937500000e+02, 	/* 368, accPolyMid7C10h, quickPolyMid7C10h */
1.87384815286128587607402694756722954854896712184598e-14, 	/* 369, accPolyMid7C10m */
1.20148795335111071835854090750217437744140625000000e+03, 	/* 370, accPolyMid7C11h, quickPolyMid7C11h */
2.60459063066423653270039910766913797650205005668189e-14, 	/* 371, accPolyMid7C11m */
3.16745162323707290852325968444347381591796875000000e+03, 	/* 372, accPolyMid7C12h, quickPolyMid7C12h */
-2.76092355337723539107271551080313829589234133482512e-14, 	/* 373, accPolyMid7C12m */
8.44145526317249823478050529956817626953125000000000e+03, 	/* 374, accPolyMid7C13h, quickPolyMid7C13h */
-2.33235416338613018856460888065680920494017469568604e-13, 	/* 375, accPolyMid7C13m */
2.27054147369064739905297756195068359375000000000000e+04, 	/* 376, accPolyMid7C14h, quickPolyMid7C14h */
-3.76196185348520617410321355221587231933578349130087e-13, 	/* 377, accPolyMid7C14m */
6.15579784849813586333766579627990722656250000000000e+04, 	/* 378, accPolyMid7C15h */
-5.34885488214934542022410271185570626302323293810304e-13, 	/* 379, accPolyMid7C15m */
1.68046954551722796168178319931030273437500000000000e+05, 	/* 380, accPolyMid7C16h */
4.61530358172978565562516450881958007812500000000000e+05, 	/* 381, accPolyMid7C17h */
1.27435135728149255737662315368652343750000000000000e+06, 	/* 382, accPolyMid7C18h */
3.53543876571432314813137054443359375000000000000000e+06, 	/* 383, accPolyMid7C19h */
9.85027146846828423440456390380859375000000000000000e+06, 	/* 384, accPolyMid7C20h */
2.75499693650120757520198822021484375000000000000000e+07, 	/* 385, accPolyMid7C21h */
7.73223713417402952909469604492187500000000000000000e+07, 	/* 386, accPolyMid7C22h */
2.17703077316092193126678466796875000000000000000000e+08, 	/* 387, accPolyMid7C23h */
6.14725288059689402580261230468750000000000000000000e+08, 	/* 388, accPolyMid7C24h */
1.74040800223112154006958007812500000000000000000000e+09, 	/* 389, accPolyMid7C25h */
4.93950269498267459869384765625000000000000000000000e+09, 	/* 390, accPolyMid7C26h */
1.40506579253189964294433593750000000000000000000000e+10, 	/* 391, accPolyMid7C27h */
4.00515555251962203979492187500000000000000000000000e+10, 	/* 392, accPolyMid7C28h */
1.14389701296316925048828125000000000000000000000000e+11, 	/* 393, accPolyMid7C29h */
3.27296809500310974121093750000000000000000000000000e+11, 	/* 394, accPolyMid7C30h */
9.38089913584087280273437500000000000000000000000000e+11, 	/* 395, accPolyMid7C31h */
2.69293079636161279296875000000000000000000000000000e+12, 	/* 396, accPolyMid7C32h */
7.72833097677600292968750000000000000000000000000000e+12, 	/* 397, accPolyMid7C33h */
2.22444558194129648437500000000000000000000000000000e+13, 	/* 398, accPolyMid7C34h */
6.82401753565838359375000000000000000000000000000000e+13, 	/* 399, accPolyMid7C35h */
1.01740290807493916069859096751315519213676452636719e+00, 	/* 400, RN rounding constant quick poly middle 7*/
9.50960845417677113226513686606015976666256457529322e-19, 	/* 401, RD rounding constant quick poly middle 7*/
7.19008445739778290217714129539672285318374633789062e-01, 	/* 402, midpoint in interval 8*/
8.02374569969830475635319544380763545632362365722656e-01, 	/* 403, accPolyMid8C0h, quickPolyMid8C0h */
-5.57232596267891548198947769768214754835408022265973e-18, 	/* 404, accPolyMid8C0m, quickPolyMid8C0l */
1.43884615807450622071428369963541626930236816406250e+00, 	/* 405, accPolyMid8C1h, quickPolyMid8C1h */
3.59501817700961691698905527113737832717163932379732e-17, 	/* 406, accPolyMid8C1m, quickPolyMid8C1l */
1.42139791223330171535988185118707169939451756100115e-33, 	/* 407, accPolyMid8C1l */
1.07089546798848767039658014255110174417495727539062e+00, 	/* 408, accPolyMid8C2h, quickPolyMid8C2h */
7.12234409493595206110752393915421282220770659974638e-18, 	/* 409, accPolyMid8C2m, quickPolyMid8C2l */
4.88803415361541961399074298884647415525574790319603e-34, 	/* 410, accPolyMid8C2l */
2.09054748952818103546746897336561232805252075195312e+00, 	/* 411, accPolyMid8C3h, quickPolyMid8C3h */
-4.76201670474478458619338404030121517580491201111076e-17, 	/* 412, accPolyMid8C3m, quickPolyMid8C3l */
9.85965711757934088944524691800382507878970211803297e-34, 	/* 413, accPolyMid8C3l */
4.62886640680389760404978005681186914443969726562500e+00, 	/* 414, accPolyMid8C4h, quickPolyMid8C4h */
-6.26076461255283992652654162871089011104493903198467e-17, 	/* 415, accPolyMid8C4m, quickPolyMid8C4l */
-3.79525038577018957662309046851941714013728344004132e-33, 	/* 416, accPolyMid8C4l */
1.15940096700862280698629547259770333766937255859375e+01, 	/* 417, accPolyMid8C5h, quickPolyMid8C5h */
5.00344758332442110044971487490682364429618307708619e-16, 	/* 418, accPolyMid8C5m, quickPolyMid8C5l */
5.05400641998677592107699970650218041381398322944134e-33, 	/* 419, accPolyMid8C5l */
3.09983076631741454320945194922387599945068359375000e+01, 	/* 420, accPolyMid8C6h, quickPolyMid8C6h */
-1.68695534318490565671111852385917462817518447859219e-16, 	/* 421, accPolyMid8C6m, quickPolyMid8C6l */
6.85050661529605157727571454320758800953682098824324e-34, 	/* 422, accPolyMid8C6l */
8.67969690247392975379625568166375160217285156250000e+01, 	/* 423, accPolyMid8C7h, quickPolyMid8C7h */
-5.77909319686569076564604963233208513019264259552576e-15, 	/* 424, accPolyMid8C7m, quickPolyMid8C7l */
2.51207737556061232453430420719087123870849609375000e+02, 	/* 425, accPolyMid8C8h, quickPolyMid8C8h */
-2.34229223147066395573123458231502220325151528840246e-15, 	/* 426, accPolyMid8C8m */
7.45516108151238086065859533846378326416015625000000e+02, 	/* 427, accPolyMid8C9h, quickPolyMid8C9h */
5.42429462463291658149197032428663192617240449908134e-15, 	/* 428, accPolyMid8C9m */
2.25637900900536169501719996333122253417968750000000e+03, 	/* 429, accPolyMid8C10h, quickPolyMid8C10h */
1.04118075698860813774916020354956791986217497225642e-13, 	/* 430, accPolyMid8C10m */
6.93796098101582811068510636687278747558593750000000e+03, 	/* 431, accPolyMid8C11h, quickPolyMid8C11h */
8.59862281333229161222916847764065622815798321104674e-15, 	/* 432, accPolyMid8C11m */
2.16119867410615115659311413764953613281250000000000e+04, 	/* 433, accPolyMid8C12h, quickPolyMid8C12h */
1.06661614083783310365636876324959361083581990681246e-13, 	/* 434, accPolyMid8C12m */
6.80579130650992592563852667808532714843750000000000e+04, 	/* 435, accPolyMid8C13h, quickPolyMid8C13h */
6.62014084472278982961475227363418833651659278771717e-12, 	/* 436, accPolyMid8C13m */
2.16307061102022911654785275459289550781250000000000e+05, 	/* 437, accPolyMid8C14h, quickPolyMid8C14h */
-2.44881501957370731470213892899278376432195547529602e-12, 	/* 438, accPolyMid8C14m */
6.92960027312710066325962543487548828125000000000000e+05, 	/* 439, accPolyMid8C15h */
-5.66500973206806599245652257405055779448943553688878e-11, 	/* 440, accPolyMid8C15m */
2.23531716476973146200180053710937500000000000000000e+06, 	/* 441, accPolyMid8C16h */
7.25429400587130710482597351074218750000000000000000e+06, 	/* 442, accPolyMid8C17h */
2.36685600768156014382839202880859375000000000000000e+07, 	/* 443, accPolyMid8C18h */
7.75916356685774326324462890625000000000000000000000e+07, 	/* 444, accPolyMid8C19h */
2.55452232123835593461990356445312500000000000000000e+08, 	/* 445, accPolyMid8C20h */
8.44254469674954175949096679687500000000000000000000e+08, 	/* 446, accPolyMid8C21h */
2.79994093996573638916015625000000000000000000000000e+09, 	/* 447, accPolyMid8C22h */
9.31537507532041358947753906250000000000000000000000e+09, 	/* 448, accPolyMid8C23h */
3.10820362568210334777832031250000000000000000000000e+10, 	/* 449, accPolyMid8C24h */
1.03985438377022964477539062500000000000000000000000e+11, 	/* 450, accPolyMid8C25h */
3.48737110205060913085937500000000000000000000000000e+11, 	/* 451, accPolyMid8C26h */
1.17221005601944750976562500000000000000000000000000e+12, 	/* 452, accPolyMid8C27h */
3.94841085036352832031250000000000000000000000000000e+12, 	/* 453, accPolyMid8C28h */
1.33255264873973789062500000000000000000000000000000e+13, 	/* 454, accPolyMid8C29h */
4.50540615593679062500000000000000000000000000000000e+13, 	/* 455, accPolyMid8C30h */
1.52590744626434593750000000000000000000000000000000e+14, 	/* 456, accPolyMid8C31h */
5.17610884067860062500000000000000000000000000000000e+14, 	/* 457, accPolyMid8C32h */
1.75591888512180650000000000000000000000000000000000e+15, 	/* 458, accPolyMid8C33h */
5.97247050283681300000000000000000000000000000000000e+15, 	/* 459, accPolyMid8C34h */
2.15157732956128240000000000000000000000000000000000e+16, 	/* 460, accPolyMid8C35h */
1.01155686685228385357504521380178630352020263671875e+00, 	/* 461, RN rounding constant quick poly middle 8*/
6.36522991537283605877265237263241827159525525595558e-19, 	/* 462, RD rounding constant quick poly middle 8*/
7.60880231857352207214262307388707995414733886718750e-01, 	/* 463, midpoint in interval 9*/
8.64668552766275078091950945236021652817726135253906e-01, 	/* 464, accPolyMid9C0h, quickPolyMid9C0h */
2.22107768610709483983000348580034922276618040094248e-19, 	/* 465, accPolyMid9C0m, quickPolyMid9C0l */
1.54108768708640897493467036838410422205924987792969e+00, 	/* 466, accPolyMid9C1h, quickPolyMid9C1h */
3.32820103504311843280112118328828427349507594590859e-17, 	/* 467, accPolyMid9C1m, quickPolyMid9C1l */
1.00469319336666835386896691703426687648516206509999e-33, 	/* 468, accPolyMid9C1l */
1.39241392226891269601196654548402875661849975585938e+00, 	/* 469, accPolyMid9C2h, quickPolyMid9C2h */
-7.78438411380474954824767774215038405507043967534661e-17, 	/* 470, accPolyMid9C2m, quickPolyMid9C2l */
-2.75498989204243544757760916231818015864525586405625e-34, 	/* 471, accPolyMid9C2l */
3.12616775988369477445871780219022184610366821289062e+00, 	/* 472, accPolyMid9C3h, quickPolyMid9C3h */
-1.83136634474213254639590598215495010130375003296228e-16, 	/* 473, accPolyMid9C3m, quickPolyMid9C3l */
-1.37039877493057234685308732075670776376976824689825e-33, 	/* 474, accPolyMid9C3l */
8.16374541867330982825023966142907738685607910156250e+00, 	/* 475, accPolyMid9C4h, quickPolyMid9C4h */
6.61331422381139448266729896007647878117248843327786e-16, 	/* 476, accPolyMid9C4m, quickPolyMid9C4l */
-2.34411228408683938039171677313602417735464237635307e-32, 	/* 477, accPolyMid9C4l */
2.39942774487262227012251969426870346069335937500000e+01, 	/* 478, accPolyMid9C5h, quickPolyMid9C5h */
3.56709659583669727593018389598696746405922754956722e-16, 	/* 479, accPolyMid9C5m, quickPolyMid9C5l */
1.92887188784617492937549821774446261489627075560113e-32, 	/* 480, accPolyMid9C5l */
7.53789452793380974071624223142862319946289062500000e+01, 	/* 481, accPolyMid9C6h, quickPolyMid9C6h */
-4.89236491033052363530754653203901634957086880239885e-15, 	/* 482, accPolyMid9C6m, quickPolyMid9C6l */
1.86966182047363315238712995890702987106854589421809e-31, 	/* 483, accPolyMid9C6l */
2.47970017761763045882617007009685039520263671875000e+02, 	/* 484, accPolyMid9C7h, quickPolyMid9C7h */
-5.49773113276874172897358146458574130047619382341550e-15, 	/* 485, accPolyMid9C7m, quickPolyMid9C7l */
8.43239639560233626980334520339965820312500000000000e+02, 	/* 486, accPolyMid9C8h, quickPolyMid9C8h */
4.61444619149467756136937751706191309842186761003280e-14, 	/* 487, accPolyMid9C8m */
2.94042238989191673681489191949367523193359375000000e+03, 	/* 488, accPolyMid9C9h, quickPolyMid9C9h */
-6.26529947434876144165574723786618699307871677151027e-14, 	/* 489, accPolyMid9C9m */
1.04570596262470262445276603102684020996093750000000e+04, 	/* 490, accPolyMid9C10h, quickPolyMid9C10h */
4.33811913399171164864172764349193352065910816994787e-13, 	/* 491, accPolyMid9C10m */
3.77816423278584625222720205783843994140625000000000e+04, 	/* 492, accPolyMid9C11h, quickPolyMid9C11h */
-4.21825155017599752908316500880066660420734253600372e-14, 	/* 493, accPolyMid9C11m */
1.38292932619114842964336276054382324218750000000000e+05, 	/* 494, accPolyMid9C12h, quickPolyMid9C12h */
-2.02223055949190022685968858135129700521678830504868e-12, 	/* 495, accPolyMid9C12m */
5.11733514125351735856384038925170898437500000000000e+05, 	/* 496, accPolyMid9C13h, quickPolyMid9C13h */
-2.25025523408315347550056625257165819446736332309911e-11, 	/* 497, accPolyMid9C13m */
1.91116705355792236514389514923095703125000000000000e+06, 	/* 498, accPolyMid9C14h, quickPolyMid9C14h */
-6.92308947161053801527502899602797403061371639410027e-11, 	/* 499, accPolyMid9C14m */
7.19450694938360899686813354492187500000000000000000e+06, 	/* 500, accPolyMid9C15h */
-3.25836107774239441972945896739397887709177581427866e-10, 	/* 501, accPolyMid9C15m */
2.72708481033120900392532348632812500000000000000000e+07, 	/* 502, accPolyMid9C16h */
1.03997450389555335044860839843750000000000000000000e+08, 	/* 503, accPolyMid9C17h */
3.98720516462098360061645507812500000000000000000000e+08, 	/* 504, accPolyMid9C18h */
1.53596677859462237358093261718750000000000000000000e+09, 	/* 505, accPolyMid9C19h */
5.94220454070446586608886718750000000000000000000000e+09, 	/* 506, accPolyMid9C20h */
2.30771902569618682861328125000000000000000000000000e+10, 	/* 507, accPolyMid9C21h */
8.99354036055935974121093750000000000000000000000000e+10, 	/* 508, accPolyMid9C22h */
3.51604905808161804199218750000000000000000000000000e+11, 	/* 509, accPolyMid9C23h */
1.37859673609756665039062500000000000000000000000000e+12, 	/* 510, accPolyMid9C24h */
5.41968316905909179687500000000000000000000000000000e+12, 	/* 511, accPolyMid9C25h */
2.13586334787060429687500000000000000000000000000000e+13, 	/* 512, accPolyMid9C26h */
8.43635735241271562500000000000000000000000000000000e+13, 	/* 513, accPolyMid9C27h */
3.33923015327480937500000000000000000000000000000000e+14, 	/* 514, accPolyMid9C28h */
1.32429009755987925000000000000000000000000000000000e+15, 	/* 515, accPolyMid9C29h */
5.26147664189654100000000000000000000000000000000000e+15, 	/* 516, accPolyMid9C30h */
2.09399836831170720000000000000000000000000000000000e+16, 	/* 517, accPolyMid9C31h */
8.34692893106752000000000000000000000000000000000000e+16, 	/* 518, accPolyMid9C32h */
3.32762568376608000000000000000000000000000000000000e+17, 	/* 519, accPolyMid9C33h */
1.33003631888338841600000000000000000000000000000000e+18, 	/* 520, accPolyMid9C34h */
5.62235923730283212800000000000000000000000000000000e+18, 	/* 521, accPolyMid9C35h */
1.01049946711285376643729705392615869641304016113281e+00, 	/* 522, RN rounding constant quick poly middle 9*/
5.78284088727747938003347592934948079832502681677348e-19, 	/* 523, RD rounding constant quick poly middle 9*/
-8.33333333333333287074040640618477482348680496215820e-02, 	/* 524, accPolyHighC1h, quickPolyHighC1h */
-4.62592926927148532830780603208030422795294098867636e-18, 	/* 525, accPolyHighC1m, quickPolyHighC1l */
-2.56790659251636222413745757067544746896901530409675e-34, 	/* 526, accPolyHighC1l */
-1.87499999999999993061106096092771622352302074432373e-02, 	/* 527, accPolyHighC2h, quickPolyHighC2h */
-6.93889390390722876283368680301479756432058851698546e-19, 	/* 528, accPolyHighC2m, quickPolyHighC2l */
3.85185989241340205035888971870941307651344283492079e-35, 	/* 529, accPolyHighC2l */
-5.58035714285714298105167685548622102942317724227905e-03, 	/* 530, accPolyHighC3h, quickPolyHighC3h */
1.23908819712629071293959090145008148963025205053831e-19, 	/* 531, accPolyHighC3m, quickPolyHighC3l */
6.87827508933260239532125196237951282993345739214379e-36, 	/* 532, accPolyHighC3l */
-1.89887152777777775368439616698879035538993775844574e-03, 	/* 533, accPolyHighC4h, quickPolyHighC4h */
-2.40933816107889860849364897504182511872549009826894e-20, 	/* 534, accPolyHighC4m, quickPolyHighC4l */
-1.31413379554614650822698366533512762375439292005686e-36, 	/* 535, accPolyHighC4l */
-6.99129971590909120478241067786484563839621841907501e-04, 	/* 536, accPolyHighC5h, quickPolyHighC5h */
2.95691501586955672658426997372092637662516651210484e-20, 	/* 537, accPolyHighC5m, quickPolyHighC5l */
1.93248831638054158509225332576516713663708940033800e-36, 	/* 538, accPolyHighC5l */
-2.71136944110576935586948144063512700085993856191635e-04, 	/* 539, accPolyHighC6h, quickPolyHighC6h */
1.25100250671414776773311485375106982275955017737813e-20, 	/* 540, accPolyHighC6m, quickPolyHighC6l */
-2.41797324682937785630481140742729367728409168219340e-37, 	/* 541, accPolyHighC6l */
-1.09100341796875005421010862427522170037264004349709e-04, 	/* 542, accPolyHighC7h, quickPolyHighC7h */
5.42101086231091719294416952538483743258993211884145e-21, 	/* 543, accPolyHighC7m, quickPolyHighC7l */
9.55338141209871258458343868890229946241110412925982e-38, 	/* 544, accPolyHighC7l */
-4.51242222505457229141112573955751940957270562648773e-05, 	/* 545, accPolyHighC8h, quickPolyHighC8h */
-3.18882990973711044045301474516264873522265001897356e-21, 	/* 546, accPolyHighC8m, quickPolyHighC8l */
1.26912673390128847048400261536391292203355395300755e-37, 	/* 547, accPolyHighC8l */
-1.90656436117071843741425929419364138084347359836102e-05, 	/* 548, accPolyHighC9h, quickPolyHighC9h */
-1.06993691223935686411543055030763865855410413408366e-21, 	/* 549, accPolyHighC9m, quickPolyHighC9l */
-8.19368731407892096011823940271412425317976158112288e-06, 	/* 550, accPolyHighC10h, quickPolyHighC10h */
-4.03323388732262270981356256138402986149007425086112e-22, 	/* 551, accPolyHighC10m */
-3.57056927421818625395413641931963155684570665471256e-06, 	/* 552, accPolyHighC11h, quickPolyHighC11h */
1.64796270839759047485693620137778762426170587507193e-22, 	/* 553, accPolyHighC11m */
-1.57402595505118377679448869038703051614902506116778e-06, 	/* 554, accPolyHighC12h, quickPolyHighC12h */
1.03140748281100284102117735554826521589797225638379e-22, 	/* 555, accPolyHighC12m */
-7.00688192241446386609332076800260580284884781576693e-07, 	/* 556, accPolyHighC13h, quickPolyHighC13h */
1.64297063257073230214010320767916245637133227760945e-23, 	/* 557, accPolyHighC13m */
-3.14533061665020903893046425037205438002274604514241e-07, 	/* 558, accPolyHighC14h, quickPolyHighC14h */
-1.57714454767442613704253788250439912924415496806915e-23, 	/* 559, accPolyHighC14m */
-1.42216292935838748302118661470672122959513217210770e-07, 	/* 560, accPolyHighC15h, quickPolyHighC15h */
3.70163506723718792079998292841186813204562291235770e-24, 	/* 561, accPolyHighC15m */
-6.47111067734723877623606537110023673164960200665519e-08, 	/* 562, accPolyHighC16h, quickPolyHighC16h */
1.96959302136511249382763415085950224265202199251341e-24, 	/* 563, accPolyHighC16m */
-2.96094098107419582578099602043070204260288846853655e-08, 	/* 564, accPolyHighC17h, quickPolyHighC17h */
-1.33210241793138800698071276025711826265682121011801e-25, 	/* 565, accPolyHighC17m */
-1.36154377785683810553931313304908135020099280154682e-08, 	/* 566, accPolyHighC18h, quickPolyHighC18h */
-6.28864412480332248702787563995712794007175716615166e-09, 	/* 567, accPolyHighC19h */
-2.91615151940413698643198065114674061293342788303562e-09, 	/* 568, accPolyHighC20h */
-1.35724329813454494662594037565671659106847357634251e-09, 	/* 569, accPolyHighC21h */
-6.33321170158103043923636695899503229467697451582353e-10, 	/* 570, accPolyHighC22h */
-2.98137047522453658533318439889463723202478462326326e-10, 	/* 571, accPolyHighC23h */
-1.35174910337425390381481209427921852395115820399951e-10, 	/* 572, accPolyHighC24h */
-7.57694791124210735879864558660150546803846438592700e-11, 	/* 573, accPolyHighC25h */
-1.19244777215077355372683280351504137017926154840097e-11, 	/* 574, accPolyHighC26h */
-4.08879979855917754145740023360966995669141255120849e-11, 	/* 575, accPolyHighC27h */
1.75342081019476863949528641668112755730435381451571e-11, 	/* 576, accPolyHighC28h */
-1.60530246587119583502980643958298338953849526689055e-11, 	/* 577, accPolyHighC29h */
1.00010072995346011026640553609468042850494384765625e+00, 	/* 578, RN rounding constant quick poly high*/
5.59129439367752644847269214347219849204178767344215e-21, 	/* 579, RD rounding constant quick poly high*/
};

