// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _ShapeAnalysis_Wire_HeaderFile
#define _ShapeAnalysis_Wire_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_Wire_HeaderFile
#include <Handle_ShapeAnalysis_Wire.hxx>
#endif

#ifndef _Handle_ShapeExtend_WireData_HeaderFile
#include <Handle_ShapeExtend_WireData.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Handle_ShapeAnalysis_Surface_HeaderFile
#include <Handle_ShapeAnalysis_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _ShapeExtend_Status_HeaderFile
#include <ShapeExtend_Status.hxx>
#endif
class ShapeExtend_WireData;
class ShapeAnalysis_Surface;
class TopoDS_Wire;
class TopoDS_Face;
class Geom_Surface;
class TopLoc_Location;
class ShapeAnalysis_WireOrder;
class Geom2d_Curve;
class gp_Pnt2d;
class IntRes2d_SequenceOfIntersectionPoint;
class TColgp_SequenceOfPnt;
class TColStd_SequenceOfReal;
class TopoDS_Shape;
class TopTools_IndexedMapOfShape;
class TopTools_DataMapOfShapeListOfShape;
class TopTools_MapOfShape;


//! This class provides analysis of a wire to be compliant to <br>
//!          CAS.CADE requirements. <br>
//! <br>
//!	    The functionalities provided are the following: <br>
//!	     1. consistency of 2d and 3d edge curve senses <br>
//!           2. connection of adjacent edges regarding to: <br>
//!	       a. their vertices <br>
//!	       b. their pcurves <br>
//!	       c. their 3d curves <br>
//!           3. adjacency of the edge vertices to its pcurve and 3d curve <br>
//!	     4. if a wire is closed or not (considering its 3d and 2d <br>
//!              contour) <br>
//!	     5. if a wire is outer on its face (considering pcurves) <br>
//! <br>
//! <br>
//! 	    This class can be used in conjunction with class <br>
//!	    ShapeFix_Wire, which will fix the problems detected by this class. <br>
//! <br>
//!          The methods of the given class match to ones of the class <br>
//!	    ShapeFix_Wire, e.g., CheckSmall and FixSmall. <br>
//!          This class also includes some auxilary methods <br>
//!          (e.g., CheckOuterBound, etc.), <br>
//!          which have no pair in ShapeFix_Wire. <br>
//! <br>
//!          Like methods of ShapeFix_Wire the ones of this class are <br>
//! 	    grouped into two levels: <br>
//!          - Public which are recommended for use (the most global <br>
//!	      method is Perform), <br>
//!	    - Advanced, for optional use only <br>
//! <br>
//!          For analyzing result of Public API checking methods use <br>
//!          corresponding Status... method. <br>
//!          The 'advanced' functions share the single status field which <br>
//!          contains the result of the last performed 'advanced' method. <br>
//!          It is quried by the method LastCheckStatus(). <br>
//! <br>
//!          In order to prepare an analyzer, it is necessary to load a wire, <br>
//!          set face and precision. <br>
class ShapeAnalysis_Wire : public MMgt_TShared {

public:

  //! Empty constructor <br>
  Standard_EXPORT   ShapeAnalysis_Wire();
  //! Creates object with standard TopoDS_Wire, face <br>
//!          and precision <br>
  Standard_EXPORT   ShapeAnalysis_Wire(const TopoDS_Wire& wire,const TopoDS_Face& face,const Standard_Real precision);
  //! Creates the object with WireData object, face <br>
//!          and precision <br>
  Standard_EXPORT   ShapeAnalysis_Wire(const Handle(ShapeExtend_WireData)& sbwd,const TopoDS_Face& face,const Standard_Real precision);
  //! Initializes the object with standard TopoDS_Wire, face <br>
//!          and precision <br>
  Standard_EXPORT     void Init(const TopoDS_Wire& wire,const TopoDS_Face& face,const Standard_Real precision) ;
  //! Initializes the object with WireData object, face <br>
//!          and precision <br>
  Standard_EXPORT     void Init(const Handle(ShapeExtend_WireData)& sbwd,const TopoDS_Face& face,const Standard_Real precision) ;
  //! Loads the object with standard TopoDS_Wire <br>
  Standard_EXPORT     void Load(const TopoDS_Wire& wire) ;
  //! Loads the object with WireData object <br>
  Standard_EXPORT     void Load(const Handle(ShapeExtend_WireData)& sbwd) ;
  //! Loads the face the wire lies on <br>
  Standard_EXPORT     void SetFace(const TopoDS_Face& face) ;
  //! Loads the surface the wire lies on <br>
  Standard_EXPORT     void SetSurface(const Handle(Geom_Surface)& surface) ;
  //! Loads the surface the wire lies on <br>
  Standard_EXPORT     void SetSurface(const Handle(Geom_Surface)& surface,const TopLoc_Location& location) ;
  
  Standard_EXPORT     void SetPrecision(const Standard_Real precision) ;
  //! Unsets all the status and distance fields <br>
//!          wire, face and precision are not cleared <br>
  Standard_EXPORT     void ClearStatuses() ;
  //! Returns True if wire is loaded and has number of edges >0 <br>
        Standard_Boolean IsLoaded() const;
  //! Returns True if IsLoaded and underlying face is not null <br>
        Standard_Boolean IsReady() const;
  //! Returns the value of precision <br>
        Standard_Real Precision() const;
  //! Returns wire object being analyzed <br>
       const Handle_ShapeExtend_WireData& WireData() const;
  //! Returns the number of edges in the wire, or 0 if it is not loaded <br>
        Standard_Integer NbEdges() const;
  //! Returns the working face <br>
       const TopoDS_Face& Face() const;
  //! Returns the working surface <br>
       const Handle_ShapeAnalysis_Surface& Surface() const;
  //! Performs all the checks in the following order : <br>
//!	    CheckOrder, CheckSmall, CheckConected, CheckEdgeCurves, <br>
//!          CheckDegenerated, CheckSelfIntersection, CheckLacking, <br>
//!          CheckClosed <br>
//!  Returns: True if at least one method returned True; <br>
//!          For deeper analysis use Status...(status) methods <br>
  Standard_EXPORT     Standard_Boolean Perform() ;
  //! Calls CheckOrder and returns False if wire is already <br>
//!          ordered (tail-to-head), True otherwise <br>
//!          Flag <isClosed> defines if the wire is closed or not <br>
//!          Flag <mode3d> defines which mode is used (3d or 2d) <br>
  Standard_EXPORT     Standard_Boolean CheckOrder(const Standard_Boolean isClosed = Standard_True,const Standard_Boolean mode3d = Standard_True) ;
  //! Calls to CheckConnected for each edge <br>
//!  Returns: True if at least one pair of disconnected edges (not sharing the <br>
//! 	    same vertex) was detected <br>
  Standard_EXPORT     Standard_Boolean CheckConnected(const Standard_Real prec = 0.0) ;
  //! Calls to CheckSmall for each edge <br>
//!  Returns: True if at least one small edge was detected <br>
  Standard_EXPORT     Standard_Boolean CheckSmall(const Standard_Real precsmall = 0.0) ;
  //! Checks edges geometry (consitency of 2d and 3d senses, adjasment <br>
//!	    of curves to the vertices, etc.). <br>
//!	    The order of the checks : <br>
//!          Call ShapeAnalysis_Wire to check: <br>
//!	    ShapeAnalysis_Edge::CheckCurve3dWithPCurve  (1), <br>
//!          ShapeAnalysis_Edge::CheckVertcesWithPCurve  (2), <br>
//!	    ShapeAnalysis_Edge::CheckVertcesWithCurve3d (3), <br>
//!          CheckSeam                                   (4) <br>
//!          Additional: <br>
//!          CheckGap3d                                  (5), <br>
//!          CheckGap2d                                  (6), <br>
//!          ShapeAnalysis_Edge::CheckSameParameter      (7) <br>
//! Returns: True if at least one check returned True <br>
//!  Remark:  The numbers in brackets show with what DONEi or FAILi <br>
//!          the status can be queried <br>
  Standard_EXPORT     Standard_Boolean CheckEdgeCurves() ;
  //! Calls to CheckDegenerated for each edge <br>
//!  Returns: True if at least one incorrect degenerated edge was detected <br>
  Standard_EXPORT     Standard_Boolean CheckDegenerated() ;
  //! Checks if wire is closed, performs CheckConnected, <br>
//!          CheckDegenerated and CheckLacking for the first and the last edges <br>
//!  Returns: True if at least one check returned True <br>
//!  Status: <br>
//!          FAIL1 or DONE1: see CheckConnected <br>
//!          FAIL2 or DONE2: see CheckDegenerated <br>
  Standard_EXPORT     Standard_Boolean CheckClosed(const Standard_Real prec = 0.0) ;
  //! Checks self-intersection of the wire (considering pcurves) <br>
//!          Looks for self-intersecting edges and each pair of intersecting <br>
//!          edges. <br>
//!  Warning: It does not check each edge with any other one (only each two <br>
//!          adjacent edges) <br>
//!          The order of the checks : <br>
//!          CheckSelfIntersectingEdge, CheckIntersectingEdges <br>
//!  Returns: True if at least one check returned True <br>
//!  Status:  FAIL1 or DONE1 - see CheckSelfIntersectingEdge <br>
//!          FAIL2 or DONE2 - see CheckIntersectingEdges <br>
  Standard_EXPORT     Standard_Boolean CheckSelfIntersection() ;
  //! Calls to CheckLacking for each edge <br>
//!  Returns: True if at least one lacking edge was detected <br>
  Standard_EXPORT     Standard_Boolean CheckLacking() ;
  
  Standard_EXPORT     Standard_Boolean CheckGaps3d() ;
  
  Standard_EXPORT     Standard_Boolean CheckGaps2d() ;
  
  Standard_EXPORT     Standard_Boolean CheckCurveGaps() ;
  //! Analyzes the order of the edges in the wire, <br>
//!          uses class WireOrder for that purpose. <br>
//!          Flag <isClosed> defines if the wire is closed or not <br>
//!          Flag <mode3d> defines which mode is used (3d or 2d) <br>
//!          Returns False if wire is already ordered (tail-to-head), <br>
//!          True otherwise. <br>
//!          Use returned WireOrder object for deeper analysis. <br>
//!  Status: <br>
//!          OK   : the same edges orientation, the same edges sequence <br>
//!          DONE1: the same edges orientation, not the same edges sequence <br>
//!          DONE2: as DONE1 and gaps more than myPrecision <br>
//!          DONE3: not the same edges orientation (some need to be reversed) <br>
//!          DONE4: as DONE3 and gaps more than myPrecision <br>
//!          FAIL : algorithm failed (could not detect order) <br>
  Standard_EXPORT     Standard_Boolean CheckOrder(ShapeAnalysis_WireOrder& sawo,const Standard_Boolean isClosed = Standard_True,const Standard_Boolean mode3d = Standard_True) ;
  //! Checks connected edges (num-th and preceeding). <br>
//!           Tests with starting preci from <SBWD> or  with <prec> if <br>
//!	         it is greater. <br>
//!           Considers Vertices. <br>
//!  Returns: False if edges are connected by the common vertex, else True <br>
//!  Status  : <br>
//! 	     OK    : Vertices (end of num-1 th edge and start on num-th one) <br>
//!                   are already the same <br>
//!           DONE1 : Absolutely confused (gp::Resolution) <br>
//!           DONE2 : Confused at starting <preci> from <SBWD> <br>
//!           DONE3 : Confused at <prec> but not <preci> <br>
//!           FAIL1 : Not confused <br>
//!           FAIL2 : Not confused but confused with <preci> if reverse num-th edge <br>
  Standard_EXPORT     Standard_Boolean CheckConnected(const Standard_Integer num,const Standard_Real prec = 0.0) ;
  //! Checks if an edge has a length not greater than myPreci or <br>
//!	    precsmall (if it is smaller) <br>
//!  Returns: False if its length is greater than precision <br>
//!  Status: <br>
//!          OK   : edge is not small or degenerated <br>
//!          DONE1: edge is small, vertices are the same <br>
//!          DONE2: edge is small, vertices are not the same <br>
//!          FAIL : no 3d curve and pcurve <br>
  Standard_EXPORT     Standard_Boolean CheckSmall(const Standard_Integer num,const Standard_Real precsmall = 0.0) ;
  //! Checks if a seam pcurves are correct oriented <br>
//!  Returns: False (status OK) if given edge is not a seam or if it is OK <br>
//!          C1 - current pcurve for FORWARD edge, <br>
//!          C2 - current pcurve for REVERSED edge (if returns True they <br>
//!          should be swapped for the seam), <br>
//!          cf, cl - first and last parameters on curves <br>
//!  Status: <br>
//!          OK   : Pcurves are correct or edge is not seam <br>
//!          DONE : Seam pcurves should be swapped <br>
  Standard_EXPORT     Standard_Boolean CheckSeam(const Standard_Integer num,Handle(Geom2d_Curve)& C1,Handle(Geom2d_Curve)& C2,Standard_Real& cf,Standard_Real& cl) ;
  //! Checks if a seam pcurves are correct oriented <br>
//!          See previous functions for details <br>
  Standard_EXPORT     Standard_Boolean CheckSeam(const Standard_Integer num) ;
  //! Checks for degenerated edge between two adjacent ones. <br>
//!	    Fills parameters dgnr1 and dgnr2 with points in paramterical <br>
//!          space that correspond to the singularity (either gap that <br>
//!          needs to be filled by degenerated edge or that already filled) <br>
//!  Returns: False if no singularity or edge is already degenerated, <br>
//!          otherwise True <br>
//!  Status: <br>
//!          OK   : No surface singularity, or edge is already degenerated <br>
//!	    DONE1: Degenerated edge should be inserted (gap in 2D) <br>
//!          DONE2: Edge <num> should be made degenerated (recompute pcurve <br>
//!                 and set the flag) <br>
//!          FAIL1: One of edges neighbouring to degenerated one has <br>
//!                 no pcurve <br>
//!          FAIL2: Edge marked as degenerated and has no pcurve <br>
//!                 but singularity is not detected <br>
  Standard_EXPORT     Standard_Boolean CheckDegenerated(const Standard_Integer num,gp_Pnt2d& dgnr1,gp_Pnt2d& dgnr2) ;
  //! Checks for degenerated edge between two adjacent ones. <br>
//!  Remark : Calls previous function <br>
//!  Status : See the function above for details <br>
  Standard_EXPORT     Standard_Boolean CheckDegenerated(const Standard_Integer num) ;
  //! Checks gap between edges in 3D (3d curves). <br>
//!          Checks the distance between ends of 3d curves of the num-th <br>
//!          and preceeding edge. <br>
//!	    The distance can be queried by MinDistance3d. <br>
//! <br>
//!  Returns: True if status is DONE <br>
//!  Status: <br>
//!	    OK   : Gap is less than myPrecision <br>
//!          DONE : Gap is greater than myPrecision <br>
//!          FAIL : No 3d curve(s) on the edge(s) <br>
  Standard_EXPORT     Standard_Boolean CheckGap3d(const Standard_Integer num = 0) ;
  //! Checks gap between edges in 2D (pcurves). <br>
//!          Checks the distance between ends of pcurves of the num-th <br>
//!          and preceeding edge. <br>
//!	    The distance can be queried by MinDistance2d. <br>
//! <br>
//!  Returns: True if status is DONE <br>
//!  Status: <br>
//!          OK   : Gap is less than parametric precision out of myPrecision <br>
//!          DONE : Gap is greater than parametric precision out of myPrecision <br>
//!          FAIL : No pcurve(s) on the edge(s) <br>
  Standard_EXPORT     Standard_Boolean CheckGap2d(const Standard_Integer num = 0) ;
  //! Checks gap between points on 3D curve and points on surface <br>
//!          generated by pcurve of the num-th edge. <br>
//!	    The distance can be queried by MinDistance3d. <br>
//! <br>
//!  Returns: True if status is DONE <br>
//!  Status: <br>
//!	    OK   : Gap is less than myPrecision <br>
//!          DONE : Gap is greater than myPrecision <br>
//!          FAIL : No 3d curve(s) on the edge(s) <br>
  Standard_EXPORT     Standard_Boolean CheckCurveGap(const Standard_Integer num = 0) ;
  //! Checks if num-th edge is self-intersecting. <br>
//!          Self-intersection is reported only if intersection point lies outside <br>
//!          of both end vertices of the edge. <br>
//!  Returns: True if edge is self-intersecting. <br>
//!	    If returns True it also fills the sequences of intersection points <br>
//!          and corresponding 3d points (only that are not enclosed by a vertices) <br>
//!  Status: <br>
//!          FAIL1 : No pcurve <br>
//!          FAIL2 : No vertices <br>
//!          DONE1 : Self-intersection found <br>
  Standard_EXPORT     Standard_Boolean CheckSelfIntersectingEdge(const Standard_Integer num,IntRes2d_SequenceOfIntersectionPoint& points2d,TColgp_SequenceOfPnt& points3d) ;
  
  Standard_EXPORT     Standard_Boolean CheckSelfIntersectingEdge(const Standard_Integer num) ;
  //! Checks two adjacent edges for intersecting. <br>
//!          Intersection is reported only if intersection point is not enclosed <br>
//!          by the common end vertex of the edges. <br>
//!  Returns: True if intersection is found. <br>
//!	    If returns True it also fills the sequences of intersection points, <br>
//!          corresponding 3d points, and errors for them (half-distances between <br>
//!          intersection points in 3d calculated from one and from another edge) <br>
//!  Status: <br>
//!          FAIL1 : No pcurve <br>
//!          FAIL2 : No vertices <br>
//!          DONE1 : Self-intersection found <br>
  Standard_EXPORT     Standard_Boolean CheckIntersectingEdges(const Standard_Integer num,IntRes2d_SequenceOfIntersectionPoint& points2d,TColgp_SequenceOfPnt& points3d,TColStd_SequenceOfReal& errors) ;
  //! Checks two adjacent edges for intersecting. <br>
//!  Remark : Calls the previous method <br>
//!  Status : See the function above for details <br>
  Standard_EXPORT     Standard_Boolean CheckIntersectingEdges(const Standard_Integer num) ;
  //! Checks i-th and j-th edges for intersecting. <br>
//!  Remark : See the previous method for details <br>
  Standard_EXPORT     Standard_Boolean CheckIntersectingEdges(const Standard_Integer num1,const Standard_Integer num2,IntRes2d_SequenceOfIntersectionPoint& points2d,TColgp_SequenceOfPnt& points3d,TColStd_SequenceOfReal& errors) ;
  //! Checks i-th and j-th edges for intersecting. <br>
//!  Remark : Calls  previous method. <br>
//!  Status : See the function above for details <br>
  Standard_EXPORT     Standard_Boolean CheckIntersectingEdges(const Standard_Integer num1,const Standard_Integer num2) ;
  //! Checks if there is a gap in 2d between edges, not comprised by <br>
//!          the tolerance of their common vertex. <br>
//!          If <Tolerance> is greater than 0. and less than tolerance of <br>
//!          the vertex, then this value is used for check. <br>
//!  Returns: True if not closed gap was detected <br>
//!          p2d1 and p2d2 are the endpoint of <num-1>th edge and start of <br>
//!          the <num>th edge in 2d. <br>
//!  Status: <br>
//!	    OK: No edge is lacking (3d and 2d connection) <br>
//!          FAIL1: edges have no vertices (at least one of them) <br>
//!          FAIL2: edges are neither connected by common vertex, nor have <br>
//!                 coincided vertices <br>
//!          FAIL1: edges have no pcurves <br>
//!          DONE1: the gap is detected which cannot be closed by the tolerance <br>
//!                 of the common vertex (or with value of <Tolerance>) <br>
//!          DONE2: is set (together with DONE1) if gap is detected and the <br>
//!                 vector (p2d2 - p2d1) goes in direction opposite to the pcurves <br>
//!                 of the edges (if angle is more than 0.9*PI). <br>
  Standard_EXPORT     Standard_Boolean CheckLacking(const Standard_Integer num,const Standard_Real Tolerance,gp_Pnt2d& p2d1,gp_Pnt2d& p2d2) ;
  //! Checks if there is a gap in 2D between edges and not comprised by vertex tolerance <br>
//!         The value of SBWD.thepreci is used. <br>
//!  Returns: False if no edge should be inserted <br>
//!  Status: <br>
//!	     OK    : No edge is lacking (3d and 2d connection) <br>
//!          DONE1 : The vertex tolerance should be increased only (2d gap is <br>
//!                  small) <br>
//!          DONE2 : Edge can be inserted (3d and 2d gaps are large enough) <br>
  Standard_EXPORT     Standard_Boolean CheckLacking(const Standard_Integer num,const Standard_Real Tolerance = 0.0) ;
  //! Checks if wire defines an outer bound on the face <br>
//!          Uses ShapeAnalysis::IsOuterBound for analysis <br>
//!          If <APIMake> is True uses BRepAPI_MakeWire to build the <br>
//!          wire, if False (to be used only when edges share common <br>
//!          vertices) uses BRep_Builder to build the wire <br>
//! <br>
  Standard_EXPORT     Standard_Boolean CheckOuterBound(const Standard_Boolean APIMake = Standard_True) ;
  //! Detects a notch <br>
  Standard_EXPORT     Standard_Boolean CheckNotchedEdges(const Standard_Integer num,Standard_Integer& shortNum,Standard_Real& param,const Standard_Real Tolerance = 0.0) ;
  //! Checks if wire has parametric area less than prec2d. <br>
  Standard_EXPORT     Standard_Boolean CheckSmallArea(const Standard_Real prec2d = 0) ;
  //! Checks with what orientation <shape> (wire or edge) can be <br>
//!           connected to the wire. <br>
//!           Tests distances with starting <preci> from <SBWD> (close confusion), <br>
//!	     but if given <prec> is greater, tests with <prec> (coarse confusion). <br>
//!           The smallest found distance can be returned by MinDistance3d <br>
//! <br>
//!  Returns: False if status is FAIL (see below) <br>
//!  Status: <br>
//!	     DONE1 : If <shape> follows <SBWD>, direct sense (normal) <br>
//!           DONE2 : If <shape> follows <SBWD>, but if reversed <br>
//!           DONE3 : If <shape> preceeds <SBWD>, direct sense <br>
//!           DONE4 : If <shape> preceeds <SBWD>, but if reversed <br>
//!           FAIL1 : If <shape> is neither an edge nor a wire <br>
//!           FAIL2 : If <shape> cannot be connected to <SBWD> <br>
//! <br>
//!           DONE5 : To the tail of <SBWD> the <shape> is closer with <br>
//!                   direct sense <br>
//!           DONE6 : To the head of <SBWD> the <shape> is closer with <br>
//!                   direct sense <br>
//! <br>
//!  Remark:   Statuses DONE1 - DONE4, FAIL1 - FAIL2 are basic and <br>
//!           describe the nearest connection of the <shape> to <SBWD>. <br>
//!           Statuses DONE5 and DONE6 are advanced and are to be used when <br>
//!           analyzing with what sense (direct or reversed) the <shape> <br>
//!           should be connected to <SBWD>: <br>
//!           For tail of <SBWD> if DONE4 is True <shape> should be direct, <br>
//!           otherwise reversed. <br>
//!           For head of <SBWD> if DONE5 is True <shape> should be direct, <br>
//!           otherwise reversed. <br>
  Standard_EXPORT     Standard_Boolean CheckShapeConnect(const TopoDS_Shape& shape,const Standard_Real prec = 0.0) ;
  //! The same as previous CheckShapeConnect but is more advanced. <br>
//!          It returns the distances between each end of <sbwd> and each <br>
//!          end of <shape>. For example, <tailhead> stores distance <br>
//!          between tail of <sbwd> and head of <shape> <br>
//!  Remark:  First method CheckShapeConnect calls this one <br>
  Standard_EXPORT     Standard_Boolean CheckShapeConnect(Standard_Real& tailhead,Standard_Real& tailtail,Standard_Real& headtail,Standard_Real& headhead,const TopoDS_Shape& shape,const Standard_Real prec = 0.0) ;
  //! Checks existance of loop on wire and return vertices wich are loop vertices <br>
//! (vertices belonging to a few pairs of edges) <br>
  Standard_EXPORT     Standard_Boolean CheckLoop(TopTools_IndexedMapOfShape& aMapLoopVertices,TopTools_DataMapOfShapeListOfShape& aMapVertexEdges,TopTools_MapOfShape& aMapSmallEdges,TopTools_MapOfShape& aMapSeemEdges) ;
  
        Standard_Boolean StatusOrder(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusConnected(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusEdgeCurves(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusDegenerated(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusClosed(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusSmall(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusSelfIntersection(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusLacking(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusGaps3d(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusGaps2d(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusCurveGaps(const ShapeExtend_Status Status) const;
  
        Standard_Boolean StatusLoop(const ShapeExtend_Status Status) const;
  //!  Querying the status of the LAST perfomed 'Advanced' checking procedure <br>
        Standard_Boolean LastCheckStatus(const ShapeExtend_Status Status) const;
  //! Returns the last lowest distance in 3D computed by <br>
//!           CheckOrientation, CheckConnected, CheckContinuity3d, <br>
//!	         CheckVertex, CheckNewVertex <br>
        Standard_Real MinDistance3d() const;
  //! Returns the last lowest distance in 2D-UV computed by <br>
//!           CheckContinuity2d <br>
        Standard_Real MinDistance2d() const;
  //! Returns the last maximal distance in 3D computed by <br>
//!           CheckOrientation, CheckConnected, CheckContinuity3d, <br>
//!	         CheckVertex, CheckNewVertex, CheckSameParameter <br>
        Standard_Real MaxDistance3d() const;
  //! Returns the last maximal distance in 2D-UV computed by <br>
//!           CheckContinuity2d <br>
        Standard_Real MaxDistance2d() const;




  DEFINE_STANDARD_RTTI(ShapeAnalysis_Wire)

protected:


Handle_ShapeExtend_WireData myWire;
TopoDS_Face myFace;
Handle_ShapeAnalysis_Surface mySurf;
Standard_Real myPrecision;
Standard_Real myMin3d;
Standard_Real myMin2d;
Standard_Real myMax3d;
Standard_Real myMax2d;
Standard_Integer myStatusOrder;
Standard_Integer myStatusConnected;
Standard_Integer myStatusEdgeCurves;
Standard_Integer myStatusDegenerated;
Standard_Integer myStatusClosed;
Standard_Integer myStatusSmall;
Standard_Integer myStatusSelfIntersection;
Standard_Integer myStatusLacking;
Standard_Integer myStatusGaps3d;
Standard_Integer myStatusGaps2d;
Standard_Integer myStatusCurveGaps;
Standard_Integer myStatusLoop;
Standard_Integer myStatus;


private: 




};


#include <ShapeAnalysis_Wire.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
