// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IntRes2d_Domain_HeaderFile
#define _IntRes2d_Domain_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_DomainError;
class gp_Pnt2d;


//! Definition of the domain of parameter on a 2d-curve. <br>
//!          Most of the time, a domain is defined by two extremities. <br>
//!          An extremity is made of : <br>
//!           - a point in 2d-space (Pnt2d from gp), <br>
//!           - a parameter on the curve, <br>
//!           - a tolerance in the 2d-space. <br>
//!          Sometimes, it can be made of 0 or 1 point ( for an infinite <br>
//!          or semi-infinite line for example). <br>
//! <br>
//!          For Intersection algorithms, Ellipses and Circles <br>
//!          Domains must be closed. <br>
//!          So, SetEquivalentParameters(.,.) method must be called <br>
//!          after initializing the first and the last bounds. <br>
class IntRes2d_Domain  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates an infinite Domain (HasFirstPoint = False <br>
//!          and HasLastPoint = False). <br>
  Standard_EXPORT   IntRes2d_Domain();
  //! Creates a bounded Domain. <br>
  Standard_EXPORT   IntRes2d_Domain(const gp_Pnt2d& Pnt1,const Standard_Real Par1,const Standard_Real Tol1,const gp_Pnt2d& Pnt2,const Standard_Real Par2,const Standard_Real Tol2);
  //! Creates a semi-infinite Domain. If First is set to <br>
//!          True, the given point is the first point of the domain, <br>
//!          otherwise it is the last point. <br>
  Standard_EXPORT   IntRes2d_Domain(const gp_Pnt2d& Pnt,const Standard_Real Par,const Standard_Real Tol,const Standard_Boolean First);
  //! Sets the values for a bounded domain. <br>
  Standard_EXPORT     void SetValues(const gp_Pnt2d& Pnt1,const Standard_Real Par1,const Standard_Real Tol1,const gp_Pnt2d& Pnt2,const Standard_Real Par2,const Standard_Real Tol2) ;
  //! Sets the values for an infinite domain. <br>
  Standard_EXPORT     void SetValues() ;
  //! Sets the values for a semi-infinite domain. <br>
  Standard_EXPORT     void SetValues(const gp_Pnt2d& Pnt,const Standard_Real Par,const Standard_Real Tol,const Standard_Boolean First) ;
  //! Defines a closed domain. <br>
        void SetEquivalentParameters(const Standard_Real zero,const Standard_Real period) ;
  //! Returns True if the domain has a first point, i-e <br>
//!          a point defining the lowest admitted parameter on the <br>
//!          curve. <br>
        Standard_Boolean HasFirstPoint() const;
  //! Returns the parameter of the first point of the domain <br>
//!          The exception DomainError is raised if HasFirstPoint <br>
//!          returns False. <br>
        Standard_Real FirstParameter() const;
  //! Returns the first point of the domain. <br>
//!          The exception DomainError is raised if HasFirstPoint <br>
//!          returns False. <br>
       const gp_Pnt2d& FirstPoint() const;
  //! Returns the tolerance of the first (left) bound. <br>
//!          The exception DomainError is raised if HasFirstPoint <br>
//!          returns False. <br>
        Standard_Real FirstTolerance() const;
  //! Returns True if the domain has a last point, i-e <br>
//!          a point defining the highest admitted parameter on the <br>
//!          curve. <br>
        Standard_Boolean HasLastPoint() const;
  //! Returns the parameter of the last point of the domain. <br>
//!          The exception DomainError is raised if HasLastPoint <br>
//!          returns False. <br>
        Standard_Real LastParameter() const;
  //! Returns the last point of the domain. <br>
//!          The exception DomainError is raised if HasLastPoint <br>
//!          returns False. <br>
       const gp_Pnt2d& LastPoint() const;
  //! Returns the tolerance of the last (right) bound. <br>
//!          The exception DomainError is raised if HasLastPoint <br>
//!          returns False. <br>
        Standard_Real LastTolerance() const;
  //! Returns True if the domain is closed. <br>
        Standard_Boolean IsClosed() const;
  //! Returns Equivalent parameters if the domain is closed. <br>
//!          Otherwise, the exception DomainError is raised. <br>
        void EquivalentParameters(Standard_Real& zero,Standard_Real& zeroplusperiod) const;





protected:





private:



Standard_Integer status;
Standard_Real first_param;
Standard_Real last_param;
Standard_Real first_tol;
Standard_Real last_tol;
gp_Pnt2d first_point;
gp_Pnt2d last_point;
Standard_Real periodfirst;
Standard_Real periodlast;


};


#include <IntRes2d_Domain.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
