/*
Copyright 2012-2015  Francesco Cecconi <francesco.cecconi@gmail.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License as
published by the Free Software Foundation; either version 2 of
the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

import QtQuick 2.0
import "style" 0.1

Rectangle {
    id: window
    gradient: style.backgroundGradient

    Properties { id: style }

    Rectangle {
        id: titleBlock
        width: window.width - 40
        height: 150
        anchors.horizontalCenter: window.horizontalCenter
        y: 100
        smooth: true
        radius: 10
        border.width: 2
        border.color: style.borderColor
        opacity: style.opacityValue
        gradient: style.widgetGradient

        Text {
            id: welcomeLabel
            anchors.horizontalCenter: titleBlock.horizontalCenter
            y: (titleBlock.height / 2) - 42
            font.pointSize: 16
            text: "Search network vulnerabilities"
        }

        Image {
            anchors {
                top: welcomeLabel.bottom
                topMargin: 10
                horizontalCenter: titleBlock.horizontalCenter
            }

            source: "qrc:/images/images/viewmag+.png"
        }
    }
}
