/*
 * $Id: ImapConnector.java 10489 2008-01-23 17:53:38Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.email;

/**
 * Receives messages from an IMAP mailbox
 */
public class ImapConnector extends AbstractRetrieveMailConnector
{

    public static final String IMAP = "imap";
    public static final int DEFAULT_IMAP_PORT = 143;

    public ImapConnector()
    {
        super(DEFAULT_IMAP_PORT);
    }
    
    public String getProtocol()
    {
        return IMAP;
    }

}
