/***************************** LICENSE START ***********************************

 Copyright 2014 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef SystemFolder_H
#define SystemFolder_H

#include "Folder.h"

class SystemFolder : public Folder
{
public:
    SystemFolder(Folder* parent, const IconClass& kind,
                 const string& name, IconInfo* info);

    virtual ~SystemFolder();

protected:
    set<string> can();

private:
    SystemFolder(const SystemFolder&);
    SystemFolder& operator=(const SystemFolder&);

    virtual bool renamable() const;
};

inline void destroy(SystemFolder**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(SystemFolder);
//#endif

#endif
