/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQTemporaryEditor_H
#define MvQTemporaryEditor_H

#include <QDialog>

#include "Editor.h"

class QAbstractButton;
class QDialogButtonBox;
class QHBoxLayout;
class QLabel;
class QPushButton;

class MvQTemporaryEditor : public QDialog, public Editor
{
    Q_OBJECT

public:
    MvQTemporaryEditor(const IconClass& name, const string& kind, QWidget* parent = 0);
    ~MvQTemporaryEditor();

    void changed();

public slots:
    void slotButtonClicked(QAbstractButton*);
    void accept();
    void reject();

protected:
    void raiseIt();
    void showIt() { show(); }
    void closeIt();
    void updateHeader();
    virtual void apply() = 0;
    virtual void reset() = 0;
    virtual void close() = 0;
    virtual void edit();

    QLabel* headerLabel_;
    QHBoxLayout* centralLayout_;
    QDialogButtonBox* buttonBox_;
    QPushButton* okPb_;
    QPushButton* cancelPb_;
    QPushButton* resetPb_;
};

#endif
