# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class XdmfReader(DataObjectAlgorithm):
    r"""
    XdmfReader - Reads eXtensible Data Model and Formatfiles
    
    Superclass: DataObjectAlgorithm
    
    XdmfReader reads XDMF data files so that they can be visualized
    using VTK. The output data produced by this reader depends on the
    number of grids in the data file. If the data file has a single
    domain with a single grid, then the output type is a DataSet
    subclass of the appropriate type, otherwise it's a
    MultiBlockDataSet.
    
    Refer to DataReader which provides many methods for controlling
    the reading of the data file.
    @warning
    Uses the XDMF API (http://www.xdmf.org)
    @sa
    DataReader
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXdmfReader, obj, update, **traits)
    
    read_from_input_string = tvtk_base.false_bool_trait(desc=\
        r"""
        Enable reading from an input_string or input_array instead of the
        default, a file.
        """
    )

    def _read_from_input_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetReadFromInputString,
                        self.read_from_input_string_)

    def get_cell_array_status(self, *args):
        """
        get_cell_array_status(self, name:str) -> int
        C++: int get_cell_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayStatus, *args)
        return ret

    def set_cell_array_status(self, *args):
        """
        set_cell_array_status(self, name:str, status:int) -> None
        C++: void set_cell_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetCellArrayStatus, *args)
        return ret

    domain_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set the active domain. Only one domain can be selected at a time.
        By default the first domain in the datafile is chosen. Setting
        this to null results in the domain being automatically chosen.
        Note that if the domain name is changed, you should explicitly
        call update_information() before accessing information about
        grids, data arrays etc.
        """
    )

    def _domain_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDomainName,
                        self.domain_name)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Name of the file to read.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    def get_grid_status(self, *args):
        """
        get_grid_status(self, gridname:str) -> int
        C++: int get_grid_status(const char *gridname)"""
        ret = self._wrap_call(self._vtk_obj.GetGridStatus, *args)
        return ret

    def set_grid_status(self, *args):
        """
        set_grid_status(self, gridname:str, status:int) -> None
        C++: void set_grid_status(const char *gridname, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetGridStatus, *args)
        return ret

    def _get_input_array(self):
        return wrap_vtk(self._vtk_obj.GetInputArray())
    def _set_input_array(self, arg):
        old_val = self._get_input_array()
        my_arg = deref_array([arg], [['vtkCharArray']])
        self._wrap_call(self._vtk_obj.SetInputArray,
                        my_arg[0])
        self.trait_property_changed('input_array', old_val, arg)
    input_array = traits.Property(_get_input_array, _set_input_array, desc=\
        r"""
        
        """
    )

    input_string = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        
        """
    )

    def _input_string_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInputString,
                        self.input_string)

    def get_point_array_status(self, *args):
        """
        get_point_array_status(self, name:str) -> int
        C++: int get_point_array_status(const char *name)
        Get/Set the point array status.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayStatus, *args)
        return ret

    def set_point_array_status(self, *args):
        """
        set_point_array_status(self, name:str, status:int) -> None
        C++: void set_point_array_status(const char *name, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetPointArrayStatus, *args)
        return ret

    def get_set_status(self, *args):
        """
        get_set_status(self, gridname:str) -> int
        C++: int get_set_status(const char *gridname)"""
        ret = self._wrap_call(self._vtk_obj.GetSetStatus, *args)
        return ret

    def set_set_status(self, *args):
        """
        set_set_status(self, gridname:str, status:int) -> None
        C++: void set_set_status(const char *gridname, int status)"""
        ret = self._wrap_call(self._vtk_obj.SetSetStatus, *args)
        return ret

    stride = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(1, 1, 1), cols=3, desc=\
        r"""
        Get/Set the stride used to skip points when reading structured
        datasets. This affects all grids being read.
        """
    )

    def _stride_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStride,
                        self.stride)

    def get_cell_array_name(self, *args):
        """
        get_cell_array_name(self, index:int) -> str
        C++: const char *get_cell_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetCellArrayName, *args)
        return ret

    def get_grid_array_name(self, *args):
        """
        get_grid_array_name(self, index:int) -> str
        C++: const char *get_grid_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetGridArrayName, *args)
        return ret

    def get_grid_array_status(self, *args):
        """
        get_grid_array_status(self, name:str) -> int
        C++: int get_grid_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetGridArrayStatus, *args)
        return ret

    def get_grid_name(self, *args):
        """
        get_grid_name(self, index:int) -> str
        C++: const char *get_grid_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetGridName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_input_string_length(self):
        return self._vtk_obj.GetInputStringLength()
    input_string_length = traits.Property(_get_input_string_length, desc=\
        r"""
        
        """
    )

    def _get_number_of_cell_arrays(self):
        return self._vtk_obj.GetNumberOfCellArrays()
    number_of_cell_arrays = traits.Property(_get_number_of_cell_arrays, desc=\
        r"""
        Get information about cell-based arrays.  As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
    )

    def _get_number_of_grid_arrays(self):
        return self._vtk_obj.GetNumberOfGridArrays()
    number_of_grid_arrays = traits.Property(_get_number_of_grid_arrays, desc=\
        r"""
        
        """
    )

    def _get_number_of_grids(self):
        return self._vtk_obj.GetNumberOfGrids()
    number_of_grids = traits.Property(_get_number_of_grids, desc=\
        r"""
        Get/Set information about grids. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called.
        """
    )

    def _get_number_of_point_arrays(self):
        return self._vtk_obj.GetNumberOfPointArrays()
    number_of_point_arrays = traits.Property(_get_number_of_point_arrays, desc=\
        r"""
        Get information about point-based arrays. As is typical with
        readers this in only valid after the filename is set and
        update_information() has been called.
        """
    )

    def _get_number_of_set_arrays(self):
        return self._vtk_obj.GetNumberOfSetArrays()
    number_of_set_arrays = traits.Property(_get_number_of_set_arrays, desc=\
        r"""
        These methods are provided to make it easier to use the
        Sets/Grids in para_view.
        """
    )

    def _get_number_of_sets(self):
        return self._vtk_obj.GetNumberOfSets()
    number_of_sets = traits.Property(_get_number_of_sets, desc=\
        r"""
        Get/Set information about sets. As is typical with readers this
        is valid only after the filename as been set and
        update_information() has been called. Note that sets with non-zero
        Ghost value are not treated as sets that the user can select
        using this API.
        """
    )

    def get_point_array_name(self, *args):
        """
        get_point_array_name(self, index:int) -> str
        C++: const char *get_point_array_name(int index)
        Returns the name of point array at the give index. Returns
        nullptr if index is invalid.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointArrayName, *args)
        return ret

    def _get_sil(self):
        return wrap_vtk(self._vtk_obj.GetSIL())
    sil = traits.Property(_get_sil, desc=\
        r"""
        SIL describes organization of/relationships between
        classifications eg. blocks/materials/hierarchies.
        """
    )

    def _get_sil_update_stamp(self):
        return self._vtk_obj.GetSILUpdateStamp()
    sil_update_stamp = traits.Property(_get_sil_update_stamp, desc=\
        r"""
        Every time the SIL is updated a this will return a different
        value.
        """
    )

    def get_set_array_name(self, *args):
        """
        get_set_array_name(self, index:int) -> str
        C++: const char *get_set_array_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetSetArrayName, *args)
        return ret

    def get_set_array_status(self, *args):
        """
        get_set_array_status(self, name:str) -> int
        C++: int get_set_array_status(const char *name)"""
        ret = self._wrap_call(self._vtk_obj.GetSetArrayStatus, *args)
        return ret

    def get_set_name(self, *args):
        """
        get_set_name(self, index:int) -> str
        C++: const char *get_set_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetSetName, *args)
        return ret

    def can_read_file(self, *args):
        """
        can_read_file(self, filename:str) -> int
        C++: virtual int can_read_file(const char *filename)
        Determine if the file can be read with this reader.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    def set_binary_input_string(self, *args):
        """
        set_binary_input_string(self, __a:str, len:int) -> None
        C++: void set_binary_input_string(const char *, int len)"""
        ret = self._wrap_call(self._vtk_obj.SetBinaryInputString, *args)
        return ret

    _updateable_traits_ = \
    (('read_from_input_string', 'GetReadFromInputString'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('domain_name',
    'GetDomainName'), ('file_name', 'GetFileName'), ('input_string',
    'GetInputString'), ('stride', 'GetStride'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'read_from_input_string', 'release_data_flag', 'domain_name',
    'file_name', 'input_string', 'object_name', 'progress_text',
    'stride'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XdmfReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XdmfReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['read_from_input_string'], [], ['domain_name', 'file_name',
            'input_string', 'object_name', 'stride']),
            title='Edit XdmfReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XdmfReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

