# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class TimerLog(Object):
    r"""
    TimerLog - Timer support and logging
    
    Superclass: Object
    
    TimerLog contains walltime and cputime measurements associated
    with a given event.  These results can be later analyzed when "dumping
    out" the table.
    
    In addition, TimerLog allows the user to simply get the current
    time, and to start/stop a simple timer separate from the timing table
    logging.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkTimerLog, obj, update, **traits)
    
    logging = tvtk_base.true_bool_trait(desc=\
        r"""
        This flag will turn logging of events off or on. By default,
        logging is on.
        """
    )

    def _logging_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLogging,
                        self.logging_)

    max_entries = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the maximum number of entries allowed in the timer log
        """
    )

    def _max_entries_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxEntries,
                        self.max_entries)

    def _get_cpu_time(self):
        return self._vtk_obj.GetCPUTime()
    cpu_time = traits.Property(_get_cpu_time, desc=\
        r"""
        Returns the CPU time for this process On Win32 platforms this
        actually returns wall time.
        """
    )

    def _get_elapsed_time(self):
        return self._vtk_obj.GetElapsedTime()
    elapsed_time = traits.Property(_get_elapsed_time, desc=\
        r"""
        Returns the difference between start_time and end_time as a
        doubleing point value indicating the elapsed time in seconds.
        """
    )

    def get_event_indent(self, *args):
        """
        get_event_indent(i:int) -> int
        C++: static int get_event_indent(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetEventIndent, *args)
        return ret

    def get_event_string(self, *args):
        """
        get_event_string(i:int) -> str
        C++: static const char *get_event_string(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetEventString, *args)
        return ret

    def get_event_type(self, *args):
        """
        get_event_type(i:int) -> TimerLogEntry.LogEntryType
        C++: static TimerLogEntry::LogEntryType get_event_type(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetEventType, *args)
        return ret

    def get_event_wall_time(self, *args):
        """
        get_event_wall_time(i:int) -> float
        C++: static double get_event_wall_time(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetEventWallTime, *args)
        return ret

    def _get_number_of_events(self):
        return self._vtk_obj.GetNumberOfEvents()
    number_of_events = traits.Property(_get_number_of_events, desc=\
        r"""
        Programmatic access to events.  Indexed from 0 to num-1.
        """
    )

    def _get_universal_time(self):
        return self._vtk_obj.GetUniversalTime()
    universal_time = traits.Property(_get_universal_time, desc=\
        r"""
        Returns the elapsed number of seconds since 00:00:00 Coordinated
        Universal Time (UTC), Thursday, 1 January 1970. This is also
        called Unix Time.
        """
    )

    def cleanup_log(self):
        """
        cleanup_log() -> None
        C++: static void cleanup_log()
        Remove timer log.
        """
        ret = self._vtk_obj.CleanupLog()
        return ret
        

    def dump_log(self, *args):
        """
        dump_log(filename:str) -> None
        C++: static void dump_log(const char *filename)
        Write the timing table out to a file.  Calculate some helpful
        statistics (deltas and percentages) in the process.
        """
        ret = self._wrap_call(self._vtk_obj.DumpLog, *args)
        return ret

    def insert_timed_event(self, *args):
        """
        insert_timed_event(EventString:str, time:float, cpuTicks:int)
            -> None
        C++: static void insert_timed_event(const char *EventString,
            double time, int cpuTicks)
        Insert an event with a known wall time value (in seconds) and
        cpuTicks.
        """
        ret = self._wrap_call(self._vtk_obj.InsertTimedEvent, *args)
        return ret

    def mark_end_event(self, *args):
        """
        mark_end_event(EventString:str) -> None
        C++: static void mark_end_event(const char *EventString)"""
        ret = self._wrap_call(self._vtk_obj.MarkEndEvent, *args)
        return ret

    def mark_event(self, *args):
        """
        mark_event(EventString:str) -> None
        C++: static void mark_event(const char *EventString)
        Record a timing event and capture wall time and cpu ticks.
        """
        ret = self._wrap_call(self._vtk_obj.MarkEvent, *args)
        return ret

    def mark_start_event(self, *args):
        """
        mark_start_event(EventString:str) -> None
        C++: static void mark_start_event(const char *EventString)
        I want to time events, so I am creating this interface to mark
        events that have a start and an end.  These events can be,
        nested. The standard Dumplog ignores the indents.
        """
        ret = self._wrap_call(self._vtk_obj.MarkStartEvent, *args)
        return ret

    def reset_log(self):
        """
        reset_log() -> None
        C++: static void reset_log()
        Clear the timing table.  walltime and cputime will also be set to
        zero when the first new event is recorded.
        """
        ret = self._vtk_obj.ResetLog()
        return ret
        

    def start_timer(self):
        """
        start_timer(self) -> None
        C++: void start_timer()
        Set the start_time to the current time. Used with
        get_elapsed_time().
        """
        ret = self._vtk_obj.StartTimer()
        return ret
        

    def stop_timer(self):
        """
        stop_timer(self) -> None
        C++: void stop_timer()
        Sets end_time to the current time. Used with get_elapsed_time().
        """
        ret = self._vtk_obj.StopTimer()
        return ret
        

    _updateable_traits_ = \
    (('logging', 'GetLogging'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('max_entries',
    'GetMaxEntries'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'logging', 'max_entries',
    'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(TimerLog, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit TimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['logging'], [], ['max_entries', 'object_name']),
            title='Edit TimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit TimerLog properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

