# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.generic_cell_tessellator import GenericCellTessellator


class SimpleCellTessellator(GenericCellTessellator):
    r"""
    SimpleCellTessellator - helper class to perform cell tessellation
    
    Superclass: GenericCellTessellator
    
    SimpleCellTessellator is a helper class to perform adaptive
    tessellation of particular cell topologies. The major purpose for
    this class is to transform higher-order cell types (e.g.,
    higher-order finite elements) into linear cells that can then be
    easily visualized by VTK. This class works in conjunction with the
    GenericDataSet and GenericAdaptorCell classes.
    
    This algorithm is based on edge subdivision. An error metric along
    each edge is evaluated, and if the error is greater than some
    tolerance, the edge is subdivided (as well as all connected 2D and 3D
    cells). The process repeats until the error metric is satisfied.
    Since the algorithm is based on edge subdivision it inherently avoid
    T-junctions.
    
    A significant issue addressed by this algorithm is to ensure face
    compatibility across neighboring cells. That is, diagonals due to
    face triangulation must match to ensure that the mesh is compatible.
    The algorithm employs a precomputed table to accelerate the
    tessellation process. The table was generated with the help of
    OrderedTriangulator the basic idea is that the choice of diagonal
    is made only by considering the relative value of the point ids.
    
    @sa
    GenericCellTessellator GenericSubdivisionErrorMetric
    AttributesErrorMetric GeometricErrorMetric
    ViewDependentErrorMetric
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSimpleCellTessellator, obj, update, **traits)
    
    fixed_subdivisions = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of fixed subdivisions. See get_fixed_subdivisions()
        for more explanations.
        \pre positive_level: level>=0 && level<=get_max_subdivision_level()
        \post is_set: get_fixed_subdivisions()==level
        """
    )

    def _fixed_subdivisions_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFixedSubdivisions,
                        self.fixed_subdivisions)

    max_subdivision_level = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set the maximum level of subdivision. See
        get_max_subdivision_level() for more explanations.
        \pre positive_level: level>=get_fixed_subdivisions()
        \post is_set: level==get_max_subdivision_level()
        """
    )

    def _max_subdivision_level_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaxSubdivisionLevel,
                        self.max_subdivision_level)

    def _get_generic_cell(self):
        return wrap_vtk(self._vtk_obj.GetGenericCell())
    generic_cell = traits.Property(_get_generic_cell, desc=\
        r"""
        Get the higher order cell in order to access the evaluation
        function.
        """
    )

    def _get_max_adaptive_subdivisions(self):
        return self._vtk_obj.GetMaxAdaptiveSubdivisions()
    max_adaptive_subdivisions = traits.Property(_get_max_adaptive_subdivisions, desc=\
        r"""
        Return the maximum number of adaptive subdivisions.
        \post valid_result:
            result==get_max_subdivision_level()-get_fixed_subdivisions()
        """
    )

    def reset(self):
        """
        reset(self) -> None
        C++: void reset()
        Reset the output for repeated use of this class.
        """
        ret = self._vtk_obj.Reset()
        return ret
        

    def set_subdivision_levels(self, *args):
        """
        set_subdivision_levels(self, fixed:int, maxLevel:int) -> None
        C++: void set_subdivision_levels(int fixed, int maxLevel)
        Set both the number of fixed subdivisions and the maximum level
        of subdivisions. See get_fixed_subdivisions(),
        get_max_subdivision_level() and get_max_adaptive_subdivisions() for
        more explanations.
        \\pre positive_fixed: fixed>=0
        \\pre valid_range: fixed<=maxLevel
        \\post fixed_is_set: fixed==get_fixed_subdivisions()
        \\post maxLevel_is_set: maxLevel==get_max_subdivision_level()
        """
        ret = self._wrap_call(self._vtk_obj.SetSubdivisionLevels, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('fixed_subdivisions',
    'GetFixedSubdivisions'), ('max_subdivision_level',
    'GetMaxSubdivisionLevel'), ('measurement', 'GetMeasurement'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'fixed_subdivisions',
    'max_subdivision_level', 'measurement', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SimpleCellTessellator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SimpleCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['fixed_subdivisions', 'max_subdivision_level',
            'measurement', 'object_name']),
            title='Edit SimpleCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SimpleCellTessellator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

