# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_window_interactor import RenderWindowInteractor


class RenderWindowInteractor3D(RenderWindowInteractor):
    r"""
    RenderWindowInteractor3D - adds support for 3D events to
    RenderWindowInteractor.
    
    Superclass: RenderWindowInteractor
    
    RenderWindowInteractor3D provides a platform-independent
    interaction support for 3D events including 3D clicks and 3D
    controller orientations. It follows the same basic model as
    RenderWindowInteractor but adds methods to set and get 3D event
    locations and orientations. VR systems will subclass this class to
    provide the code to set these values based on events from their VR
    controllers.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkRenderWindowInteractor3D, obj, update, **traits)
    
    def get_physical_event_pose(self, *args):
        """
        get_physical_event_pose(self, poseMatrix:Matrix4x4,
            pointerIndex:int) -> None
        C++: virtual void get_physical_event_pose(Matrix4x4 *poseMatrix,
            int pointerIndex)
        With VR we know the physical/room coordinate positions and
        orientations of events. These methods support getting them.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPhysicalEventPose, *my_args)
        return ret

    def set_physical_event_pose(self, *args):
        """
        set_physical_event_pose(self, poseMatrix:Matrix4x4,
            pointerIndex:int) -> None
        C++: virtual void set_physical_event_pose(Matrix4x4 *poseMatrix,
            int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPhysicalEventPose, *my_args)
        return ret

    physical_scale = traits.Float(1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the physical scale (world / physical distance ratio)
        """
    )

    def _physical_scale_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPhysicalScale,
                        self.physical_scale)

    def get_physical_translation(self, *args):
        """
        get_physical_translation(self, __a:Camera) -> Pointer
        C++: virtual double *get_physical_translation(Camera *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetPhysicalTranslation, *my_args)
        return ret

    def set_physical_translation(self, *args):
        """
        set_physical_translation(self, __a:Camera, __b:float, __c:float,
            __d:float) -> None
        C++: virtual void set_physical_translation(Camera *, double,
            double, double)
        Set/get position of the physical coordinate system origin in
        world coordinates.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetPhysicalTranslation, *my_args)
        return ret

    def get_physical_view_direction(self):
        """
        get_physical_view_direction(self) -> Pointer
        C++: virtual double *get_physical_view_direction()"""
        ret = self._vtk_obj.GetPhysicalViewDirection()
        return ret
        

    def set_physical_view_direction(self, *args):
        """
        set_physical_view_direction(self, __a:float, __b:float, __c:float)
            -> None
        C++: virtual void set_physical_view_direction(double, double, double)
        Set/get the direction of the physical coordinate system -Z axis
        in world coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.SetPhysicalViewDirection, *args)
        return ret

    def get_physical_view_up(self):
        """
        get_physical_view_up(self) -> Pointer
        C++: virtual double *get_physical_view_up()"""
        ret = self._vtk_obj.GetPhysicalViewUp()
        return ret
        

    def set_physical_view_up(self, *args):
        """
        set_physical_view_up(self, __a:float, __b:float, __c:float) -> None
        C++: virtual void set_physical_view_up(double, double, double)
        Set/get the direction of the physical coordinate system +Y axis
        in world coordinates.
        """
        ret = self._wrap_call(self._vtk_obj.SetPhysicalViewUp, *args)
        return ret

    translation3d = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(2.440043060946473e-154, 2.586190575492677e+161, 7.505706867027984e+179), cols=3, desc=\
        r"""
        Set/get the translation for pan/swipe gestures, update
        last_translation
        """
    )

    def _translation3d_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetTranslation3D,
                        self.translation3d)

    def get_world_event_orientation(self, *args):
        """
        get_world_event_orientation(self, pointerIndex:int) -> Pointer
        C++: virtual double *get_world_event_orientation(int pointerIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetWorldEventOrientation, *args)
        return ret

    def set_world_event_orientation(self, *args):
        """
        set_world_event_orientation(self, w:float, x:float, y:float, z:float,
             pointerIndex:int) -> None
        C++: virtual void set_world_event_orientation(double w, double x,
            double y, double z, int pointerIndex)"""
        ret = self._wrap_call(self._vtk_obj.SetWorldEventOrientation, *args)
        return ret

    def get_world_event_pose(self, *args):
        """
        get_world_event_pose(self, poseMatrix:Matrix4x4, pointerIndex:int)
             -> None
        C++: virtual void get_world_event_pose(Matrix4x4 *poseMatrix,
            int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetWorldEventPose, *my_args)
        return ret

    def set_world_event_pose(self, *args):
        """
        set_world_event_pose(self, poseMatrix:Matrix4x4, pointerIndex:int)
             -> None
        C++: virtual void set_world_event_pose(Matrix4x4 *poseMatrix,
            int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetWorldEventPose, *my_args)
        return ret

    def get_world_event_position(self, *args):
        """
        get_world_event_position(self, pointerIndex:int) -> Pointer
        C++: virtual double *get_world_event_position(int pointerIndex)
        With VR we know the world coordinate positions and orientations
        of events. These methods support querying them instead of going
        through a display X,Y coordinate approach as is standard for
        mouse/touch events
        """
        ret = self._wrap_call(self._vtk_obj.GetWorldEventPosition, *args)
        return ret

    def set_world_event_position(self, *args):
        """
        set_world_event_position(self, x:float, y:float, z:float,
            pointerIndex:int) -> None
        C++: virtual void set_world_event_position(double x, double y,
            double z, int pointerIndex)
        With VR we know the world coordinate positions and orientations
        of events. These methods support setting them.
        """
        ret = self._wrap_call(self._vtk_obj.SetWorldEventPosition, *args)
        return ret

    def get_last_physical_event_pose(self, *args):
        """
        get_last_physical_event_pose(self, poseMatrix:Matrix4x4,
            pointerIndex:int) -> None
        C++: virtual void get_last_physical_event_pose(
            Matrix4x4 *poseMatrix, int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetLastPhysicalEventPose, *my_args)
        return ret

    def _get_last_translation3d(self):
        return self._vtk_obj.GetLastTranslation3D()
    last_translation3d = traits.Property(_get_last_translation3d, desc=\
        r"""
        
        """
    )

    def get_last_world_event_orientation(self, *args):
        """
        get_last_world_event_orientation(self, pointerIndex:int) -> Pointer
        C++: virtual double *get_last_world_event_orientation(
            int pointerIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetLastWorldEventOrientation, *args)
        return ret

    def get_last_world_event_pose(self, *args):
        """
        get_last_world_event_pose(self, poseMatrix:Matrix4x4,
            pointerIndex:int) -> None
        C++: virtual void get_last_world_event_pose(Matrix4x4 *poseMatrix,
            int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetLastWorldEventPose, *my_args)
        return ret

    def get_last_world_event_position(self, *args):
        """
        get_last_world_event_position(self, pointerIndex:int) -> Pointer
        C++: virtual double *get_last_world_event_position(int pointerIndex)"""
        ret = self._wrap_call(self._vtk_obj.GetLastWorldEventPosition, *args)
        return ret

    def get_starting_physical_event_pose(self, *args):
        """
        get_starting_physical_event_pose(self, poseMatrix:Matrix4x4,
            pointerIndex:int) -> None
        C++: virtual void get_starting_physical_event_pose(
            Matrix4x4 *poseMatrix, int pointerIndex)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetStartingPhysicalEventPose, *my_args)
        return ret

    def get_touch_pad_position(self, *args):
        """
        get_touch_pad_position(self, __a:EventDataDevice,
            __b:EventDataDeviceInput, __c:[float, float, float])
            -> None
        C++: virtual void get_touch_pad_position(EventDataDevice,
            EventDataDeviceInput, float[3])
        Get the latest touchpad or joystick position for a device
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetTouchPadPosition, *my_args)
        return ret

    def set_physical_event_position(self, *args):
        """
        set_physical_event_position(self, x:float, y:float, z:float,
            pointerIndex:int) -> None
        C++: virtual void set_physical_event_position(double x, double y,
            double z, int pointerIndex)
        With VR we know the physical/room coordinate positions and
        orientations of events. These methods support setting them.
        """
        ret = self._wrap_call(self._vtk_obj.SetPhysicalEventPosition, *args)
        return ret

    _updateable_traits_ = \
    (('enable_render', 'GetEnableRender'), ('light_follow_camera',
    'GetLightFollowCamera'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('physical_scale', 'GetPhysicalScale'), ('translation3d',
    'GetTranslation3D'), ('alt_key', 'GetAltKey'), ('control_key',
    'GetControlKey'), ('desired_update_rate', 'GetDesiredUpdateRate'),
    ('dolly', 'GetDolly'), ('done', 'GetDone'), ('event_position',
    'GetEventPosition'), ('event_size', 'GetEventSize'), ('key_code',
    'GetKeyCode'), ('key_sym', 'GetKeySym'), ('last_event_position',
    'GetLastEventPosition'), ('number_of_fly_frames',
    'GetNumberOfFlyFrames'), ('pointer_index', 'GetPointerIndex'),
    ('recognize_gestures', 'GetRecognizeGestures'), ('repeat_count',
    'GetRepeatCount'), ('rotation', 'GetRotation'), ('scale', 'GetScale'),
    ('shift_key', 'GetShiftKey'), ('size', 'GetSize'),
    ('still_update_rate', 'GetStillUpdateRate'), ('timer_duration',
    'GetTimerDuration'), ('timer_event_duration',
    'GetTimerEventDuration'), ('timer_event_id', 'GetTimerEventId'),
    ('timer_event_platform_id', 'GetTimerEventPlatformId'),
    ('timer_event_type', 'GetTimerEventType'), ('translation',
    'GetTranslation'), ('use_t_dx', 'GetUseTDx'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'enable_render', 'global_warning_display',
    'light_follow_camera', 'alt_key', 'control_key',
    'desired_update_rate', 'dolly', 'done', 'event_position',
    'event_size', 'key_code', 'key_sym', 'last_event_position',
    'number_of_fly_frames', 'object_name', 'physical_scale',
    'pointer_index', 'recognize_gestures', 'repeat_count', 'rotation',
    'scale', 'shift_key', 'size', 'still_update_rate', 'timer_duration',
    'timer_event_duration', 'timer_event_id', 'timer_event_platform_id',
    'timer_event_type', 'translation', 'translation3d', 'use_t_dx'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(RenderWindowInteractor3D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit RenderWindowInteractor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['enable_render', 'light_follow_camera'], [], ['alt_key',
            'control_key', 'desired_update_rate', 'dolly', 'done',
            'event_position', 'event_size', 'key_code', 'key_sym',
            'last_event_position', 'number_of_fly_frames', 'object_name',
            'physical_scale', 'pointer_index', 'recognize_gestures',
            'repeat_count', 'rotation', 'scale', 'shift_key', 'size',
            'still_update_rate', 'timer_duration', 'timer_event_duration',
            'timer_event_id', 'timer_event_platform_id', 'timer_event_type',
            'translation', 'translation3d', 'use_t_dx']),
            title='Edit RenderWindowInteractor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit RenderWindowInteractor3D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

