# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_point_locator import AbstractPointLocator


class OctreePointLocator(AbstractPointLocator):
    r"""
    OctreePointLocator - an octree spatial decomposition of a set of
    points
    
    Superclass: AbstractPointLocator
    
    Given a DataSet, create an octree that is locally refined such
    that all leaf octants contain less than a certain amount of points. 
    Note that there is no size constraint that a leaf octant in relation
    to any of its neighbors.
    
    This class can also generate a poly_data representation of the
    boundaries of the spatial regions in the decomposition.
    
    @sa
    Locator PointLocator OctreePointLocatorNode
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkOctreePointLocator, obj, update, **traits)
    
    create_cubic_octants = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set macro for create_cubic_octants.
        """
    )

    def _create_cubic_octants_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCreateCubicOctants,
                        self.create_cubic_octants)

    fudge_factor = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _fudge_factor_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFudgeFactor,
                        self.fudge_factor)

    maximum_points_per_region = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Maximum number of points per spatial region.  Default is 100.
        """
    )

    def _maximum_points_per_region_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumPointsPerRegion,
                        self.maximum_points_per_region)

    def _get_number_of_leaf_nodes(self):
        return self._vtk_obj.GetNumberOfLeafNodes()
    number_of_leaf_nodes = traits.Property(_get_number_of_leaf_nodes, desc=\
        r"""
        The number of leaf nodes of the tree, the spatial regions
        """
    )

    def get_points_in_region(self, *args):
        """
        get_points_in_region(self, leafNodeId:int) -> IdTypeArray
        C++: IdTypeArray *get_points_in_region(int leafNodeId)
        Get a list of the original IDs of all points in a leaf node.
        """
        ret = self._wrap_call(self._vtk_obj.GetPointsInRegion, *args)
        return wrap_vtk(ret)

    def get_region_bounds(self, *args):
        """
        get_region_bounds(self, regionID:int, bounds:[float, float, float,
            float, float, float]) -> None
        C++: void get_region_bounds(int regionID, double bounds[6])
        Get the spatial bounds of octree region
        """
        ret = self._wrap_call(self._vtk_obj.GetRegionBounds, *args)
        return ret

    def get_region_containing_point(self, *args):
        """
        get_region_containing_point(self, x:float, y:float, z:float) -> int
        C++: int get_region_containing_point(double x, double y, double z)
        Get the id of the leaf region containing the specified location.
        """
        ret = self._wrap_call(self._vtk_obj.GetRegionContainingPoint, *args)
        return ret

    def get_region_data_bounds(self, *args):
        """
        get_region_data_bounds(self, leafNodeID:int, bounds:[float, float,
            float, float, float, float]) -> None
        C++: void get_region_data_bounds(int leafNodeID, double bounds[6])
        Get the bounds of the data within the leaf node
        """
        ret = self._wrap_call(self._vtk_obj.GetRegionDataBounds, *args)
        return ret

    def find_closest_point_in_region(self, *args):
        """
        find_closest_point_in_region(self, regionId:int, x:[float, ...],
            dist2:float) -> int
        C++: IdType find_closest_point_in_region(int regionId, double *x,
            double &dist2)
        find_closest_point_in_region(self, regionId:int, x:float, y:float,
            z:float, dist2:float) -> int
        C++: IdType find_closest_point_in_region(int regionId, double x,
            double y, double z, double &dist2)
        Find the Id of the point in the given leaf region which is
        closest to the given point.  Return the ID of the point, and set
        the square of the distance of between the points.
        """
        ret = self._wrap_call(self._vtk_obj.FindClosestPointInRegion, *args)
        return ret

    def find_points_in_area(self, *args):
        """
        find_points_in_area(self, area:[float, ...], ids:IdTypeArray,
            clearArray:bool=True) -> None
        C++: void find_points_in_area(double *area, IdTypeArray *ids,
            bool clearArray=true)
        Fill ids with points found in area.  The area is a 6-tuple
        containing (xmin, xmax, ymin, ymax, zmin, zmax). This method will
        clear the array by default.  To append ids to an array, set
        clearArray to false.
        """
        ret = self._wrap_call(self._vtk_obj.FindPointsInArea, *args)
        return ret

    _updateable_traits_ = \
    (('automatic', 'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('create_cubic_octants', 'GetCreateCubicOctants'), ('fudge_factor',
    'GetFudgeFactor'), ('maximum_points_per_region',
    'GetMaximumPointsPerRegion'), ('max_level', 'GetMaxLevel'),
    ('tolerance', 'GetTolerance'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'debug', 'global_warning_display',
    'use_existing_search_structure', 'create_cubic_octants',
    'fudge_factor', 'max_level', 'maximum_points_per_region',
    'object_name', 'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(OctreePointLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit OctreePointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'use_existing_search_structure'], [],
            ['create_cubic_octants', 'fudge_factor', 'max_level',
            'maximum_points_per_region', 'object_name', 'tolerance']),
            title='Edit OctreePointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit OctreePointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

