# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.writer import Writer


class NetCDFCFWriter(Writer):
    r"""
    NetCDFCFWriter - Writes netCDF files that follow the CF convention.
    
    Superclass: Writer
    
    Details on this convention can be found at
    <http://cfconventions.org/>
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkNetCDFCFWriter, obj, update, **traits)
    
    fill_blanked_attributes = tvtk_base.false_bool_trait(desc=\
        r"""
        If true, before writing to the file it fills all blanked cells
        and points in the attribute arrays with the fill value for the
        type. Default is false.
        """
    )

    def _fill_blanked_attributes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFillBlankedAttributes,
                        self.fill_blanked_attributes_)

    attribute_type = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Only arrays of this attribute type are saved in the file.
        (vtkdata_object::POINT or CELL). Saving only one type of arrays
        avoids issues with conflicting array names between points and
        cells. Default is DataObject::POINT
        """
    )

    def _attribute_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAttributeType,
                        self.attribute_type)

    cell_array_name_postfix = traits.String('_c', enter_set=True, auto_set=False, desc=\
        r"""
        VTK allows point and cell arrays with the same name, but net_cdf
        does not. This string is appended to a cell array name if it
        conflicts with a point array name when it is saved in a net_cdf
        file. Default is _c.
        """
    )

    def _cell_array_name_postfix_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCellArrayNamePostfix,
                        self.cell_array_name_postfix)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Get/Set the file name of the file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    fill_value = traits.Int(-2147483647, enter_set=True, auto_set=False, desc=\
        r"""
        Get/Set the fill_value for all array. Care must be taken to make
        sure the value fits in the value type of each array. Fill value
        has the same meaning as blanking in VTK but it is stored in the
        data array. This is stored in the net_cdf file.
        """
    )

    def _fill_value_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFillValue,
                        self.fill_value)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_grid_mapping_attribute(self, *args):
        """
        add_grid_mapping_attribute(self, name:str, value:str) -> None
        C++: void add_grid_mapping_attribute(const char *name,
            const char *value)
        add_grid_mapping_attribute(self, name:str, value:float) -> None
        C++: void add_grid_mapping_attribute(const char *name, double value)
        Add/clear attributes that define the grid mapping (or the
        coordinate reference system (CRS))
        
        
         To obtain the correct CF conventions attribute names and values
         when knowing the EPSG code use projinfo <epsg_code> This will
         print the WKT string. From that you can get the attribute names
         and values you need for CF convention.. The WKT attribute names
         are fairly close to CF convention attribute names.  The following
         link also helps with the conversion.
         <a
         href="https://github.com/cf-convention/cf-conventions/wiki/Mapping-from-CF-Grid-Mapping-Attributes-to-CRS-WKT-Elements">CF
         Grid Mapping to WKT</a> See also <a
         href="http://cfconventions.org/Data/cf-conventions/cf-conventions-1.9/cf-conventions.html#appendix-grid-mappings">CF
         Grid Mapping</a> for the attributes needed for each projection.
         
        """
        ret = self._wrap_call(self._vtk_obj.AddGridMappingAttribute, *args)
        return ret

    def clear_grid_mapping_attributes(self):
        """
        clear_grid_mapping_attributes(self) -> None
        C++: void clear_grid_mapping_attributes()"""
        ret = self._vtk_obj.ClearGridMappingAttributes()
        return ret
        

    _updateable_traits_ = \
    (('fill_blanked_attributes', 'GetFillBlankedAttributes'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('attribute_type', 'GetAttributeType'), ('cell_array_name_postfix',
    'GetCellArrayNamePostfix'), ('file_name', 'GetFileName'),
    ('fill_value', 'GetFillValue'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'fill_blanked_attributes',
    'global_warning_display', 'release_data_flag', 'attribute_type',
    'cell_array_name_postfix', 'file_name', 'fill_value', 'object_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(NetCDFCFWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit NetCDFCFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['fill_blanked_attributes'], [], ['attribute_type',
            'cell_array_name_postfix', 'file_name', 'fill_value', 'object_name']),
            title='Edit NetCDFCFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit NetCDFCFWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

