# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.hyper_tree_grid_algorithm import HyperTreeGridAlgorithm


class HyperTreeGridThreshold(HyperTreeGridAlgorithm):
    r"""
    HyperTreeGridThreshold - Extract cells from a hyper tree grid
    where selected scalar value is within given range.
    
    Superclass: HyperTreeGridAlgorithm
    
    This filter extracts cells from a hyper tree grid that satisfy the
    following threshold: a cell is considered to be within range if its
    value for the active scalar is within a specified range (inclusive).
    The output remains a hyper tree grid. JB Un parametre
    (just_create_new_mask=true) permet de ne pas faire le choix de la
    creation d'un nouveau HTG mais de redefinir juste le masque.
    
    @sa
    HyperTreeGrid HyperTreeGridAlgorithm Threshold
    
    @par Thanks: This class was written by Guenole Harel and
    Jacques-Bernard Lekien 2014 This class was revised by Philippe Pebay,
    2016 This class was optimized by Jacques-Bernard Lekien, 2018. This
    work was supported by Commissariat a l'Energie Atomique CEA, DAM,
    DIF, F-91297 Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridThreshold, obj, update, **traits)
    
    just_create_new_mask = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get True, create a new mask ; false, create a new HTG.
        """
    )

    def _just_create_new_mask_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetJustCreateNewMask,
                        self.just_create_new_mask)

    lower_threshold = traits.Float(2.2250738585072014e-308, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get minimum scalar value of threshold
        """
    )

    def _lower_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLowerThreshold,
                        self.lower_threshold)

    upper_threshold = traits.Float(1.7976931348623157e+308, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get maximum scalar value of threshold
        """
    )

    def _upper_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUpperThreshold,
                        self.upper_threshold)

    def threshold_between(self, *args):
        """
        threshold_between(self, __a:float, __b:float) -> None
        C++: void threshold_between(double, double)
        Convenience method to set both threshold values at once
        """
        ret = self._wrap_call(self._vtk_obj.ThresholdBetween, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('just_create_new_mask', 'GetJustCreateNewMask'), ('lower_threshold',
    'GetLowerThreshold'), ('upper_threshold', 'GetUpperThreshold'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'just_create_new_mask', 'lower_threshold',
    'object_name', 'progress_text', 'upper_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridThreshold, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridThreshold properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['just_create_new_mask', 'lower_threshold',
            'object_name', 'upper_threshold']),
            title='Edit HyperTreeGridThreshold properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridThreshold properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

