# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.mapper import Mapper


class HyperTreeGridMapper(Mapper):
    r"""
    HyperTreeGridMapper - map HyperTreeGrid to graphics primitives
    
    Superclass: Mapper
    
    * HyperTreeGridMapper is a class that maps polygonal data (i.e.,
      HyperTreeGrid)
    * to graphics primitives. HyperTreeGridMapper serves as a
      superclass for
    * device-specific poly data mappers, that actually do the mapping to
      the
    * rendering/graphics hardware/software.
    
    * By default, this class use an Adaptive geometry_filter that extract
      only
    * the part of the geometry to render. Be careful as this implies that
    new
    * render my trigger an update of the pipeline to get the new part of
      the
    * geometry to render.
    
    * Note: this class has its own module to avoid cyclic dependency
      between Rendering Core
    * and Filters Hybrid
    * * It need Filters Hybrid for adaptive2d_geometry_filter
    * * Filters Hybrid need Rendering Core because of
      adaptive2d_geometry_filter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkHyperTreeGridMapper, obj, update, **traits)
    
    use_adaptive_decimation = tvtk_base.false_bool_trait(desc=\
        r"""
        This boolean control whether or not the mapping should adapt to
        the Camera frustum during the rendering. Setting this variable to
        true (default) should provide increased performances.
        """
    )

    def _use_adaptive_decimation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseAdaptiveDecimation,
                        self.use_adaptive_decimation_)

    def _get_input_connection(self):
        if self._vtk_obj.GetTotalNumberOfInputConnections():
            return wrap_vtk(self._vtk_obj.GetInputConnection(0, 0))
        else:
            return None
    
    def _set_input_connection(self, obj):
        old_val = self._get_input_connection()
        self._wrap_call(self._vtk_obj.SetInputConnection, deref_vtk(obj))
        self.trait_property_changed('input_connection', old_val, obj)
    input_connection = traits.Property(_get_input_connection,
                                       _set_input_connection,
                                       desc="The first input connection for this object, i.e. the result of `get_input_connection(0, 0)`.")
    
    def get_input_connection(self, *args):
        """
        get_input_connection(self, port:int, index:int)
            -> AlgorithmOutput
        C++: AlgorithmOutput *get_input_connection(int port, int index)
        Get the algorithm output port connected to an input port.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputConnection, *args)
        return wrap_vtk(ret)

    def set_input_connection(self, *args):
        """
        set_input_connection(self, port:int, input:AlgorithmOutput)
            -> None
        C++: virtual void set_input_connection(int port,
            AlgorithmOutput *input)
        set_input_connection(self, input:AlgorithmOutput) -> None
        C++: virtual void set_input_connection(AlgorithmOutput *input)
        Set the connection for the given input port index.  Each input
        port of a filter has a specific purpose.  A port may have zero or
        more connections and the required number is specified by each
        filter.  Setting the connection with this method removes all
        other connections from the port.  To add more than one connection
        use add_input_connection().
        
        * The input for the connection is the output port of another
        * filter, which is obtained with get_output_port().  Typical usage
          is
        
        * filter2->set_input_connection(0, filter1->get_output_port(0)).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnection, *my_args)
        return ret

    def get_input_data_object(self, *args):
        """
        get_input_data_object(self, port:int, connection:int)
            -> DataObject
        C++: DataObject *get_input_data_object(int port, int connection)
        Get the data object that will contain the algorithm input for the
        given port and given connection.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputDataObject, *args)
        return wrap_vtk(ret)

    def set_input_data_object(self, *args):
        """
        set_input_data_object(self, port:int, input:DataObject) -> None
        C++: void set_input_data_object(int port, DataObject *input)
            override;
        set_input_data_object(self, input:DataObject) -> None
        
        Set the connection for the given input port index.  Each input
        port of a filter has a specific purpose.  A port may have zero or
        more connections and the required number is specified by each
        filter.  Setting the connection with this method removes all
        other connections from the port.  To add more than one connection
        use add_input_connection(). The input for the connection is the
        output port of another filter, which is obtained with
        get_output_port().  Typical usage is filter2->set_input_connection(0,
        filter1->get_output_port(0)).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputDataObject, *my_args)
        return ret

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input as a DataSet.  This method is overridden in the
        specialized mapper classes to return more specific data types.
        """
    )

    def fill_input_port_information(self, *args):
        """
        fill_input_port_information(self, port:int, info:Information)
            -> int
        C++: int fill_input_port_information(int port, Information *info)
            override;
        Fill the input port information objects for this algorithm.  This
        is invoked by the first call to get_input_port_information for each
        port so subclasses can specify what they can handle.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.FillInputPortInformation, *my_args)
        return ret

    _updateable_traits_ = \
    (('use_adaptive_decimation', 'GetUseAdaptiveDecimation'),
    ('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('scalar_visibility',
    'GetScalarVisibility'), ('static', 'GetStatic'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('scalar_mode', 'GetScalarMode'),
    ('array_access_mode', 'GetArrayAccessMode'), ('array_component',
    'GetArrayComponent'), ('array_id', 'GetArrayId'), ('array_name',
    'GetArrayName'), ('field_data_tuple_id', 'GetFieldDataTupleId'),
    ('render_time', 'GetRenderTime'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('scalar_range',
    'GetScalarRange'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_scalars_before_mapping', 'release_data_flag',
    'scalar_visibility', 'static', 'use_adaptive_decimation',
    'use_lookup_table_scalar_range', 'color_mode',
    'resolve_coincident_topology', 'scalar_mode', 'array_access_mode',
    'array_component', 'array_id', 'array_name', 'field_data_tuple_id',
    'object_name', 'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(HyperTreeGridMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit HyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_scalars_before_mapping', 'scalar_visibility',
            'static', 'use_adaptive_decimation', 'use_lookup_table_scalar_range'],
            ['color_mode', 'resolve_coincident_topology', 'scalar_mode'],
            ['array_access_mode', 'array_component', 'array_id', 'array_name',
            'field_data_tuple_id', 'object_name', 'render_time',
            'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range']),
            title='Edit HyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit HyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

