# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class GenerateTimeSteps(PassInputTypeAlgorithm):
    r"""
    GenerateTimeSteps - Generate timesteps on any input
    
    Superclass: PassInputTypeAlgorithm
    
    A PassInputTypeAlgorithm that add timesteps during the request
    information pass and just shallow copy its input to its output. Input
    timesteps are completely ignored and the first timestep will be
    requested if any.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkGenerateTimeSteps, obj, update, **traits)
    
    def get_time_step_values(self, *args):
        """
        get_time_step_values(self, timeStepValues:[float, ...]) -> None
        C++: void get_time_step_values(double *timeStepValues)"""
        ret = self._wrap_call(self._vtk_obj.GetTimeStepValues, *args)
        return ret

    def set_time_step_values(self, *args):
        """
        set_time_step_values(self, count:int, timeStepValues:(float, ...))
            -> None
        C++: void set_time_step_values(int count,
            const double *timeStepValues)
        Get/Set an array of time step values. For the Get function,
        timestep_values should be big enough for get_number_of_time_steps()
        values.
        """
        ret = self._wrap_call(self._vtk_obj.SetTimeStepValues, *args)
        return ret

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def _get_number_of_time_steps(self):
        return self._vtk_obj.GetNumberOfTimeSteps()
    number_of_time_steps = traits.Property(_get_number_of_time_steps, desc=\
        r"""
        Get the number of time steps that will be extracted
        """
    )

    def add_time_step_value(self, *args):
        """
        add_time_step_value(self, timeStepValue:float) -> None
        C++: void add_time_step_value(double timeStepValue)
        Add a time step value.
        """
        ret = self._wrap_call(self._vtk_obj.AddTimeStepValue, *args)
        return ret

    def clear_time_step_values(self):
        """
        clear_time_step_values(self) -> None
        C++: void clear_time_step_values()
        Clear the time step values
        """
        ret = self._vtk_obj.ClearTimeStepValues()
        return ret
        

    def generate_time_step_values(self, *args):
        """
        generate_time_step_values(self, begin:float, end:float, step:float)
            -> None
        C++: void generate_time_step_values(double begin, double end,
            double step)
        Generate a range of values in [begin, end) with a step size of
        'step'
        """
        ret = self._wrap_call(self._vtk_obj.GenerateTimeStepValues, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(GenerateTimeSteps, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit GenerateTimeSteps properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit GenerateTimeSteps properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit GenerateTimeSteps properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

