# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.selection_algorithm import SelectionAlgorithm


class AppendSelection(SelectionAlgorithm):
    r"""
    AppendSelection - appends one or more selections together
    
    Superclass: SelectionAlgorithm
    
    AppendSelection is a filter that appends one of more selections
    into a single selection.
    
    If append_by_union is true, all selections must have the same content
    type and they are combined together to form a single Selection
    output.
    
    If append_by_union is false, the output is a composite selection with
    input selections as the children of the composite selection. This
    allows for selections with different content types and properties.
    
    If append_by_union is true, an Expression can be defined which uses the
    input selection names to define the relation between the selections.
    If the Expression is not defined, all the selection are combined
    using the '| 'boolean operator.
    
    @warning It should be noted that this filter is not responsible for
        checking if
    the field type is the same across all selections nodes of all
    selections.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAppendSelection, obj, update, **traits)
    
    append_by_union = tvtk_base.true_bool_trait(desc=\
        r"""
        When set to true, all the selections are combined together to
        form a single Selection output. When set to false, the output
        is a composite selection with input selections as the children of
        the composite selection. This allows for selections with
        different content types and properties.
        
        The default is true.
        """
    )

    def _append_by_union_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetAppendByUnion,
                        self.append_by_union_)

    inverse = tvtk_base.false_bool_trait(desc=\
        r"""
        Determines whether the selection describes what to include or
        exclude.
        
        The default is false, meaning include.
        
        NOTE: If you want to use Inverse, append_by_union MUST be set to
        false. If Expression is set, then the inverse flag inverses it
        (internally) without modifying it.
        """
    )

    def _inverse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInverse,
                        self.inverse_)

    user_managed_inputs = tvtk_base.false_bool_trait(desc=\
        r"""
        user_managed_inputs allows the user to set inputs by number instead
        of using the add_input/remove_input functions. Calls to
        set_number_of_inputs/set_input_by_number should not be mixed with calls
        to add_input/remove_input.
        
        The default is false.
        """
    )

    def _user_managed_inputs_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUserManagedInputs,
                        self.user_managed_inputs_)

    expression = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the expression that defines the boolean expression to
        combine the selections. Expression consists of node name
        identifiers, `|` for boolean-or, '^' for boolean-xor, '&' for
        boolean and, '!' for boolean not, and parenthesis `(` and `)`. If
        you want to set the expression, be sure to define the node names.
        If no expression is specified and there are multiple selections,
        then the default expression simply combines all the selection
        nodes using an `or` operator.
        
        `set_expression` does not validate the expression. It will be
        validated `internally.
        
        NOTE: If you want to use the expression, append_by_union MUST be
        set to false, and the input selection names MUST be defined.
        """
    )

    def _expression_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExpression,
                        self.expression)

    def get_input_name(self, *args):
        """
        get_input_name(self, index:int) -> str
        C++: const char *get_input_name(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetInputName, *args)
        return ret

    def set_input_name(self, *args):
        """
        set_input_name(self, index:int, name:str) -> None
        C++: void set_input_name(int index, const char *name)
        Set/Get names for inputs selections.
        
        NOTE: Input selection names are useful only if you have set the
        Expression, and append_by_union is set to false.
        """
        ret = self._wrap_call(self._vtk_obj.SetInputName, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self, idx:int) -> Selection
        C++: Selection *get_input(int idx)
        get_input(self) -> Selection
        C++: Selection *get_input()
        Get any input of this filter.
        """
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def add_input_data(self, *args):
        """
        add_input_data(self, __a:Selection) -> None
        C++: void add_input_data(Selection *)
        Add a dataset to the list of data to append. Should not be used
        when user_managed_inputs is true, use set_input_by_number instead.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.AddInputData, *my_args)
        return ret

    def remove_all_input_names(self):
        """
        remove_all_input_names(self) -> None
        C++: void remove_all_input_names()
        Remove all assigned input selection names.
        """
        ret = self._vtk_obj.RemoveAllInputNames()
        return ret
        

    def remove_input_data(self, *args):
        """
        remove_input_data(self, __a:Selection) -> None
        C++: void remove_input_data(Selection *)
        Remove a dataset from the list of data to append. Should not be
        used when user_managed_inputs is true, use set_input_by_number
        (nullptr) instead.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.RemoveInputData, *my_args)
        return ret

    def set_input_connection_by_number(self, *args):
        """
        set_input_connection_by_number(self, num:int,
            input:AlgorithmOutput) -> None
        C++: void set_input_connection_by_number(int num,
            AlgorithmOutput *input)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnectionByNumber, *my_args)
        return ret

    def set_number_of_inputs(self, *args):
        """
        set_number_of_inputs(self, num:int) -> None
        C++: void set_number_of_inputs(int num)
        Directly set(allocate) number of inputs, should only be used when
        user_managed_inputs is true.
        """
        ret = self._wrap_call(self._vtk_obj.SetNumberOfInputs, *args)
        return ret

    _updateable_traits_ = \
    (('append_by_union', 'GetAppendByUnion'), ('inverse', 'GetInverse'),
    ('user_managed_inputs', 'GetUserManagedInputs'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('expression', 'GetExpression'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'append_by_union', 'debug',
    'global_warning_display', 'inverse', 'release_data_flag',
    'user_managed_inputs', 'expression', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AppendSelection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AppendSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['append_by_union', 'inverse', 'user_managed_inputs'], [],
            ['expression', 'object_name']),
            title='Edit AppendSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AppendSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

