# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.volume_mapper import VolumeMapper


class AMRVolumeMapper(VolumeMapper):
    r"""
    AMRVolumeMapper - AMR class for a volume mapper
    
    Superclass: VolumeMapper
    
    AMRVolumeMapper is the definition of a volume mapper. for AMR
    Structured Data
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMRVolumeMapper, obj, update, **traits)
    
    interpolation_mode = tvtk_base.RevPrefixMap({'cubic': 2, 'linear': 1, 'nearest_neighbor': 0}, default_value='cubic', desc=\
        r"""
        Set interpolation mode for downsampling (lowres GPU) (initial
        value: cubic).
        """
    )

    def _interpolation_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolationMode,
                        self.interpolation_mode_)

    requested_render_mode = tvtk_base.RevPrefixMap({'gpu': 0, 'default': 0, 'ray_cast': 2, 'ray_cast_and_texture': 1, 'texture': 3}, default_value='gpu', desc=\
        r"""
        Set the requested render mode. The default is
        SmartVolumeMapper::DefaultRenderMode.
        """
    )

    def _requested_render_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRequestedRenderMode,
                        self.requested_render_mode_)

    array_access_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _array_access_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayAccessMode,
                        self.array_access_mode)

    cropping_region_planes = traits.Array(enter_set=True, auto_set=False, shape=(6,), dtype="float", value=(0.0, 1.0, 0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the Cropping Region Planes ( xmin, xmax, ymin, ymax,
        zmin, zmax ) These planes are defined in volume coordinates -
        spacing and origin are considered.
        """
    )

    def _cropping_region_planes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCroppingRegionPlanes,
                        self.cropping_region_planes)

    freeze_focal_point = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _freeze_focal_point_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFreezeFocalPoint,
                        self.freeze_focal_point)

    def _get_input_connection(self):
        if self._vtk_obj.GetTotalNumberOfInputConnections():
            return wrap_vtk(self._vtk_obj.GetInputConnection(0, 0))
        else:
            return None
    
    def _set_input_connection(self, obj):
        old_val = self._get_input_connection()
        self._wrap_call(self._vtk_obj.SetInputConnection, deref_vtk(obj))
        self.trait_property_changed('input_connection', old_val, obj)
    input_connection = traits.Property(_get_input_connection,
                                       _set_input_connection,
                                       desc="The first input connection for this object, i.e. the result of `get_input_connection(0, 0)`.")
    
    def get_input_connection(self, *args):
        """
        get_input_connection(self, port:int, index:int)
            -> AlgorithmOutput
        C++: AlgorithmOutput *get_input_connection(int port, int index)
        Get the algorithm output port connected to an input port.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputConnection, *args)
        return wrap_vtk(ret)

    def set_input_connection(self, *args):
        """
        set_input_connection(self, port:int, input:AlgorithmOutput)
            -> None
        C++: void set_input_connection(int port, AlgorithmOutput *input)
            override;
        set_input_connection(self, input:AlgorithmOutput) -> None
        
        Set the connection for the given input port index.  Each input
        port of a filter has a specific purpose.  A port may have zero or
        more connections and the required number is specified by each
        filter.  Setting the connection with this method removes all
        other connections from the port.  To add more than one connection
        use add_input_connection().
        
        * The input for the connection is the output port of another
        * filter, which is obtained with get_output_port().  Typical usage
          is
        
        * filter2->set_input_connection(0, filter1->get_output_port(0)).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnection, *my_args)
        return ret

    number_of_samples = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="int", value=(128, 128, 128), cols=3, desc=\
        r"""
        Set/Get the number of samples/cells along the i/j/k directions.
        The default is 128x128x128
        """
    )

    def _number_of_samples_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfSamples,
                        self.number_of_samples)

    requested_resampling_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Select the type of resampling technique approach to use.
        """
    )

    def _requested_resampling_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRequestedResamplingMode,
                        self.requested_resampling_mode)

    resampler_update_tolerance = traits.Float(1e-07, enter_set=True, auto_set=False, desc=\
        r"""
        Sets/Gets the tolerance used to determine if the resampler needs
        to be updated. Default is 10e-8
        """
    )

    def _resampler_update_tolerance_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResamplerUpdateTolerance,
                        self.resampler_update_tolerance)

    use_default_threading = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Sets/Gets a flag that indicates the internal volume mapper should
        use the  default number of threads.  This is useful in
        applications such as para_view that will turn off multiple threads
        by default. Default is false
        """
    )

    def _use_default_threading_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseDefaultThreading,
                        self.use_default_threading)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataSet
        C++: virtual DataSet *get_input()
        get_input(self, port:int) -> DataSet
        C++: virtual DataSet *get_input(const int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def compute_resampler_bounds_frustum_method(self, *args):
        """
        compute_resampler_bounds_frustum_method(camera:Camera,
            renderer:Renderer, data_bounds:(float, float, float, float,
             float, float), out_bounds:[float, float, float, float, float,
             float]) -> bool
        C++: static bool compute_resampler_bounds_frustum_method(
            Camera *camera, Renderer *renderer,
            const double data_bounds[6], double out_bounds[6])
        Utility method used by update_resampler_frustrum_method() to compute
        the bounds.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ComputeResamplerBoundsFrustumMethod, *my_args)
        return ret

    def update_resampler(self, *args):
        """
        update_resampler(self, ren:Renderer, amr:OverlappingAMR)
            -> None
        C++: void update_resampler(Renderer *ren,
            OverlappingAMR *amr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateResampler, *my_args)
        return ret

    def update_resampler_frustrum_method(self, *args):
        """
        update_resampler_frustrum_method(self, ren:Renderer,
            amr:OverlappingAMR) -> None
        C++: void update_resampler_frustrum_method(Renderer *ren,
            OverlappingAMR *amr)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.UpdateResamplerFrustrumMethod, *my_args)
        return ret

    _updateable_traits_ = \
    (('compute_normal_from_opacity', 'GetComputeNormalFromOpacity'),
    ('cropping', 'GetCropping'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('interpolation_mode', 'GetInterpolationMode'),
    ('requested_render_mode', 'GetRequestedRenderMode'), ('blend_mode',
    'GetBlendMode'), ('cropping_region_flags', 'GetCroppingRegionFlags'),
    ('scalar_mode', 'GetScalarMode'), ('array_access_mode',
    'GetArrayAccessMode'), ('cropping_region_planes',
    'GetCroppingRegionPlanes'), ('freeze_focal_point',
    'GetFreezeFocalPoint'), ('number_of_samples', 'GetNumberOfSamples'),
    ('requested_resampling_mode', 'GetRequestedResamplingMode'),
    ('resampler_update_tolerance', 'GetResamplerUpdateTolerance'),
    ('use_default_threading', 'GetUseDefaultThreading'),
    ('average_ip_scalar_range', 'GetAverageIPScalarRange'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_normal_from_opacity', 'cropping', 'debug',
    'global_warning_display', 'release_data_flag', 'blend_mode',
    'cropping_region_flags', 'interpolation_mode',
    'requested_render_mode', 'scalar_mode', 'array_access_mode',
    'average_ip_scalar_range', 'cropping_region_planes',
    'freeze_focal_point', 'number_of_samples', 'object_name',
    'progress_text', 'requested_resampling_mode',
    'resampler_update_tolerance', 'use_default_threading'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMRVolumeMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_normal_from_opacity', 'cropping'], ['blend_mode',
            'cropping_region_flags', 'interpolation_mode',
            'requested_render_mode', 'scalar_mode'], ['array_access_mode',
            'average_ip_scalar_range', 'cropping_region_planes',
            'freeze_focal_point', 'number_of_samples', 'object_name',
            'requested_resampling_mode', 'resampler_update_tolerance',
            'use_default_threading']),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMRVolumeMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

