// Tags: JDK1.1

//Copyright (C) 2003 Stephen Crawley <crawley@dstc.edu.au>
//Copyright (C) 2004 Robert Schuster <thebohemian@gmx.net>

//Mauve is free software; you can redistribute it and/or modify
//it under the terms of the GNU General Public License as published by
//the Free Software Foundation; either version 2, or (at your option)
//any later version.

//Mauve is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.

//You should have received a copy of the GNU General Public License
//along with Mauve; see the file COPYING.  If not, write to
//the Free Software Foundation, 59 Temple Place - Suite 330,
//Boston, MA 02111-1307, USA.  */

package gnu.testlet.java.beans.PropertyDescriptor;
import gnu.testlet.Testlet;
import gnu.testlet.TestHarness;
import java.beans.*;

/** This tests the <code>PropertyDescriptor</code> using certain classes
 * ofthe Java API (e.g. <code>java.awt.Component</code>).
 * 
 * @author Stephen Crawley <crawley@dstc.edu.au>
 * @author Robert Schuster <thebohemian@gmx.net>
 */
public class constructorTest1 implements Testlet
{
    public void test(TestHarness harness)
    {
        boolean ok;

        ok = true;
        try
        {
            /* This constructor expects the property being read and writable.
             * The "name" property of java.awt.Component fullfills this
             * requirement and an IntrospectionException would mean an
             * implementation error.
             * 
             * note: this is a weak test because it does not check whether the
             * PropertyDescriptor instance is created properly.
             */
            new PropertyDescriptor("name", java.awt.Component.class);
        }
        catch (IntrospectionException e)
        {
            harness.debug(e);
            ok = false;
        }
        harness.check(ok);

        ok = true;
        try
        {
            /* Same constructor as above. The "visible" property is
             * read- and writeable. An IntrospectionException would denote
             * an error in the implementation.
             * 
             * note: this is a weak test because it does not check whether the
             * PropertyDescriptor instance is created properly.
             */
            new PropertyDescriptor("visible", java.awt.Component.class);
        }
        catch (IntrospectionException e)
        {
            harness.debug(e);
            ok = false;
        }
        harness.check(ok);

        ok = false;
        try
        {
            /* This instantiantion should fail because java.lang.Object has no "setClass" method
             * (= is read-only).
             */
            new PropertyDescriptor("class", java.lang.Object.class);
        }
        catch (IntrospectionException e)
        {
            ok = true;
        }
        harness.check(ok);

    }
    
}
