dnl AC_WITH_CCLIENT([ACTION-IF-FOUND[,ACTION-IF-NOT-FOUND]])
dnl Output:
dnl AC_SUBST: @CCLIENT_INCLUDES@ @CCLIENT_LIBS@ @CCLIENT_CXXFLAGS@
dnl AM_CONDITIONAL: HAVE_CCLIENT
AC_DEFUN([AC_WITH_CCLIENT],[
 CCLIENTLOCATIONS="/usr,/usr/local"
 HAVE_CCLIENT="no"
 CCLIENT_LIBS=""
 CCLIENT_INCLUDES=""
 CCLIENT_CXXFLAGS=""
 CCLIENT_LINKAGE_C=""
 CCLIENT_LINKAGE_H=""
 AC_ARG_WITH(c-client,
  AC_HELP_STRING([--with-c-client=path],[enable use of c-client]),
  [
   if test "$withval" = "no" ; then
    CCLIENTLOCATIONS=""
   else
    test "$withval" = "yes" || CCLIENTLOCATIONS="$withval,${CCLIENTLOCATIONS}"
   fi
  ]
 )
 if test -z "${CCLIENTLOCATIONS}" ; then
  ifelse([$2], , :, [$2])
 else

  dnl
  dnl Looking for headers c-client headers
  dnl
   AC_MSG_CHECKING([for c-client.h])
  for p in `eval "echo {${CCLIENTLOCATIONS}}{,/c-client,/lib/c-client,/include/c-client,/include,/include/imap}"` ; do
   if test -r "${p}/c-client.h" -a -r "${p}/linkage.h" -a -r "${p}/linkage.c" ; then
    CCLIENT_INCLUDES="-I${p}"
    CCLIENT_LINKAGE_H="${p}/linkage.h"
    CCLIENT_LINKAGE_C="${p}/linkage.c"
    AC_MSG_RESULT([found in ${p}])
    break
   fi
  done
  if test -z "${CCLIENT_INCLUDES}" ; then
   AC_MSG_RESULT([not found])
   ifelse([$2], , :, [$2])
  else
   
   dnl
   dnl Looking for c-client libraries
   dnl
   AC_MSG_CHECKING([for c-client library])
   for l in `eval "echo {${CCLIENTLOCATIONS}}{,/c-client,/lib/c-client,/lib,/lib64}/{libc-client,libc-client4,c-client}.so"` ; do
    if test -r "$l" ; then
     AC_MSG_RESULT([found ${l}])
     CCLIENT_LIBS="$l"
     break
    fi
   done
   if test -z "${CCLIENT_LIBS}" ; then
    AC_MSG_RESULT([not found])
    ifelse([$2], , :, [$2])
   else
    AC_LANG_PUSH(C++)
     xCPPFLAGS="${CPPFLAGS}"
     xCXXFLAGS="${CXXFLAGS}"
     CPPFLAGS="${CPPFLAGS} ${CCLIENT_INCLUDES}"
     opernames_resolved="no"
     AC_MSG_CHECKING([if c-client works without -fno-operator-names in c++])
     AC_COMPILE_IFELSE(
      [AC_LANG_SOURCE([
       #include <stdio.h>
       #include "c-client.h"
      ])],[
       AC_MSG_RESULT([yes])
       opernames_resolved="yes"
      ],[
       AC_MSG_RESULT([no])
       AC_MSG_CHECKING([if adding -fno-operator-names helps])
       CXXFLAGS="${CXXFLAGS} -fno-operator-names"
       AC_COMPILE_IFELSE(
        [AC_LANG_SOURCE([
         #include <stdio.h>
         #include "c-client.h"
        ])],[
         AC_MSG_RESULT([yes])
         CCLIENT_CXXFLAGS=-fno-operator-names
         opernames_resolved="yes"
        ],[
         AC_MSG_RESULT([no])
        ]
       )
      ]
     )
     CXXFLAGS="${xCXXFLAGS}"
     CPPFLAGS="${xCPPFLAGS}"
    AC_LANG_POP(C++)
    if test "${opernames_resolved}" = "no" ; then
     ifelse([$2], , :, [$2])
    else
     HAVE_CCLIENT=yes
     AC_SUBST(CCLIENT_CXXFLAGS)
     AC_SUBST(CCLIENT_INCLUDES)
     AC_SUBST(CCLIENT_LIBS)
     ifelse([$1], , :, [$1])
    fi
   fi
  fi
 fi
 AM_CONDITIONAL(HAVE_CCLIENT,[test "${HAVE_CCLIENT}" = "yes"])
])
