/*
 * Copyright (C) 2003  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please report bugs at http://bugzilla.lysator.liu.se/. 
 */

/*
 * Implementation of the types in misc-type.h.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "misc-types.h"

#if defined(SUCCESS_AS_PTR) || defined(TYPE_CHECK_COMPILATION)

static struct success succ_ok;
static struct success succ_failure;

const struct success *const OK = &succ_ok;
const struct success *const FAILURE = &succ_failure;

#else

/* Some compilers requires translation units to be non-empty.  */
extern int misc_types_must_be_nonempty;
extern int misc_types_must_be_nonempty = 'm';

#endif
