#!/usr/bin/env lua

local ln = 0

for l in io.lines() do
   ln = ln + 1
   if l:sub(1, 1) == "?" then
      local var = l:match "E%((.*)%)"
      if var == nil then
	 io.stderr:write(("unable to parse line %d\n"):format(ln))
	 os.exit(1)
      end
      l = ("#ifdef %s\n        E(%s),\n#endif"):format(var, var)
   end
   print(l)
end
