/***********************************************************************************

    Copyright (C) 2007-2011 Ahmet Öztürk (aoz_2@yahoo.com)

    This file is part of Lifeograph.

    Lifeograph is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Lifeograph is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Lifeograph.  If not, see <http://www.gnu.org/licenses/>.

***********************************************************************************/


#ifndef LIFEOGRAPH_DIARY_TAG_GUI_HEADER
#define LIFEOGRAPH_DIARY_TAG_GUI_HEADER


namespace LIFEO
{

// PANEL EXTRA ITEMS
class PanelExtra : public Gtk::TreeView
{
    public:
        class Colrec : public Gtk::TreeModel::ColumnRecord
        {
            public:
                Colrec()
                {
                    add( icon );
                    add( name );
                    add( ptr );
                }
                Gtk::TreeModelColumn< Glib::RefPtr< Gdk::Pixbuf > >     icon;
                Gtk::TreeModelColumn< Glib::ustring >                   name;
                Gtk::TreeModelColumn< DiaryElement* >                   ptr;
        };
        static Colrec               *colrec;

                                    PanelExtra( BaseObjectType*,
                                                const Glib::RefPtr<Gtk::Builder>& );

        void                        handle_login( void );
        void                        handle_logout( void );

        void                        populate( void );
        Gtk::TreeIter               add_elem_to_list( DiaryElement*,
                                                      const Gtk::TreeNodeChildren* = NULL );

        Gtk::TreeRow                get_row( const Gtk::TreePath& );

    protected:
        void                        handle_treeview_drag_begin(
                                            const Glib::RefPtr< Gdk::DragContext >& );
        void                        handle_drag_data_get( const Glib::RefPtr<Gdk::DragContext>&,
                                                          Gtk::SelectionData&,
                                                          guint, guint );
        bool                        on_drag_motion( const Glib::RefPtr< Gdk::DragContext >&,
                                                    int, int, guint );
        bool                        on_drag_drop( const Glib::RefPtr< Gdk::DragContext >&,
                                                  int, int, guint );
        bool                        on_button_press_event( GdkEventButton* );
        bool                        on_button_release_event( GdkEventButton* );
        void                        handle_treeview_row_expanded( const Gtk::TreeIter&,
                                                                  const Gtk::TreePath& );
        void                        handle_treeview_row_activated( const Gtk::TreePath&,
                                                                   Gtk::TreeViewColumn* );

        void                        cell_data_func_icon( Gtk::CellRenderer*,
                                                         const Gtk::TreeModel::iterator& );
        void                        cell_data_func_text( Gtk::CellRenderer*,
                                                         const Gtk::TreeModel::iterator& );

        Glib::RefPtr< Gtk::TreeStore >
                                    m_treestore_all_tags;

        Entry                       *m_ptr2entry;
        DiaryElement                *m_elem_drop_target;

        bool                        m_flag_themes_expanded;

    friend class Lifeograph;
};

} // end of namespace LIFEO

#endif

