#include "aaaa_rr.h"
 
namespace ADNS {

	AAAA_RR::AAAA_RR()
	{
		array<Byte>^ b = gcnew array<Byte>(16);
		b->Clear(b,0,16);
		addr = gcnew IPAddress(b);
		rr_type = RR_TYPE::AAAA;
		rr_class = RR_CLASS::IN;
		UpdateRdata();
	}

	AAAA_RR::AAAA_RR(array<Byte>^ ip)
	{
		addr = gcnew IPAddress(ip);
		UpdateRdata();
	}

	IPAddress^ AAAA_RR::GetAddress()
	{
		return gcnew IPAddress(addr->GetAddressBytes());
	}

	Void AAAA_RR::SetAddress(IPAddress^ ip)
	{
		addr = gcnew IPAddress(ip->GetAddressBytes());
		UpdateRdata();
	}

	Void AAAA_RR::SetAddress(array<Byte>^ ip)
	{
		addr = gcnew IPAddress(ip);
		UpdateRdata();
	}

	Void AAAA_RR::UpdateRdata()
	{
		if (!rdata)
			rdata = gcnew array<Byte>(16);
		
		addr->GetAddressBytes()->CopyTo(rdata,0);

		return;
	}

	String^ AAAA_RR::Print()
	{
		String^ output;

		output = PrintHeader();
		output += " " + addr->ToString();

		return output;
	}

	AAAA_RR^ AAAA_RR::Clone()
	{
		AAAA_RR^ newrr = gcnew AAAA_RR();
		newrr->SetAddress(addr);
		newrr->rr_type = rr_type;
		newrr->owner = owner->Clone();
		newrr->ttl = ttl;
		newrr->rr_class = rr_class;
		newrr->UpdateRdata();
		return newrr;
	}

	ResourceRecord^ AAAA_RR::ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start)
	{
		AAAA_RR^ aaaaout;
		array<Byte>^ tmparray;

		tmparray = gcnew array<Byte>(rdata_len);
		packet->Copy(packet,rdata_start,tmparray,0,rdata_len);
		aaaaout = gcnew AAAA_RR(tmparray);
		aaaaout->rr_class = (RR_CLASS) rr_class;
		aaaaout->ttl = ttl;
		aaaaout->owner = gcnew DOMAIN_NAME(domainname);

		return aaaaout;
	}

	String^ AAAA_RR::PrintRR(ResourceRecord^ rec)
	{
		return safe_cast<AAAA_RR^>(rec)->Print();
	}

	ResourceRecord^ AAAA_RR::CloneRR(ResourceRecord^ rec)
	{
		return safe_cast<AAAA_RR^>(rec)->Clone();
	}
}

		