#ifndef ALGO_BLAST_GUMBEL_PARAMS__INCLUDED_NJN_DOUBLETYPE
#define ALGO_BLAST_GUMBEL_PARAMS__INCLUDED_NJN_DOUBLETYPE

/* $Id: njn_doubletype.hpp 183505 2010-02-18 16:10:58Z boratyng $
* ===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's offical duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================*/

/*****************************************************************************

File name: njn_doubletype.hpp

Author: John Spouge

Contents: 

******************************************************************************/

#include <corelib/ncbistl.hpp>


BEGIN_NCBI_SCOPE
BEGIN_SCOPE(blast)

BEGIN_SCOPE(Njn)
BEGIN_SCOPE(DoubleType)

      // Constants

      const double ROOT_2        =      1.4142135623730951e+000; // square root of 2.0
      const double ROOT_10       =      3.1622776601683795e+000; // square root of 10.0

      const double PI            =      3.1415926535897931e+000; // pi = ratio circumference to diameter
      const double ROOT_PI       =      1.7724538509055159e+000; // square root of pi
      const double ROOT_2_PI     =      2.5066282746310002e+000; // square root of 2.0 * pi

      const double E             =      2.7182818284590451e+000; // base of natural logarithms
      const double LN_2          =      6.9314718055994529e-001; // natural log of 2.0
      const double LN_10         =      2.3025850929940459e+000; // natural log of 10.0
      const double LN_LN_2       =     -3.6651292058166435e-001; // log of log of 2.0

      const double EULER         =      0.5772156649015325e+000; // Euler's constant gamma

END_SCOPE(DoubleType)
END_SCOPE(Njn)


END_SCOPE(blast)
END_NCBI_SCOPE

#endif //! ALGO_BLAST_GUMBEL_PARAMS__INCLUDED_NJN_DOUBLETYPE
