#ifndef KLOG_CLUSTER_DXSPOT_H
#define KLOG_CLUSTER_DXSPOT_H
/***************************************************************************
                          dxspot.h  -  description
                             -------------------
    begin                : Apr 2024
    copyright            : (C) 2024 by Jaime Robles
    email                : jaime@robles.es
 ***************************************************************************/

/*****************************************************************************
 * This file is part of KLog.                                                *
 *                                                                           *
 *    KLog is free software: you can redistribute it and/or modify           *
 *    it under the terms of the GNU General Public License as published by   *
 *    the Free Software Foundation, either version 3 of the License, or      *
 *    (at your option) any later version.                                    *
 *                                                                           *
 *    KLog is distributed in the hope that it will be useful,                *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *    GNU General Public License for more details.                           *
 *                                                                           *
 *    You should have received a copy of the GNU General Public License      *
 *    along with KLog.  If not, see <https://www.gnu.org/licenses/>.         *
 *                                                                           *
 *****************************************************************************/
/*
    This class implements DXSpot.
*/
#include <QObject>
#include <QDateTime>
#include "../klogdefinitions.h"
#include "../frequency.h"

class DXSpot
{
    friend class tst_DXSpot;

public:
    DXSpot();
    //DXSpot(DXSpot *_other);
    DXSpot(const DXSpot& other);

    ~DXSpot();
    void operator=(DXSpot const &_other);
    void clear();

    bool isValid ();

    void setDXCall(const QString &c);
    QString getDxCall ();
    void setSpotter(const QString &c);
    QString getSpotter();

    void setComment(const QString &c);
    QString getComment();

    void setDateTime(const QDateTime &d);
    QDateTime getDateTime();

    void setClickStatus(const MouseClicks &_s );
    MouseClicks getClickStatus();

    void setFrequency(Frequency f);
    Frequency getFrequency();

    void setSHDX(bool _shdx);   // To know if the spot arrived from the dxcluster or was requested with a sh/dx
    bool getSHDX();

signals:

private:
    QString dxcall;
    Frequency freq;
    QString spotter;
    QString comment;
    QDateTime dateTime;
    bool shdx;
    MouseClicks clickStatus;    
};

#endif // KLOG_CLUSTER_DXSPOT_H
