
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQMediaRecorder.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QMediaRecorder>
#include <QChildEvent>
#include <QEvent>
#include <QMediaCaptureSession>
#include <QMediaFormat>
#include <QMediaMetaData>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QUrl>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QMediaRecorder

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QMediaRecorder::staticMetaObject);
}


// QUrl QMediaRecorder::actualLocation()


static void _init_f_actualLocation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_actualLocation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorder *)cls)->actualLocation ());
}


// void QMediaRecorder::addMetaData(const QMediaMetaData &metaData)


static void _init_f_addMetaData_2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QMediaMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addMetaData_2643 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaMetaData &arg1 = gsi::arg_reader<const QMediaMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->addMetaData (arg1);
}


// int QMediaRecorder::audioBitRate()


static void _init_f_audioBitRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_audioBitRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder *)cls)->audioBitRate ());
}


// int QMediaRecorder::audioChannelCount()


static void _init_f_audioChannelCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_audioChannelCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder *)cls)->audioChannelCount ());
}


// int QMediaRecorder::audioSampleRate()


static void _init_f_audioSampleRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_audioSampleRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder *)cls)->audioSampleRate ());
}


// QMediaCaptureSession *QMediaRecorder::captureSession()


static void _init_f_captureSession_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaCaptureSession * > ();
}

static void _call_f_captureSession_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaCaptureSession * > ((QMediaCaptureSession *)((QMediaRecorder *)cls)->captureSession ());
}


// qint64 QMediaRecorder::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QMediaRecorder *)cls)->duration ());
}


// QMediaRecorder::EncodingMode QMediaRecorder::encodingMode()


static void _init_f_encodingMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type > ();
}

static void _call_f_encodingMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type > ((qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::EncodingMode>(((QMediaRecorder *)cls)->encodingMode ()));
}


// QMediaRecorder::Error QMediaRecorder::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Error>::target_type > ((qt_gsi::Converter<QMediaRecorder::Error>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::Error>(((QMediaRecorder *)cls)->error ()));
}


// QString QMediaRecorder::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QMediaRecorder *)cls)->errorString ());
}


// bool QMediaRecorder::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QMediaRecorder *)cls)->isAvailable ());
}


// QMediaFormat QMediaRecorder::mediaFormat()


static void _init_f_mediaFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaFormat > ();
}

static void _call_f_mediaFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaFormat > ((QMediaFormat)((QMediaRecorder *)cls)->mediaFormat ());
}


// QMediaMetaData QMediaRecorder::metaData()


static void _init_f_metaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaMetaData > ();
}

static void _call_f_metaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaMetaData > ((QMediaMetaData)((QMediaRecorder *)cls)->metaData ());
}


// QUrl QMediaRecorder::outputLocation()


static void _init_f_outputLocation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QUrl > ();
}

static void _call_f_outputLocation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QUrl > ((QUrl)((QMediaRecorder *)cls)->outputLocation ());
}


// void QMediaRecorder::pause()


static void _init_f_pause_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_pause_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->pause ();
}


// QMediaRecorder::Quality QMediaRecorder::quality()


static void _init_f_quality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::Quality>::target_type > ();
}

static void _call_f_quality_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::Quality>::target_type > ((qt_gsi::Converter<QMediaRecorder::Quality>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::Quality>(((QMediaRecorder *)cls)->quality ()));
}


// void QMediaRecorder::record()


static void _init_f_record_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_record_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->record ();
}


// QMediaRecorder::RecorderState QMediaRecorder::recorderState()


static void _init_f_recorderState_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type > ();
}

static void _call_f_recorderState_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type > ((qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type)qt_gsi::CppToQtAdaptor<QMediaRecorder::RecorderState>(((QMediaRecorder *)cls)->recorderState ()));
}


// void QMediaRecorder::setAudioBitRate(int bitRate)


static void _init_f_setAudioBitRate_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bitRate");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioBitRate_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setAudioBitRate (arg1);
}


// void QMediaRecorder::setAudioChannelCount(int channels)


static void _init_f_setAudioChannelCount_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("channels");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioChannelCount_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setAudioChannelCount (arg1);
}


// void QMediaRecorder::setAudioSampleRate(int sampleRate)


static void _init_f_setAudioSampleRate_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sampleRate");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAudioSampleRate_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setAudioSampleRate (arg1);
}


// void QMediaRecorder::setEncodingMode(QMediaRecorder::EncodingMode)


static void _init_f_setEncodingMode_3131 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEncodingMode_3131 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::EncodingMode>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setEncodingMode (qt_gsi::QtToCppAdaptor<QMediaRecorder::EncodingMode>(arg1).cref());
}


// void QMediaRecorder::setMediaFormat(const QMediaFormat &format)


static void _init_f_setMediaFormat_2491 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QMediaFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMediaFormat_2491 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaFormat &arg1 = gsi::arg_reader<const QMediaFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setMediaFormat (arg1);
}


// void QMediaRecorder::setMetaData(const QMediaMetaData &metaData)


static void _init_f_setMetaData_2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QMediaMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMetaData_2643 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaMetaData &arg1 = gsi::arg_reader<const QMediaMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setMetaData (arg1);
}


// void QMediaRecorder::setOutputLocation(const QUrl &location)


static void _init_f_setOutputLocation_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOutputLocation_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setOutputLocation (arg1);
}


// void QMediaRecorder::setQuality(QMediaRecorder::Quality quality)


static void _init_f_setQuality_2680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quality");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::Quality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuality_2680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::Quality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::Quality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setQuality (qt_gsi::QtToCppAdaptor<QMediaRecorder::Quality>(arg1).cref());
}


// void QMediaRecorder::setVideoBitRate(int bitRate)


static void _init_f_setVideoBitRate_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("bitRate");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoBitRate_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVideoBitRate (arg1);
}


// void QMediaRecorder::setVideoFrameRate(double frameRate)


static void _init_f_setVideoFrameRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("frameRate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoFrameRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVideoFrameRate (arg1);
}


// void QMediaRecorder::setVideoResolution(const QSize &)


static void _init_f_setVideoResolution_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVideoResolution_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVideoResolution (arg1);
}


// void QMediaRecorder::setVideoResolution(int width, int height)


static void _init_f_setVideoResolution_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setVideoResolution_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->setVideoResolution (arg1, arg2);
}


// void QMediaRecorder::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder *)cls)->stop ();
}


// int QMediaRecorder::videoBitRate()


static void _init_f_videoBitRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_videoBitRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder *)cls)->videoBitRate ());
}


// double QMediaRecorder::videoFrameRate()


static void _init_f_videoFrameRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_videoFrameRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QMediaRecorder *)cls)->videoFrameRate ());
}


// QSize QMediaRecorder::videoResolution()


static void _init_f_videoResolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_videoResolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QMediaRecorder *)cls)->videoResolution ());
}


// static QString QMediaRecorder::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QMediaRecorder::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QMediaRecorder () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":actualLocation", "@brief Method QUrl QMediaRecorder::actualLocation()\n", true, &_init_f_actualLocation_c0, &_call_f_actualLocation_c0);
  methods += new qt_gsi::GenericMethod ("addMetaData", "@brief Method void QMediaRecorder::addMetaData(const QMediaMetaData &metaData)\n", false, &_init_f_addMetaData_2643, &_call_f_addMetaData_2643);
  methods += new qt_gsi::GenericMethod (":audioBitRate", "@brief Method int QMediaRecorder::audioBitRate()\n", true, &_init_f_audioBitRate_c0, &_call_f_audioBitRate_c0);
  methods += new qt_gsi::GenericMethod (":audioChannelCount", "@brief Method int QMediaRecorder::audioChannelCount()\n", true, &_init_f_audioChannelCount_c0, &_call_f_audioChannelCount_c0);
  methods += new qt_gsi::GenericMethod (":audioSampleRate", "@brief Method int QMediaRecorder::audioSampleRate()\n", true, &_init_f_audioSampleRate_c0, &_call_f_audioSampleRate_c0);
  methods += new qt_gsi::GenericMethod ("captureSession", "@brief Method QMediaCaptureSession *QMediaRecorder::captureSession()\n", true, &_init_f_captureSession_c0, &_call_f_captureSession_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method qint64 QMediaRecorder::duration()\n", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod (":encodingMode", "@brief Method QMediaRecorder::EncodingMode QMediaRecorder::encodingMode()\n", true, &_init_f_encodingMode_c0, &_call_f_encodingMode_c0);
  methods += new qt_gsi::GenericMethod (":error", "@brief Method QMediaRecorder::Error QMediaRecorder::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod (":errorString", "@brief Method QString QMediaRecorder::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QMediaRecorder::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod (":mediaFormat", "@brief Method QMediaFormat QMediaRecorder::mediaFormat()\n", true, &_init_f_mediaFormat_c0, &_call_f_mediaFormat_c0);
  methods += new qt_gsi::GenericMethod (":metaData", "@brief Method QMediaMetaData QMediaRecorder::metaData()\n", true, &_init_f_metaData_c0, &_call_f_metaData_c0);
  methods += new qt_gsi::GenericMethod (":outputLocation", "@brief Method QUrl QMediaRecorder::outputLocation()\n", true, &_init_f_outputLocation_c0, &_call_f_outputLocation_c0);
  methods += new qt_gsi::GenericMethod ("pause", "@brief Method void QMediaRecorder::pause()\n", false, &_init_f_pause_0, &_call_f_pause_0);
  methods += new qt_gsi::GenericMethod (":quality", "@brief Method QMediaRecorder::Quality QMediaRecorder::quality()\n", true, &_init_f_quality_c0, &_call_f_quality_c0);
  methods += new qt_gsi::GenericMethod ("record", "@brief Method void QMediaRecorder::record()\n", false, &_init_f_record_0, &_call_f_record_0);
  methods += new qt_gsi::GenericMethod (":recorderState", "@brief Method QMediaRecorder::RecorderState QMediaRecorder::recorderState()\n", true, &_init_f_recorderState_c0, &_call_f_recorderState_c0);
  methods += new qt_gsi::GenericMethod ("setAudioBitRate|audioBitRate=", "@brief Method void QMediaRecorder::setAudioBitRate(int bitRate)\n", false, &_init_f_setAudioBitRate_767, &_call_f_setAudioBitRate_767);
  methods += new qt_gsi::GenericMethod ("setAudioChannelCount|audioChannelCount=", "@brief Method void QMediaRecorder::setAudioChannelCount(int channels)\n", false, &_init_f_setAudioChannelCount_767, &_call_f_setAudioChannelCount_767);
  methods += new qt_gsi::GenericMethod ("setAudioSampleRate|audioSampleRate=", "@brief Method void QMediaRecorder::setAudioSampleRate(int sampleRate)\n", false, &_init_f_setAudioSampleRate_767, &_call_f_setAudioSampleRate_767);
  methods += new qt_gsi::GenericMethod ("setEncodingMode|encodingMode=", "@brief Method void QMediaRecorder::setEncodingMode(QMediaRecorder::EncodingMode)\n", false, &_init_f_setEncodingMode_3131, &_call_f_setEncodingMode_3131);
  methods += new qt_gsi::GenericMethod ("setMediaFormat|mediaFormat=", "@brief Method void QMediaRecorder::setMediaFormat(const QMediaFormat &format)\n", false, &_init_f_setMediaFormat_2491, &_call_f_setMediaFormat_2491);
  methods += new qt_gsi::GenericMethod ("setMetaData|metaData=", "@brief Method void QMediaRecorder::setMetaData(const QMediaMetaData &metaData)\n", false, &_init_f_setMetaData_2643, &_call_f_setMetaData_2643);
  methods += new qt_gsi::GenericMethod ("setOutputLocation|outputLocation=", "@brief Method void QMediaRecorder::setOutputLocation(const QUrl &location)\n", false, &_init_f_setOutputLocation_1701, &_call_f_setOutputLocation_1701);
  methods += new qt_gsi::GenericMethod ("setQuality|quality=", "@brief Method void QMediaRecorder::setQuality(QMediaRecorder::Quality quality)\n", false, &_init_f_setQuality_2680, &_call_f_setQuality_2680);
  methods += new qt_gsi::GenericMethod ("setVideoBitRate|videoBitRate=", "@brief Method void QMediaRecorder::setVideoBitRate(int bitRate)\n", false, &_init_f_setVideoBitRate_767, &_call_f_setVideoBitRate_767);
  methods += new qt_gsi::GenericMethod ("setVideoFrameRate|videoFrameRate=", "@brief Method void QMediaRecorder::setVideoFrameRate(double frameRate)\n", false, &_init_f_setVideoFrameRate_1071, &_call_f_setVideoFrameRate_1071);
  methods += new qt_gsi::GenericMethod ("setVideoResolution|videoResolution=", "@brief Method void QMediaRecorder::setVideoResolution(const QSize &)\n", false, &_init_f_setVideoResolution_1805, &_call_f_setVideoResolution_1805);
  methods += new qt_gsi::GenericMethod ("setVideoResolution", "@brief Method void QMediaRecorder::setVideoResolution(int width, int height)\n", false, &_init_f_setVideoResolution_1426, &_call_f_setVideoResolution_1426);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QMediaRecorder::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod (":videoBitRate", "@brief Method int QMediaRecorder::videoBitRate()\n", true, &_init_f_videoBitRate_c0, &_call_f_videoBitRate_c0);
  methods += new qt_gsi::GenericMethod (":videoFrameRate", "@brief Method double QMediaRecorder::videoFrameRate()\n", true, &_init_f_videoFrameRate_c0, &_call_f_videoFrameRate_c0);
  methods += new qt_gsi::GenericMethod (":videoResolution", "@brief Method QSize QMediaRecorder::videoResolution()\n", true, &_init_f_videoResolution_c0, &_call_f_videoResolution_c0);
  methods += gsi::qt_signal<const QUrl & > ("actualLocationChanged(const QUrl &)", "actualLocationChanged", gsi::arg("location"), "@brief Signal declaration for QMediaRecorder::actualLocationChanged(const QUrl &location)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("audioBitRateChanged()", "audioBitRateChanged", "@brief Signal declaration for QMediaRecorder::audioBitRateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("audioChannelCountChanged()", "audioChannelCountChanged", "@brief Signal declaration for QMediaRecorder::audioChannelCountChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("audioSampleRateChanged()", "audioSampleRateChanged", "@brief Signal declaration for QMediaRecorder::audioSampleRateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QMediaRecorder::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<qint64 > ("durationChanged(qint64)", "durationChanged", gsi::arg("duration"), "@brief Signal declaration for QMediaRecorder::durationChanged(qint64 duration)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("encoderSettingsChanged()", "encoderSettingsChanged", "@brief Signal declaration for QMediaRecorder::encoderSettingsChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("encodingModeChanged()", "encodingModeChanged", "@brief Signal declaration for QMediaRecorder::encodingModeChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("errorChanged()", "errorChanged", "@brief Signal declaration for QMediaRecorder::errorChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaRecorder::Error>::target_type &, const QString & > ("errorOccurred(QMediaRecorder::Error, const QString &)", "errorOccurred", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QMediaRecorder::errorOccurred(QMediaRecorder::Error error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("mediaFormatChanged()", "mediaFormatChanged", "@brief Signal declaration for QMediaRecorder::mediaFormatChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("metaDataChanged()", "metaDataChanged", "@brief Signal declaration for QMediaRecorder::metaDataChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QMediaRecorder::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("qualityChanged()", "qualityChanged", "@brief Signal declaration for QMediaRecorder::qualityChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type & > ("recorderStateChanged(QMediaRecorder::RecorderState)", "recorderStateChanged", gsi::arg("state"), "@brief Signal declaration for QMediaRecorder::recorderStateChanged(QMediaRecorder::RecorderState state)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("videoBitRateChanged()", "videoBitRateChanged", "@brief Signal declaration for QMediaRecorder::videoBitRateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("videoFrameRateChanged()", "videoFrameRateChanged", "@brief Signal declaration for QMediaRecorder::videoFrameRateChanged()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("videoResolutionChanged()", "videoResolutionChanged", "@brief Signal declaration for QMediaRecorder::videoResolutionChanged()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QMediaRecorder::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QMediaRecorder> decl_QMediaRecorder (qtdecl_QObject (), "QtMultimedia", "QMediaRecorder_Native",
  methods_QMediaRecorder (),
  "@hide\n@alias QMediaRecorder");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QMediaRecorder> &qtdecl_QMediaRecorder () { return decl_QMediaRecorder; }

}


class QMediaRecorder_Adaptor : public QMediaRecorder, public qt_gsi::QtObjectBase
{
public:

  virtual ~QMediaRecorder_Adaptor();

  //  [adaptor ctor] QMediaRecorder::QMediaRecorder(QObject *parent)
  QMediaRecorder_Adaptor() : QMediaRecorder()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QMediaRecorder::QMediaRecorder(QObject *parent)
  QMediaRecorder_Adaptor(QObject *parent) : QMediaRecorder(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)
  bool fp_QMediaRecorder_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QMediaRecorder::isSignalConnected(signal);
  }

  //  [expose] int QMediaRecorder::receivers(const char *signal)
  int fp_QMediaRecorder_receivers_c1731 (const char *signal) const {
    return QMediaRecorder::receivers(signal);
  }

  //  [expose] QObject *QMediaRecorder::sender()
  QObject * fp_QMediaRecorder_sender_c0 () const {
    return QMediaRecorder::sender();
  }

  //  [expose] int QMediaRecorder::senderSignalIndex()
  int fp_QMediaRecorder_senderSignalIndex_c0 () const {
    return QMediaRecorder::senderSignalIndex();
  }

  //  [emitter impl] void QMediaRecorder::actualLocationChanged(const QUrl &location)
  void emitter_QMediaRecorder_actualLocationChanged_1701(const QUrl &location)
  {
    emit QMediaRecorder::actualLocationChanged(location);
  }

  //  [emitter impl] void QMediaRecorder::audioBitRateChanged()
  void emitter_QMediaRecorder_audioBitRateChanged_0()
  {
    emit QMediaRecorder::audioBitRateChanged();
  }

  //  [emitter impl] void QMediaRecorder::audioChannelCountChanged()
  void emitter_QMediaRecorder_audioChannelCountChanged_0()
  {
    emit QMediaRecorder::audioChannelCountChanged();
  }

  //  [emitter impl] void QMediaRecorder::audioSampleRateChanged()
  void emitter_QMediaRecorder_audioSampleRateChanged_0()
  {
    emit QMediaRecorder::audioSampleRateChanged();
  }

  //  [emitter impl] void QMediaRecorder::destroyed(QObject *)
  void emitter_QMediaRecorder_destroyed_1302(QObject *arg1)
  {
    emit QMediaRecorder::destroyed(arg1);
  }

  //  [emitter impl] void QMediaRecorder::durationChanged(qint64 duration)
  void emitter_QMediaRecorder_durationChanged_986(qint64 duration)
  {
    emit QMediaRecorder::durationChanged(duration);
  }

  //  [emitter impl] void QMediaRecorder::encoderSettingsChanged()
  void emitter_QMediaRecorder_encoderSettingsChanged_0()
  {
    emit QMediaRecorder::encoderSettingsChanged();
  }

  //  [emitter impl] void QMediaRecorder::encodingModeChanged()
  void emitter_QMediaRecorder_encodingModeChanged_0()
  {
    emit QMediaRecorder::encodingModeChanged();
  }

  //  [emitter impl] void QMediaRecorder::errorChanged()
  void emitter_QMediaRecorder_errorChanged_0()
  {
    emit QMediaRecorder::errorChanged();
  }

  //  [emitter impl] void QMediaRecorder::errorOccurred(QMediaRecorder::Error error, const QString &errorString)
  void emitter_QMediaRecorder_errorOccurred_4374(QMediaRecorder::Error error, const QString &errorString)
  {
    emit QMediaRecorder::errorOccurred(error, errorString);
  }

  //  [adaptor impl] bool QMediaRecorder::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QMediaRecorder::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QMediaRecorder_Adaptor, bool, QEvent *>(&QMediaRecorder_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QMediaRecorder::event(_event);
    }
  }

  //  [adaptor impl] bool QMediaRecorder::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QMediaRecorder::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QMediaRecorder_Adaptor, bool, QObject *, QEvent *>(&QMediaRecorder_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QMediaRecorder::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QMediaRecorder::mediaFormatChanged()
  void emitter_QMediaRecorder_mediaFormatChanged_0()
  {
    emit QMediaRecorder::mediaFormatChanged();
  }

  //  [emitter impl] void QMediaRecorder::metaDataChanged()
  void emitter_QMediaRecorder_metaDataChanged_0()
  {
    emit QMediaRecorder::metaDataChanged();
  }

  //  [emitter impl] void QMediaRecorder::objectNameChanged(const QString &objectName)
  void emitter_QMediaRecorder_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QMediaRecorder::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QMediaRecorder::qualityChanged()
  void emitter_QMediaRecorder_qualityChanged_0()
  {
    emit QMediaRecorder::qualityChanged();
  }

  //  [emitter impl] void QMediaRecorder::recorderStateChanged(QMediaRecorder::RecorderState state)
  void emitter_QMediaRecorder_recorderStateChanged_3270(QMediaRecorder::RecorderState state)
  {
    emit QMediaRecorder::recorderStateChanged(state);
  }

  //  [emitter impl] void QMediaRecorder::videoBitRateChanged()
  void emitter_QMediaRecorder_videoBitRateChanged_0()
  {
    emit QMediaRecorder::videoBitRateChanged();
  }

  //  [emitter impl] void QMediaRecorder::videoFrameRateChanged()
  void emitter_QMediaRecorder_videoFrameRateChanged_0()
  {
    emit QMediaRecorder::videoFrameRateChanged();
  }

  //  [emitter impl] void QMediaRecorder::videoResolutionChanged()
  void emitter_QMediaRecorder_videoResolutionChanged_0()
  {
    emit QMediaRecorder::videoResolutionChanged();
  }

  //  [adaptor impl] void QMediaRecorder::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QMediaRecorder::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QMediaRecorder_Adaptor, QChildEvent *>(&QMediaRecorder_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QMediaRecorder::childEvent(event);
    }
  }

  //  [adaptor impl] void QMediaRecorder::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QMediaRecorder::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QMediaRecorder_Adaptor, QEvent *>(&QMediaRecorder_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QMediaRecorder::customEvent(event);
    }
  }

  //  [adaptor impl] void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QMediaRecorder::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QMediaRecorder_Adaptor, const QMetaMethod &>(&QMediaRecorder_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QMediaRecorder::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QMediaRecorder::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QMediaRecorder::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QMediaRecorder_Adaptor, QTimerEvent *>(&QMediaRecorder_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QMediaRecorder::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QMediaRecorder_Adaptor::~QMediaRecorder_Adaptor() { }

//  Constructor QMediaRecorder::QMediaRecorder(QObject *parent) (adaptor class)

static void _init_ctor_QMediaRecorder_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QMediaRecorder_Adaptor> ();
}

static void _call_ctor_QMediaRecorder_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QMediaRecorder_Adaptor *> (new QMediaRecorder_Adaptor (arg1));
}


// emitter void QMediaRecorder::actualLocationChanged(const QUrl &location)

static void _init_emitter_actualLocationChanged_1701 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location");
  decl->add_arg<const QUrl & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_actualLocationChanged_1701 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QUrl &arg1 = gsi::arg_reader<const QUrl & >() (args, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_actualLocationChanged_1701 (arg1);
}


// emitter void QMediaRecorder::audioBitRateChanged()

static void _init_emitter_audioBitRateChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_audioBitRateChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_audioBitRateChanged_0 ();
}


// emitter void QMediaRecorder::audioChannelCountChanged()

static void _init_emitter_audioChannelCountChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_audioChannelCountChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_audioChannelCountChanged_0 ();
}


// emitter void QMediaRecorder::audioSampleRateChanged()

static void _init_emitter_audioSampleRateChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_audioSampleRateChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_audioSampleRateChanged_0 ();
}


// void QMediaRecorder::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QMediaRecorder::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QMediaRecorder::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_destroyed_1302 (arg1);
}


// void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QMediaRecorder::durationChanged(qint64 duration)

static void _init_emitter_durationChanged_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("duration");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_durationChanged_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_durationChanged_986 (arg1);
}


// emitter void QMediaRecorder::encoderSettingsChanged()

static void _init_emitter_encoderSettingsChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_encoderSettingsChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_encoderSettingsChanged_0 ();
}


// emitter void QMediaRecorder::encodingModeChanged()

static void _init_emitter_encodingModeChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_encodingModeChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_encodingModeChanged_0 ();
}


// emitter void QMediaRecorder::errorChanged()

static void _init_emitter_errorChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_errorChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_errorChanged_0 ();
}


// emitter void QMediaRecorder::errorOccurred(QMediaRecorder::Error error, const QString &errorString)

static void _init_emitter_errorOccurred_4374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::Error>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_errorOccurred_4374 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::Error>::target_type & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_errorOccurred_4374 (arg1, arg2);
}


// bool QMediaRecorder::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QMediaRecorder::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_isSignalConnected_c2394 (arg1));
}


// emitter void QMediaRecorder::mediaFormatChanged()

static void _init_emitter_mediaFormatChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_mediaFormatChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_mediaFormatChanged_0 ();
}


// emitter void QMediaRecorder::metaDataChanged()

static void _init_emitter_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_metaDataChanged_0 ();
}


// emitter void QMediaRecorder::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_objectNameChanged_4567 (arg1);
}


// emitter void QMediaRecorder::qualityChanged()

static void _init_emitter_qualityChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_qualityChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_qualityChanged_0 ();
}


// exposed int QMediaRecorder::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_receivers_c1731 (arg1));
}


// emitter void QMediaRecorder::recorderStateChanged(QMediaRecorder::RecorderState state)

static void _init_emitter_recorderStateChanged_3270 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_recorderStateChanged_3270 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QMediaRecorder::RecorderState>::target_type & >() (args, heap);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_recorderStateChanged_3270 (arg1);
}


// exposed QObject *QMediaRecorder::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_sender_c0 ());
}


// exposed int QMediaRecorder::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QMediaRecorder_Adaptor *)cls)->fp_QMediaRecorder_senderSignalIndex_c0 ());
}


// void QMediaRecorder::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QMediaRecorder_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QMediaRecorder_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// emitter void QMediaRecorder::videoBitRateChanged()

static void _init_emitter_videoBitRateChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_videoBitRateChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_videoBitRateChanged_0 ();
}


// emitter void QMediaRecorder::videoFrameRateChanged()

static void _init_emitter_videoFrameRateChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_videoFrameRateChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_videoFrameRateChanged_0 ();
}


// emitter void QMediaRecorder::videoResolutionChanged()

static void _init_emitter_videoResolutionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_videoResolutionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QMediaRecorder_Adaptor *)cls)->emitter_QMediaRecorder_videoResolutionChanged_0 ();
}


namespace gsi
{

gsi::Class<QMediaRecorder> &qtdecl_QMediaRecorder ();

static gsi::Methods methods_QMediaRecorder_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QMediaRecorder::QMediaRecorder(QObject *parent)\nThis method creates an object of class QMediaRecorder.", &_init_ctor_QMediaRecorder_Adaptor_1302, &_call_ctor_QMediaRecorder_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("emit_actualLocationChanged", "@brief Emitter for signal void QMediaRecorder::actualLocationChanged(const QUrl &location)\nCall this method to emit this signal.", false, &_init_emitter_actualLocationChanged_1701, &_call_emitter_actualLocationChanged_1701);
  methods += new qt_gsi::GenericMethod ("emit_audioBitRateChanged", "@brief Emitter for signal void QMediaRecorder::audioBitRateChanged()\nCall this method to emit this signal.", false, &_init_emitter_audioBitRateChanged_0, &_call_emitter_audioBitRateChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_audioChannelCountChanged", "@brief Emitter for signal void QMediaRecorder::audioChannelCountChanged()\nCall this method to emit this signal.", false, &_init_emitter_audioChannelCountChanged_0, &_call_emitter_audioChannelCountChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_audioSampleRateChanged", "@brief Emitter for signal void QMediaRecorder::audioSampleRateChanged()\nCall this method to emit this signal.", false, &_init_emitter_audioSampleRateChanged_0, &_call_emitter_audioSampleRateChanged_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QMediaRecorder::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QMediaRecorder::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QMediaRecorder::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QMediaRecorder::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_durationChanged", "@brief Emitter for signal void QMediaRecorder::durationChanged(qint64 duration)\nCall this method to emit this signal.", false, &_init_emitter_durationChanged_986, &_call_emitter_durationChanged_986);
  methods += new qt_gsi::GenericMethod ("emit_encoderSettingsChanged", "@brief Emitter for signal void QMediaRecorder::encoderSettingsChanged()\nCall this method to emit this signal.", false, &_init_emitter_encoderSettingsChanged_0, &_call_emitter_encoderSettingsChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_encodingModeChanged", "@brief Emitter for signal void QMediaRecorder::encodingModeChanged()\nCall this method to emit this signal.", false, &_init_emitter_encodingModeChanged_0, &_call_emitter_encodingModeChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_errorChanged", "@brief Emitter for signal void QMediaRecorder::errorChanged()\nCall this method to emit this signal.", false, &_init_emitter_errorChanged_0, &_call_emitter_errorChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_errorOccurred", "@brief Emitter for signal void QMediaRecorder::errorOccurred(QMediaRecorder::Error error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_errorOccurred_4374, &_call_emitter_errorOccurred_4374);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QMediaRecorder::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QMediaRecorder::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QMediaRecorder::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_mediaFormatChanged", "@brief Emitter for signal void QMediaRecorder::mediaFormatChanged()\nCall this method to emit this signal.", false, &_init_emitter_mediaFormatChanged_0, &_call_emitter_mediaFormatChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_metaDataChanged", "@brief Emitter for signal void QMediaRecorder::metaDataChanged()\nCall this method to emit this signal.", false, &_init_emitter_metaDataChanged_0, &_call_emitter_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QMediaRecorder::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("emit_qualityChanged", "@brief Emitter for signal void QMediaRecorder::qualityChanged()\nCall this method to emit this signal.", false, &_init_emitter_qualityChanged_0, &_call_emitter_qualityChanged_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QMediaRecorder::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("emit_recorderStateChanged", "@brief Emitter for signal void QMediaRecorder::recorderStateChanged(QMediaRecorder::RecorderState state)\nCall this method to emit this signal.", false, &_init_emitter_recorderStateChanged_3270, &_call_emitter_recorderStateChanged_3270);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QMediaRecorder::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QMediaRecorder::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QMediaRecorder::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("emit_videoBitRateChanged", "@brief Emitter for signal void QMediaRecorder::videoBitRateChanged()\nCall this method to emit this signal.", false, &_init_emitter_videoBitRateChanged_0, &_call_emitter_videoBitRateChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_videoFrameRateChanged", "@brief Emitter for signal void QMediaRecorder::videoFrameRateChanged()\nCall this method to emit this signal.", false, &_init_emitter_videoFrameRateChanged_0, &_call_emitter_videoFrameRateChanged_0);
  methods += new qt_gsi::GenericMethod ("emit_videoResolutionChanged", "@brief Emitter for signal void QMediaRecorder::videoResolutionChanged()\nCall this method to emit this signal.", false, &_init_emitter_videoResolutionChanged_0, &_call_emitter_videoResolutionChanged_0);
  return methods;
}

gsi::Class<QMediaRecorder_Adaptor> decl_QMediaRecorder_Adaptor (qtdecl_QMediaRecorder (), "QtMultimedia", "QMediaRecorder",
  methods_QMediaRecorder_Adaptor (),
  "@qt\n@brief Binding of QMediaRecorder");

}


//  Implementation of the enum wrapper class for QMediaRecorder::EncodingMode
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::EncodingMode> decl_QMediaRecorder_EncodingMode_Enum ("QtMultimedia", "QMediaRecorder_EncodingMode",
    gsi::enum_const ("ConstantQualityEncoding", QMediaRecorder::ConstantQualityEncoding, "@brief Enum constant QMediaRecorder::ConstantQualityEncoding") +
    gsi::enum_const ("ConstantBitRateEncoding", QMediaRecorder::ConstantBitRateEncoding, "@brief Enum constant QMediaRecorder::ConstantBitRateEncoding") +
    gsi::enum_const ("AverageBitRateEncoding", QMediaRecorder::AverageBitRateEncoding, "@brief Enum constant QMediaRecorder::AverageBitRateEncoding") +
    gsi::enum_const ("TwoPassEncoding", QMediaRecorder::TwoPassEncoding, "@brief Enum constant QMediaRecorder::TwoPassEncoding"),
  "@qt\n@brief This class represents the QMediaRecorder::EncodingMode enum");

static gsi::QFlagsClass<QMediaRecorder::EncodingMode > decl_QMediaRecorder_EncodingMode_Enums ("QtMultimedia", "QMediaRecorder_QFlags_EncodingMode",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::EncodingMode> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_EncodingMode_Enum_in_parent (decl_QMediaRecorder_EncodingMode_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_EncodingMode_Enum_as_child (decl_QMediaRecorder_EncodingMode_Enum, "EncodingMode");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_EncodingMode_Enums_as_child (decl_QMediaRecorder_EncodingMode_Enums, "QFlags_EncodingMode");

}


//  Implementation of the enum wrapper class for QMediaRecorder::Error
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::Error> decl_QMediaRecorder_Error_Enum ("QtMultimedia", "QMediaRecorder_Error",
    gsi::enum_const ("NoError", QMediaRecorder::NoError, "@brief Enum constant QMediaRecorder::NoError") +
    gsi::enum_const ("ResourceError", QMediaRecorder::ResourceError, "@brief Enum constant QMediaRecorder::ResourceError") +
    gsi::enum_const ("FormatError", QMediaRecorder::FormatError, "@brief Enum constant QMediaRecorder::FormatError") +
    gsi::enum_const ("OutOfSpaceError", QMediaRecorder::OutOfSpaceError, "@brief Enum constant QMediaRecorder::OutOfSpaceError") +
    gsi::enum_const ("LocationNotWritable", QMediaRecorder::LocationNotWritable, "@brief Enum constant QMediaRecorder::LocationNotWritable"),
  "@qt\n@brief This class represents the QMediaRecorder::Error enum");

static gsi::QFlagsClass<QMediaRecorder::Error > decl_QMediaRecorder_Error_Enums ("QtMultimedia", "QMediaRecorder_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_Error_Enum_in_parent (decl_QMediaRecorder_Error_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Error_Enum_as_child (decl_QMediaRecorder_Error_Enum, "Error");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Error_Enums_as_child (decl_QMediaRecorder_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QMediaRecorder::Quality
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::Quality> decl_QMediaRecorder_Quality_Enum ("QtMultimedia", "QMediaRecorder_Quality",
    gsi::enum_const ("VeryLowQuality", QMediaRecorder::VeryLowQuality, "@brief Enum constant QMediaRecorder::VeryLowQuality") +
    gsi::enum_const ("LowQuality", QMediaRecorder::LowQuality, "@brief Enum constant QMediaRecorder::LowQuality") +
    gsi::enum_const ("NormalQuality", QMediaRecorder::NormalQuality, "@brief Enum constant QMediaRecorder::NormalQuality") +
    gsi::enum_const ("HighQuality", QMediaRecorder::HighQuality, "@brief Enum constant QMediaRecorder::HighQuality") +
    gsi::enum_const ("VeryHighQuality", QMediaRecorder::VeryHighQuality, "@brief Enum constant QMediaRecorder::VeryHighQuality"),
  "@qt\n@brief This class represents the QMediaRecorder::Quality enum");

static gsi::QFlagsClass<QMediaRecorder::Quality > decl_QMediaRecorder_Quality_Enums ("QtMultimedia", "QMediaRecorder_QFlags_Quality",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::Quality> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_Quality_Enum_in_parent (decl_QMediaRecorder_Quality_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Quality_Enum_as_child (decl_QMediaRecorder_Quality_Enum, "Quality");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_Quality_Enums_as_child (decl_QMediaRecorder_Quality_Enums, "QFlags_Quality");

}


//  Implementation of the enum wrapper class for QMediaRecorder::RecorderState
namespace qt_gsi
{

static gsi::Enum<QMediaRecorder::RecorderState> decl_QMediaRecorder_RecorderState_Enum ("QtMultimedia", "QMediaRecorder_RecorderState",
    gsi::enum_const ("StoppedState", QMediaRecorder::StoppedState, "@brief Enum constant QMediaRecorder::StoppedState") +
    gsi::enum_const ("RecordingState", QMediaRecorder::RecordingState, "@brief Enum constant QMediaRecorder::RecordingState") +
    gsi::enum_const ("PausedState", QMediaRecorder::PausedState, "@brief Enum constant QMediaRecorder::PausedState"),
  "@qt\n@brief This class represents the QMediaRecorder::RecorderState enum");

static gsi::QFlagsClass<QMediaRecorder::RecorderState > decl_QMediaRecorder_RecorderState_Enums ("QtMultimedia", "QMediaRecorder_QFlags_RecorderState",
  "@qt\n@brief This class represents the QFlags<QMediaRecorder::RecorderState> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QMediaRecorder> inject_QMediaRecorder_RecorderState_Enum_in_parent (decl_QMediaRecorder_RecorderState_Enum.defs ());
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_RecorderState_Enum_as_child (decl_QMediaRecorder_RecorderState_Enum, "RecorderState");
static gsi::ClassExt<QMediaRecorder> decl_QMediaRecorder_RecorderState_Enums_as_child (decl_QMediaRecorder_RecorderState_Enums, "QFlags_RecorderState");

}

