
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLocalServer.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QLocalServer>
#include <QChildEvent>
#include <QEvent>
#include <QLocalSocket>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtNetworkCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLocalServer

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QLocalServer::staticMetaObject);
}


// void QLocalServer::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer *)cls)->close ();
}


// QString QLocalServer::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocalServer *)cls)->errorString ());
}


// QString QLocalServer::fullServerName()


static void _init_f_fullServerName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fullServerName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocalServer *)cls)->fullServerName ());
}


// bool QLocalServer::hasPendingConnections()


static void _init_f_hasPendingConnections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingConnections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLocalServer *)cls)->hasPendingConnections ());
}


// bool QLocalServer::isListening()


static void _init_f_isListening_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isListening_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLocalServer *)cls)->isListening ());
}


// bool QLocalServer::listen(const QString &name)


static void _init_f_listen_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_listen_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)((QLocalServer *)cls)->listen (arg1));
}


// int QLocalServer::maxPendingConnections()


static void _init_f_maxPendingConnections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_maxPendingConnections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QLocalServer *)cls)->maxPendingConnections ());
}


// QLocalSocket *QLocalServer::nextPendingConnection()


static void _init_f_nextPendingConnection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocalSocket * > ();
}

static void _call_f_nextPendingConnection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocalSocket * > ((QLocalSocket *)((QLocalServer *)cls)->nextPendingConnection ());
}


// QAbstractSocket::SocketError QLocalServer::serverError()


static void _init_f_serverError_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ();
}

static void _call_f_serverError_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAbstractSocket::SocketError>::target_type > ((qt_gsi::Converter<QAbstractSocket::SocketError>::target_type)qt_gsi::CppToQtAdaptor<QAbstractSocket::SocketError>(((QLocalServer *)cls)->serverError ()));
}


// QString QLocalServer::serverName()


static void _init_f_serverName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_serverName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QLocalServer *)cls)->serverName ());
}


// void QLocalServer::setMaxPendingConnections(int numConnections)


static void _init_f_setMaxPendingConnections_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("numConnections");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaxPendingConnections_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer *)cls)->setMaxPendingConnections (arg1);
}


// bool QLocalServer::waitForNewConnection(int msec, bool *timedOut)


static void _init_f_waitForNewConnection_1709 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msec", true, "0");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timedOut", true, "0");
  decl->add_arg<bool * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_waitForNewConnection_1709 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  bool *arg2 = args ? gsi::arg_reader<bool * >() (args, heap) : gsi::arg_maker<bool * >() (0, heap);
  ret.write<bool > ((bool)((QLocalServer *)cls)->waitForNewConnection (arg1, arg2));
}


// static bool QLocalServer::removeServer(const QString &name)


static void _init_f_removeServer_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_removeServer_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<bool > ((bool)QLocalServer::removeServer (arg1));
}


// static QString QLocalServer::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QLocalServer::tr (arg1, arg2));
}


// static QString QLocalServer::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QLocalServer::tr (arg1, arg2, arg3));
}


// static QString QLocalServer::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (0, heap);
  ret.write<QString > ((QString)QLocalServer::trUtf8 (arg1, arg2));
}


// static QString QLocalServer::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = gsi::arg_reader<const char * >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QString > ((QString)QLocalServer::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QLocalServer () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("close", "@brief Method void QLocalServer::close()\n", false, &_init_f_close_0, &_call_f_close_0);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QLocalServer::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("fullServerName", "@brief Method QString QLocalServer::fullServerName()\n", true, &_init_f_fullServerName_c0, &_call_f_fullServerName_c0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@brief Method bool QLocalServer::hasPendingConnections()\n", true, &_init_f_hasPendingConnections_c0, &_call_f_hasPendingConnections_c0);
  methods += new qt_gsi::GenericMethod ("isListening?", "@brief Method bool QLocalServer::isListening()\n", true, &_init_f_isListening_c0, &_call_f_isListening_c0);
  methods += new qt_gsi::GenericMethod ("listen", "@brief Method bool QLocalServer::listen(const QString &name)\n", false, &_init_f_listen_2025, &_call_f_listen_2025);
  methods += new qt_gsi::GenericMethod (":maxPendingConnections", "@brief Method int QLocalServer::maxPendingConnections()\n", true, &_init_f_maxPendingConnections_c0, &_call_f_maxPendingConnections_c0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@brief Method QLocalSocket *QLocalServer::nextPendingConnection()\n", false, &_init_f_nextPendingConnection_0, &_call_f_nextPendingConnection_0);
  methods += new qt_gsi::GenericMethod ("serverError", "@brief Method QAbstractSocket::SocketError QLocalServer::serverError()\n", true, &_init_f_serverError_c0, &_call_f_serverError_c0);
  methods += new qt_gsi::GenericMethod ("serverName", "@brief Method QString QLocalServer::serverName()\n", true, &_init_f_serverName_c0, &_call_f_serverName_c0);
  methods += new qt_gsi::GenericMethod ("setMaxPendingConnections|maxPendingConnections=", "@brief Method void QLocalServer::setMaxPendingConnections(int numConnections)\n", false, &_init_f_setMaxPendingConnections_767, &_call_f_setMaxPendingConnections_767);
  methods += new qt_gsi::GenericMethod ("waitForNewConnection", "@brief Method bool QLocalServer::waitForNewConnection(int msec, bool *timedOut)\n", false, &_init_f_waitForNewConnection_1709, &_call_f_waitForNewConnection_1709);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QLocalServer::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("newConnection()", "newConnection", "@brief Signal declaration for QLocalServer::newConnection()\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("removeServer", "@brief Static method bool QLocalServer::removeServer(const QString &name)\nThis method is static and can be called without an instance.", &_init_f_removeServer_2025, &_call_f_removeServer_2025);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLocalServer::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLocalServer::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLocalServer::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLocalServer::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QLocalServer> decl_QLocalServer (qtdecl_QObject (), "QtNetwork", "QLocalServer_Native",
  methods_QLocalServer (),
  "@hide\n@alias QLocalServer");

GSI_QTNETWORK_PUBLIC gsi::Class<QLocalServer> &qtdecl_QLocalServer () { return decl_QLocalServer; }

}


class QLocalServer_Adaptor : public QLocalServer, public qt_gsi::QtObjectBase
{
public:

  virtual ~QLocalServer_Adaptor();

  //  [adaptor ctor] QLocalServer::QLocalServer(QObject *parent)
  QLocalServer_Adaptor() : QLocalServer()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLocalServer::QLocalServer(QObject *parent)
  QLocalServer_Adaptor(QObject *parent) : QLocalServer(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] int QLocalServer::receivers(const char *signal)
  int fp_QLocalServer_receivers_c1731 (const char *signal) const {
    return QLocalServer::receivers(signal);
  }

  //  [expose] QObject *QLocalServer::sender()
  QObject * fp_QLocalServer_sender_c0 () const {
    return QLocalServer::sender();
  }

  //  [adaptor impl] bool QLocalServer::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QLocalServer::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QLocalServer_Adaptor, bool, QEvent *>(&QLocalServer_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QLocalServer::event(arg1);
    }
  }

  //  [adaptor impl] bool QLocalServer::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QLocalServer::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QLocalServer_Adaptor, bool, QObject *, QEvent *>(&QLocalServer_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QLocalServer::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QLocalServer::hasPendingConnections()
  bool cbs_hasPendingConnections_c0_0() const
  {
    return QLocalServer::hasPendingConnections();
  }

  virtual bool hasPendingConnections() const
  {
    if (cb_hasPendingConnections_c0_0.can_issue()) {
      return cb_hasPendingConnections_c0_0.issue<QLocalServer_Adaptor, bool>(&QLocalServer_Adaptor::cbs_hasPendingConnections_c0_0);
    } else {
      return QLocalServer::hasPendingConnections();
    }
  }

  //  [adaptor impl] QLocalSocket *QLocalServer::nextPendingConnection()
  QLocalSocket * cbs_nextPendingConnection_0_0()
  {
    return QLocalServer::nextPendingConnection();
  }

  virtual QLocalSocket * nextPendingConnection()
  {
    if (cb_nextPendingConnection_0_0.can_issue()) {
      return cb_nextPendingConnection_0_0.issue<QLocalServer_Adaptor, QLocalSocket *>(&QLocalServer_Adaptor::cbs_nextPendingConnection_0_0);
    } else {
      return QLocalServer::nextPendingConnection();
    }
  }

  //  [adaptor impl] void QLocalServer::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QLocalServer::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QLocalServer_Adaptor, QChildEvent *>(&QLocalServer_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QLocalServer::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QLocalServer::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QLocalServer::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QLocalServer_Adaptor, QEvent *>(&QLocalServer_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QLocalServer::customEvent(arg1);
    }
  }

  //  [emitter impl] void QLocalServer::destroyed(QObject *)
  void emitter_QLocalServer_destroyed_1302(QObject *arg1)
  {
    emit QLocalServer::destroyed(arg1);
  }

  //  [adaptor impl] void QLocalServer::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QLocalServer::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QLocalServer_Adaptor, const char *>(&QLocalServer_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QLocalServer::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QLocalServer::incomingConnection(quintptr socketDescriptor)
  void cbs_incomingConnection_1339_0(quintptr socketDescriptor)
  {
    QLocalServer::incomingConnection(socketDescriptor);
  }

  virtual void incomingConnection(quintptr socketDescriptor)
  {
    if (cb_incomingConnection_1339_0.can_issue()) {
      cb_incomingConnection_1339_0.issue<QLocalServer_Adaptor, quintptr>(&QLocalServer_Adaptor::cbs_incomingConnection_1339_0, socketDescriptor);
    } else {
      QLocalServer::incomingConnection(socketDescriptor);
    }
  }

  //  [emitter impl] void QLocalServer::newConnection()
  void emitter_QLocalServer_newConnection_0()
  {
    emit QLocalServer::newConnection();
  }

  //  [adaptor impl] void QLocalServer::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QLocalServer::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QLocalServer_Adaptor, QTimerEvent *>(&QLocalServer_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QLocalServer::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_hasPendingConnections_c0_0;
  gsi::Callback cb_nextPendingConnection_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_incomingConnection_1339_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QLocalServer_Adaptor::~QLocalServer_Adaptor() { }

//  Constructor QLocalServer::QLocalServer(QObject *parent) (adaptor class)

static void _init_ctor_QLocalServer_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QLocalServer_Adaptor> ();
}

static void _call_ctor_QLocalServer_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ret.write<QLocalServer_Adaptor *> (new QLocalServer_Adaptor (arg1));
}


// void QLocalServer::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QLocalServer::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QLocalServer::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QLocalServer_Adaptor *)cls)->emitter_QLocalServer_destroyed_1302 (arg1);
}


// void QLocalServer::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = args.read<const char * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}


// bool QLocalServer::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QLocalServer_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QLocalServer::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QLocalServer_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QLocalServer::hasPendingConnections()

static void _init_cbs_hasPendingConnections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasPendingConnections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QLocalServer_Adaptor *)cls)->cbs_hasPendingConnections_c0_0 ());
}

static void _set_callback_cbs_hasPendingConnections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_hasPendingConnections_c0_0 = cb;
}


// void QLocalServer::incomingConnection(quintptr socketDescriptor)

static void _init_cbs_incomingConnection_1339_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("socketDescriptor");
  decl->add_arg<quintptr > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_incomingConnection_1339_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  quintptr arg1 = args.read<quintptr > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer_Adaptor *)cls)->cbs_incomingConnection_1339_0 (arg1);
}

static void _set_callback_cbs_incomingConnection_1339_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_incomingConnection_1339_0 = cb;
}


// emitter void QLocalServer::newConnection()

static void _init_emitter_newConnection_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_newConnection_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QLocalServer_Adaptor *)cls)->emitter_QLocalServer_newConnection_0 ();
}


// QLocalSocket *QLocalServer::nextPendingConnection()

static void _init_cbs_nextPendingConnection_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLocalSocket * > ();
}

static void _call_cbs_nextPendingConnection_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLocalSocket * > ((QLocalSocket *)((QLocalServer_Adaptor *)cls)->cbs_nextPendingConnection_0_0 ());
}

static void _set_callback_cbs_nextPendingConnection_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_nextPendingConnection_0_0 = cb;
}


// exposed int QLocalServer::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QLocalServer_Adaptor *)cls)->fp_QLocalServer_receivers_c1731 (arg1));
}


// exposed QObject *QLocalServer::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QLocalServer_Adaptor *)cls)->fp_QLocalServer_sender_c0 ());
}


// void QLocalServer::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QLocalServer_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QLocalServer_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QLocalServer> &qtdecl_QLocalServer ();

static gsi::Methods methods_QLocalServer_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLocalServer::QLocalServer(QObject *parent)\nThis method creates an object of class QLocalServer.", &_init_ctor_QLocalServer_Adaptor_1302, &_call_ctor_QLocalServer_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QLocalServer::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QLocalServer::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QLocalServer::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QLocalServer::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QLocalServer::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QLocalServer::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@brief Virtual method bool QLocalServer::hasPendingConnections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasPendingConnections_c0_0, &_call_cbs_hasPendingConnections_c0_0);
  methods += new qt_gsi::GenericMethod ("hasPendingConnections", "@hide", true, &_init_cbs_hasPendingConnections_c0_0, &_call_cbs_hasPendingConnections_c0_0, &_set_callback_cbs_hasPendingConnections_c0_0);
  methods += new qt_gsi::GenericMethod ("*incomingConnection", "@brief Virtual method void QLocalServer::incomingConnection(quintptr socketDescriptor)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_incomingConnection_1339_0, &_call_cbs_incomingConnection_1339_0);
  methods += new qt_gsi::GenericMethod ("*incomingConnection", "@hide", false, &_init_cbs_incomingConnection_1339_0, &_call_cbs_incomingConnection_1339_0, &_set_callback_cbs_incomingConnection_1339_0);
  methods += new qt_gsi::GenericMethod ("emit_newConnection", "@brief Emitter for signal void QLocalServer::newConnection()\nCall this method to emit this signal.", false, &_init_emitter_newConnection_0, &_call_emitter_newConnection_0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@brief Virtual method QLocalSocket *QLocalServer::nextPendingConnection()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_nextPendingConnection_0_0, &_call_cbs_nextPendingConnection_0_0);
  methods += new qt_gsi::GenericMethod ("nextPendingConnection", "@hide", false, &_init_cbs_nextPendingConnection_0_0, &_call_cbs_nextPendingConnection_0_0, &_set_callback_cbs_nextPendingConnection_0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QLocalServer::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QLocalServer::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QLocalServer::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QLocalServer_Adaptor> decl_QLocalServer_Adaptor (qtdecl_QLocalServer (), "QtNetwork", "QLocalServer",
  methods_QLocalServer_Adaptor (),
  "@qt\n@brief Binding of QLocalServer");

}

