#ifndef PCBNEW_ID_H_
#define PCBNEW_ID_H_

#include <id.h>

/**
 * Command IDs for the printed circuit board editor.
 *
 * Please add IDs that are unique to the printed circuit board editor (Pcbnew)
 * here and not in the global id.h file.  This will prevent the entire project
 * from being rebuilt when adding new commands to the Pcbnew.
 */

enum pcbnew_ids
{
    ID_MAIN_MENUBAR = ID_END_LIST,
    ID_COPY_BOARD_AS,
    ID_REVERT_BOARD,
    ID_IMPORT_NON_KICAD_BOARD,

    // Tracks and vias sizes general options
    ID_AUX_TOOLBAR_PCB_VIA_SIZE,
    ID_AUX_TOOLBAR_PCB_TRACK_WIDTH,
    ID_AUX_TOOLBAR_PCB_SELECT_AUTO_WIDTH,
    ID_POPUP_PCB_SELECT_WIDTH_START_RANGE,
    ID_POPUP_PCB_SELECT_CUSTOM_WIDTH,
    ID_POPUP_PCB_SELECT_AUTO_WIDTH,
    ID_POPUP_PCB_SELECT_USE_NETCLASS_VALUES,
    ID_POPUP_PCB_SELECT_WIDTH1,
    ID_POPUP_PCB_SELECT_WIDTH2,
    ID_POPUP_PCB_SELECT_WIDTH3,
    ID_POPUP_PCB_SELECT_WIDTH4,
    ID_POPUP_PCB_SELECT_WIDTH5,
    ID_POPUP_PCB_SELECT_WIDTH6,
    ID_POPUP_PCB_SELECT_WIDTH7,
    ID_POPUP_PCB_SELECT_WIDTH8,
    ID_POPUP_PCB_SELECT_WIDTH9,
    ID_POPUP_PCB_SELECT_WIDTH10,
    ID_POPUP_PCB_SELECT_WIDTH11,
    ID_POPUP_PCB_SELECT_WIDTH12,
    ID_POPUP_PCB_SELECT_WIDTH13,
    ID_POPUP_PCB_SELECT_WIDTH14,
    ID_POPUP_PCB_SELECT_WIDTH15,
    ID_POPUP_PCB_SELECT_WIDTH16,
    ID_POPUP_PCB_SELECT_VIASIZE1,
    ID_POPUP_PCB_SELECT_VIASIZE2,
    ID_POPUP_PCB_SELECT_VIASIZE3,
    ID_POPUP_PCB_SELECT_VIASIZE4,
    ID_POPUP_PCB_SELECT_VIASIZE5,
    ID_POPUP_PCB_SELECT_VIASIZE6,
    ID_POPUP_PCB_SELECT_VIASIZE7,
    ID_POPUP_PCB_SELECT_VIASIZE8,
    ID_POPUP_PCB_SELECT_VIASIZE9,
    ID_POPUP_PCB_SELECT_VIASIZE10,
    ID_POPUP_PCB_SELECT_VIASIZE11,
    ID_POPUP_PCB_SELECT_VIASIZE12,
    ID_POPUP_PCB_SELECT_VIASIZE13,
    ID_POPUP_PCB_SELECT_VIASIZE14,
    ID_POPUP_PCB_SELECT_VIASIZE15,
    ID_POPUP_PCB_SELECT_VIASIZE16,
    ID_POPUP_PCB_SELECT_CUSTOM_DIFFPAIR,
    ID_POPUP_PCB_SELECT_USE_NETCLASS_DIFFPAIR,
    ID_POPUP_PCB_SELECT_DIFFPAIR1,
    ID_POPUP_PCB_SELECT_DIFFPAIR2,
    ID_POPUP_PCB_SELECT_DIFFPAIR3,
    ID_POPUP_PCB_SELECT_DIFFPAIR4,
    ID_POPUP_PCB_SELECT_DIFFPAIR5,
    ID_POPUP_PCB_SELECT_DIFFPAIR6,
    ID_POPUP_PCB_SELECT_DIFFPAIR7,
    ID_POPUP_PCB_SELECT_DIFFPAIR8,
    ID_POPUP_PCB_SELECT_DIFFPAIR9,
    ID_POPUP_PCB_SELECT_DIFFPAIR10,
    ID_POPUP_PCB_SELECT_DIFFPAIR11,
    ID_POPUP_PCB_SELECT_DIFFPAIR12,
    ID_POPUP_PCB_SELECT_DIFFPAIR13,
    ID_POPUP_PCB_SELECT_DIFFPAIR14,
    ID_POPUP_PCB_SELECT_DIFFPAIR15,
    ID_POPUP_PCB_SELECT_DIFFPAIR16,
    ID_POPUP_PCB_SELECT_WIDTH_END_RANGE,

    ID_MENU_RECOVER_BOARD_AUTOSAVE,
    ID_MENU_EXPORT_FOOTPRINTS_TO_LIBRARY,
    ID_MENU_EXPORT_FOOTPRINTS_TO_NEW_LIBRARY,

    ID_GEN_EXPORT_FILE_IDF3,
    ID_GEN_EXPORT_FILE_VRML,
    ID_GEN_EXPORT_FILE_STEP,
    ID_GEN_EXPORT_FILE_HYPERLYNX,
    ID_GEN_EXPORT_FILE_GENCADFORMAT,

    ID_TOOLBARH_PCB_ACTION_PLUGIN,

    ID_PCB_GEN_CMP_FILE,
    ID_PCB_GEN_BOM_FILE_FROM_BOARD,

    ID_TOOLBARH_PCB_SELECT_LAYER,

    ID_FPEDIT_SAVE_PNG,

    ID_MODVIEW_LIB_FILTER,
    ID_MODVIEW_LIB_LIST,
    ID_MODVIEW_FOOTPRINT_FILTER,
    ID_MODVIEW_FOOTPRINT_LIST,
    ID_MODVIEW_PREVIOUS,
    ID_MODVIEW_NEXT,
    ID_FPVIEWER_AUTOZOOM_TOOL,

    ID_FOOTPRINT_WIZARD_NEXT,
    ID_FOOTPRINT_WIZARD_PREVIOUS,
    ID_FOOTPRINT_WIZARD_DONE,
    ID_FOOTPRINT_WIZARD_PAGE_LIST,
    ID_FOOTPRINT_WIZARD_PARAMETER_LIST,
    ID_FOOTPRINT_WIZARD_SELECT_WIZARD,
    ID_FOOTPRINT_WIZARD_RESET_TO_DEFAULT,

    ID_ADD_FOOTPRINT_TO_BOARD,
    ID_LOAD_FOOTPRINT_FROM_BOARD,

    ID_RUN_TEARDROP_TOOL,
    ID_REMOVE_TEARDROP_TOOL,
    ID_PCB_UNUSED1,

    ID_PCBNEW_END_LIST
};

#endif  // PCBNEW_ID_H_
