#ifndef _THREAD_H // -*-C++-*-
#define _THREAD_H

#include <pthread.h>
#include <Heap.h>

class ThreadData : public gc
{
public:
    pthread_t t_id;
};

class ThreadStartup : public gc
{
public:
    Value* fn;
    Value* arg;
};

class ThreadMutex : public gc
{
public:
    pthread_mutex_t m_id;
};

extern "C" {
    void* createThread(Value* fn,Value* arg);
    void* createThreadNullary(Value* fn);
    void endThread();
    Value* waitForThread(void* tid);
    void killThread(void* tid);

    void* createMutex();
    void lock(void* mutex);
    void unlock(void* mutex);
}

#endif
