//
//  ========================================================================
//  Copyright (c) 1995-2019 Mort Bay Consulting Pty. Ltd.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.websocket.common.io.payload;

import java.nio.ByteBuffer;

import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.extensions.Frame;

/**
 * Process the payload (for demasking, validating, etc..)
 */
public interface PayloadProcessor
{
    /**
     * Used to process payloads for in the spec.
     * 
     * @param payload
     *            the payload to process
     * @throws BadPayloadException
     *             the exception when the payload fails to validate properly
     */
    public void process(ByteBuffer payload);

    public void reset(Frame frame);
}
