#ifndef IMV_KEYBOARD_H
#define IMV_KEYBOARD_H

#include <stdbool.h>
#include <unistd.h>

struct imv_keyboard;

/* Create a keyboard instance */
struct imv_keyboard *imv_keyboard_create(void);

/* Clean up a keyboard */
void imv_keyboard_free(struct imv_keyboard *keyboard);

/* Notify the keyboard of the state of a key */
void imv_keyboard_update_key(struct imv_keyboard *keyboard, int scancode, bool pressed);

/* Notify the keyboard of the state of the modifiers */
void imv_keyboard_update_mods(struct imv_keyboard *keyboard,
    int depressed, int latched, int locked);

/* Write the null-terminated name of the key corresponding to scancode into buf */
size_t imv_keyboard_keyname(struct imv_keyboard *keyboard, int scancode, char *buf, size_t buflen);

/* Describe the key corresponding to scancode, with modifier keys prefixed */
char *imv_keyboard_describe_key(struct imv_keyboard *keyboard, int scancode);

/* Write the null-terminated text generated by scancode being pressed into buf */
size_t imv_keyboard_get_text(struct imv_keyboard *keyboard, int scancode, char *buf, size_t buflen);

/* Initialise the keymap from a string containing the description */
void imv_keyboard_set_keymap(struct imv_keyboard *keyboard, const char *keymap);

/* Should the key on a given scancode repeat when held down */
bool imv_keyboard_should_key_repeat(struct imv_keyboard *keyboard, int scancode);

#endif
