# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
UBUNTU_RELEASES += 16.04

.PHONY: all
all:: ubuntu-cloud-16.04.$(GARDEN_ARCH).qcow2 ubuntu-cloud-16.04.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-$(call map_to_debian_arch,$(GARDEN_ARCH))-uefi1.img

$(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-amd64-uefi1.img $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-arm64-uefi1.img: $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-%-uefi1.img: | $(GARDEN_DL_DIR)/ubuntu
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud-images.ubuntu.com/xenial/current/xenial-server-cloudimg-$*-uefi1.img)

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-16.04.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu/ $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-amd64-uefi1.img
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-16.04.aarch64.qcow2: | $(GARDEN_DL_DIR)/ubuntu/ $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-arm64-uefi1.img
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-16.04.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/xenial-server-cloudimg-*-uefi1.img
