#define XERR
#include "dependencies.ih"

// d_circular is a vector whose elements 'idx' contain the (unordered) set of
// modules imported by module 'idx'.

// d_idx is a vector of size_t values equal to their indices: copies of
// the indices of the modules (available in d_modVect)

    // called by circular.cc

void Dependencies::setCircular()
{
    for (ModData &data: d_modVect)
        d_circular.push_back(data.imports());      // cp d_imports to ret

    d_idx.resize(d_modVect.size());
    iota(d_idx.begin(), d_idx.end(), 0);           // fill the indices
}
