; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "HSQL"
!define PRODUCT_VERSION "1.4"
!define PRODUCT_PUBLISHER "Krasimir Angelov"
!define PRODUCT_WEB_SITE "http://htoolkit.sourceforge.net"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

!define REQUIRED_GHC_VERSION "6.2.1"

; Path to the HSQL build directory:
!define HSQL_PATH ".."

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "${HSQL_PATH}\LICENSE"
; Settings
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
;Startmenu
Var STARTMENU_FOLDER
!insertmacro MUI_PAGE_STARTMENU PRODUCT_NAME $STARTMENU_FOLDER
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

!include "StrFunc.nsh"
${StrRep}


Var GHCDIR
Var DOCS

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}.exe"
InstallDir "c:\HToolkit\HSQL"
ShowInstDetails show
ShowUnInstDetails show

Section "HSQL for GHC-${REQUIRED_GHC_VERSION}" SEC01
  ReadRegStr $GHCDIR HKLM "SOFTWARE\Haskell\GHC\ghc-${REQUIRED_GHC_VERSION}" "InstallDir"
  StrCmp $GHCDIR "" GetDir Ok
  IfErrors +1 Ok
  GetDir:
  MessageBox MB_ICONEXCLAMATION "Couldn't find GHC"
  StrCpy $GHCDIR $R9
  StrCmp $GHCDIR "" Cancel Ok

  Cancel:
  Abort "Couldn't find GHC"

  Ok:
  SetOverwrite ifnewer
  
  SetOutPath "$INSTDIR\GHC"
  File /r "${HSQL_PATH}\hsql.pkg.in"
  File /r "${HSQL_PATH}\build\libHSsql.a"
  File /r "${HSQL_PATH}\mingw32lib\liblibmysql.a"
  File /r "${HSQL_PATH}\mingw32lib\liblibpq.a"
  File /r "${HSQL_PATH}\mingw32lib\libsqlite.a"
  
  SetOutPath "$INSTDIR\GHC\imports"
  File /r "${HSQL_PATH}\build\*.hi"
  
  ; Fix the hsql.pkg-file
  Call fixPkg
  StrCpy $R0 "$GHCDIR\bin\ghc-pkg -u -g -i $\"$INSTDIR\GHC\hsql.pkg$\""
  ExecWait $R0
SectionEnd

Section "HSQL for Hugs" SEC02
  SetOutPath "$INSTDIR\Hugs\libraries"
  File /r "${HSQL_PATH}\build\*.hs"
  File /r "${HSQL_PATH}\build\*.dll"
SectionEnd

Section "Documentation" SEC03
  StrCpy $DOCS "yes"
  SetOverwrite ifnewer
  SetOutPath "$INSTDIR\doc"
  File /r "${HSQL_PATH}\doc\*.html"
  File /r "${HSQL_PATH}\doc\*.gif"
  File /r "${HSQL_PATH}\doc\*.css"
SectionEnd

Section "Examples" SEC04
  SetOverwrite ifnewer
  SetOutPath "$INSTDIR\examples"
  File /r "${HSQL_PATH}\examples\*.hs"
SectionEnd

Section -DLL
  SetOverwrite ifnewer
  SetOutPath "$SYSDIR"
  File /r "${HSQL_PATH}\mingw32lib\*.dll"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateDirectory "$SMPROGRAMS\$STARTMENU_FOLDER"
  StrCmp $DOCS "yes" +1 +2
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Documentation.lnk" "$INSTDIR\doc\index.html"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$STARTMENU_FOLDER\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "StartMenu" "$STARTMENU_FOLDER"
SectionEnd

; Component descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} $(DESC_Section1)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} $(DESC_Section2)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} $(DESC_Section3)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC04} $(DESC_Section4)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

LangString DESC_Section1 ${LANG_ENGLISH} "Install HSQL for GHC"
LangString DESC_Section2 ${LANG_ENGLISH} "Install HSQL for Hugs"
LangString DESC_Section3 ${LANG_ENGLISH} "Install HSQL with documentation"
LangString DESC_Section4 ${LANG_ENGLISH} "Install HSQL examples"


Function fixPkg
  ; Fix the hsql.pkg file to the right paths
  ; in order to be able to add the hsql package to ghc.
  clearErrors
  FileOpen $0 "$INSTDIR\GHC\hsql.pkg.in" "r"
  GetTempFileName $R0
  FileOpen $1 $R0 "w"
  loop:
   FileRead $0 $2
   IfErrors done
   
   ${StrRep} $R1 $2  "@GHC_DIR@"  "$INSTDIR/GHC"
   ${StrRep} $R1 $R1 "@LIB_DIRS@" "$\"$INSTDIR/GHC$\""
   ${StrRep} $R1 $R1 "@DEP_LIBS@" "$\"sqlite$\", $\"libpq$\", $\"odbc32$\", $\"libmysql$\""
   ${StrRep} $R1 $R1 "\" "/"
   
   FileWrite $1 $R1
   Goto loop

   done:
        FileClose $0
        FileClose $1
        CopyFiles /SILENT $R0 "$INSTDIR\GHC\hsql.pkg"
        Delete $R0
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall

  ; Remove HSQL from statmenu
  ReadRegStr $STARTMENU_FOLDER ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "StartMenu"
  ifErrors +2 +1
  RMDir /r "$SMPROGRAMS\$STARTMENU_FOLDER"
  RMDir /r "$INSTDIR"

  ; Remove hsql package from ghc
  ReadRegStr $GHCDIR HKLM "SOFTWARE\Haskell\GHC\ghc-${REQUIRED_GHC_VERSION}" "InstallDir"
  ifErrors +1 +3
  MessageBox MB_ICONEXCLAMATION "Unable to remove hsql lib files from the ghc folder"
  goto end

  StrCpy $R0 "$\"$GHCDIR\bin\ghc-pkg$\" -r hsql"
  ExecWait $R0
  
  end:
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
