#!/usr/bin/env bash

#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#

#
# Reformats the HTrace code.
#
# ./format.sh               Reformats all code.
#

die() {
    echo $@
    exit 1
}

# Check for gofmt.  It should be installed whenever the go developement tools
# are installed.
which gofmt &> /dev/null
[ $? -ne 0 ] && die "You must install the gofmt code reformatting formatting tool."

# Find go sources.  We assume no newlines or whitespace in file names.
SCRIPT_DIR="$(cd "$( dirname $0 )" && pwd)"
find "${SCRIPT_DIR}/src" -noleaf -xdev -name '*.go' | xargs -L 1 gofmt -w
