///////
   //    Link.h
   //    Link Class declaration
   //
   //    Class for Link storage
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Some Portions Copyright (c) 1995-2000 The ht://Dig Group <www.htdig.org>
   //    Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: Link.h,v 1.19 2008-11-16 18:28:52 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifndef _LINK_H
#define _LINK_H

#ifdef HAVE_STD
#include <iostream>
#include <string>
#ifdef HAVE_NAMESPACES
using namespace std;
#endif
#else
#include <iostream.h>
#include <string.h>
#endif /* HAVE_STD */

#include <Object.h>


class Link : public Object
{

   // Write the object to the output
   friend ostream &operator <<( ostream &, const Link & );
   
   public:
   
      // Construction / Destruction
      Link();
      virtual ~Link();

      enum Link_Type
      {
         Link_Normal,
         Link_Direct,
         Link_Redirection
      };

      enum Link_Result
      {
         Link_NotChecked,
         Link_NotRetrieved,
         Link_OK,
         Link_Broken,
         Link_Redirected,
         Link_AnchorNotFound,
         Link_EMail,
         Link_Javascript,
         Link_NotAuthorized,
	 Link_BadEncoded
      };

      enum Link_Domain
      {
         Link_Unknown,		// Unknows
         Link_SameServer,	// Link to a document that resides on the same Web server (host:port)
         Link_Internal,		// Link to a different server, but inside the limits
         Link_External		// Link towards a URL that's out of the limits
      };


///////
   //    Public Interface
///////

      void Reset();

      void SetIDUrlSrc     (unsigned int id) { IDUrlSrc = id; }
      void SetIDUrlDest    (unsigned int id) { IDUrlDest = id; }
      void SetTagPosition  (unsigned int tp) { TagPosition = tp; }
      void SetAttrPosition (unsigned int ap) { AttrPosition = ap; }
      void SetAnchor (const std::string &a) { Anchor = a; }

      void SetLinkType (Link_Type t) { LinkType = t; }
      void SetLinkResult (Link_Result r) { LinkResult = r; }
      void SetLinkDomain (Link_Domain d) { LinkDomain = d; }

      // Insert into a string the value for the LinkType
      // (converts a Link_Type value into a std::string).
      void RetrieveLinkType (std::string &) const;
                                       
      // Insert into a string the value for the LinkResult
      // (converts a Link_Result value into a std::string).
      void RetrieveLinkResult (std::string &) const;
                                       
      // Insert into a string the value for the LinkDomain
      // (converts a Link_Domain value into a std::string).
      void RetrieveLinkDomain (std::string &) const;

      int SetLinkType (const std::string& Type);	// Set the Link_Type value
                                          	// depending on the Type value
      
      int SetLinkResult (const std::string& Result); // Set the Link_Result value
                                          	// depending on the Result value
      
      int SetLinkDomain (const std::string& Result);	// Set the Link_Result value
                                          	// depending on the Result value

      unsigned int GetIDUrlSrc() const       { return IDUrlSrc; }
      unsigned int GetIDUrlDest() const      { return IDUrlDest; }
      unsigned int GetTagPosition()const     { return TagPosition; }
      unsigned int GetAttrPosition() const   { return AttrPosition; }
      const std::string &GetAnchor() const        { return Anchor; }
      Link_Type GetLinkType() const          { return LinkType; }
      Link_Result GetLinkResult() const      { return LinkResult; }
      Link_Domain GetLinkDomain() const      { return LinkDomain; }

      // Static methods for managing debug level
      static void SetDebugLevel (int d) { debug=d;}

///////
   //    Protected attributes
///////

   protected:

      unsigned int IDUrlSrc;
      unsigned int IDUrlDest;
      unsigned int TagPosition;
      unsigned int AttrPosition;
      std::string       Anchor;
      Link_Type    LinkType;
      Link_Result  LinkResult;
      Link_Domain  LinkDomain;

///////
   //    Static attributes
///////

      static int debug;    // Run-time debugging level

};

#endif
