<WEBPAGE chapter="hsc - " title="Existing Ports"
         PREV="source.html"
         NEXT="others.html"
         QTEXT="Intel inside - idiot outside."
         QAUTHOR="Author unknown">

<*<IMG SRC="image/designed.png" ALT="Designed for Nothing Specific" ALIGN="right">*>

<P>As <hsc> is cryptic to use, has no graphical user interface and
does nothing else apart from reading an input file and output to
another one, it is quite easy to port it to other systems, as long as
they support some sort of command line interface and a decent
C-compiler.</P>

<P>This chapter describes existing or planed ports and what are the 
differences to the version for AmigaOS. Currently ports exist for
<A HREF="#riscos">RiscOS</A>,
<A HREF="#nextstep"><Nextstep></A>,
<A HREF="#amiga-ppc">AmigaOS with PowerPC</A>,
<A HREF="#amixemul">AmigaOS with <FILE>ixemul.library</FILE></A>,
<A HREF="#beos">BeOS</A>,
<A HREF="#windoze">Windoze</A>
and <A HREF="#unix">Unixoid systems</A> (including MacOS X).
</P>

<H2><A NAME="riscos">RiscOS</A></H2>

<P>The port to RiscOS has been done by Sergio Monesi and Nick
Craig-Wood. For details, please refer to <riscos-support>. Basically,
it acts like the version for <NextStep> (see below), although you will
have to use a special <make> tool.</P>

<H2><A NAME="nextstep"><Nextstep></A></H2>

<H3>Searching For Syntax Definition</H3>

When searching for the <ln-syntax>, <hsc> will look for the file you've specified using the option <op-prefsfile>.
If you did not specify any, it will search the

<UL>
<LI>current directory
<LI>directory you have specified using <env-hscpath>
<LI>directory specified in the environment variable
    <env-home>, with a <qq><FILE>lib/</FILE></qq> added.
<LI>directory <qq><FILE>/usr/local/lib/</FILE></qq>
<LI>directory <qq><FILE>/usr/lib/</FILE></qq>
</UL>

for a file named <hsc.prefs>. If one of these directories does not
contain a <hsc.prefs> or does not exist at all, <hsc> will silently
proceed with the next one on this list.

<H3>Exit Code</H3>

On notes/warnings/errors/fatal errors showing up, <hsc> will
return an exit code of 0/0/1/2.

<H2><A NAME="amiga-ppc">AmigaOS with PowerPC</A></H2>

<p>There is a port available that compiles with SAS/c. However,
this was only done to show that it is possible. Although no changes to the
code are necessary, currently nobody maintains this version so the
executable might be slightly outdated. Concerning the pathetic mess
which link format to use: it is the one from p5.</p>

<p>You can find the binary in <aminet file="text/hyper/hscPPC.lha">,
so you still need the <qq>normal</qq> archive for the documentation.</p>

<H2><A NAME="amixemul">AmigaOS with ixemul.library</A></H2>

<P>Most GNU-tools have been ported to AmigaOS using an additional
library called <FILE>ixemul.library</FILE>. It is quite successful in
turning an Amiga in a moldy and dribbling Un*x-box, emulating all
those idiotic things like the <qqc>..</qqc> and <qqc>/bin</qqc> pretty
shitty well. Of course you can also use <hsc> with it.</P>

<P>But if you prefer to rape your machine, you have to compile it
yourself using the <EXEC>gcc</EXEC>-port from GeekGadgets. If you
don't know what I'm currently talking about, you don't want to do this
anyway. Actually the binary of <hsc> included in the archive for
AmigaOS is able to deal with native filenames and system directories,
so why bother?</P>

<H2><A NAME="beos">BeOS</A></H2>

<P>It has been reported to work. You should be able to compile it with
<EXEC>mwcc</EXEC>. It acts similar to the version for <Nextstep>.</P>

<P>But currently no one takes care about this port, and I never tried
it out myself. So there might be problems with newer versions of this
OS or the <EXEC>mwcc</EXEC> compiler. Most likely there are more
compiler options that could be specified for better code.</P>

<H2><A NAME="unix">Unixoid Systems</A></H2>

<P>This version acts similar to the one for <Nextstep>. There should be no
problems compiling HSC out-of-the-box, since it has ben developed mainly on
Linux since V0.918. HSC has been successfully used on at least [Mk]Linux,
NetBSD, IRIX, HP/UX and Solaris.</P>

<P>MacOS X, as the first of Apple's systems to feature a
decent commandline shell (unless you want to call the Apple-II's <qq>decent</qq>,
which I don't), has no problems running and compiling HSC. To compile, you need
the Developer Tools (gcc, GNU make etc.) available by FTP from Apple. For
obscure reasons, the OSX linker doesn't like HSC to be stripped of symbols with
the <qqc>-s</qqc> switch, it wants <qqc>-x</qqc>. Otherwise the procedure is
the same as for other Unixoids.
</P>

<H2><A NAME="windoze">Windoze NT</A></H2>
<P>Yes, HSC compiles under Windoze, at least under NT. Options for M$ VC++ are
included in the Makefile. It is not recommended to use this system for HSC, but
if you really have to, by all means stay away from Frontpage(tm), GoLive!(tm),
Dreamweaver(tm) and similar abominations and go for HSC.</P>

<H2><A NAME="msdos">MS-DOS Based Systems</A></H2>

<P>Anything running off a crippled 8.3-format filesystem is out of the
question. These systems should have been trashed 20 years ago and I will
certainly not call a <qq>.pref</qq>-file anything like <qq>.prf</qq> or
<qq>.ini</qq> just because this junk doesn't run HSC. It might be possible to
compile HSC on W32-based systems using FAT32, but I trust people still using
them are not the types who'd want HSC anyway. And that's a Good Thing.</P>

<H2><A NAME="others">Other Systems</A></H2>

<P>Ah, well, there are still systems without <hsc>.</P>

<P>For MacOS, I don't don't have a compiler and maybe one will have to
write a GUI. Internally <hsc> is <em>not</em> designed to be used from
command line only. If you take a look at the <CODE>main()</CODE> of
<FILE>source/hsc/hsc.c</FILE>, you will see that it's only about
ten lines of code. However, you will need to find a tool to do the
project management - or integrate this part into your GUI. And that's
probably where it starts to get tough...</P>

<P>Atari TOS counts as MS-DOS based (see above), especially the
filename limitations.</P>

<P>For C64/C128 <hsc> is too slow and bloated, which of course is my
fault. I'm pretty sure one could do a decent <hsc>-alike program on
these machines.</P>

<P>Several other systems should have no trouble compiling the same way as for
Unixoid systems or AmigaOS with ixemul.library. It mostly depends on the
C-compilers available. Systems like VMS (I was told it's still in use in its
incarnation for Alpha CPUs) with weird path separators and other niceties to
keep programmers busy will probably need a few <code>#ifdef</code>s in places
where there are a few already.</P>

</WEBPAGE>
