#include "board_layers.hpp"

namespace horizon {
std::string BoardLayers::get_layer_name(int l)
{
    switch (l) {
    case TOP_NOTES:
        return "Top Notes";

    case OUTLINE_NOTES:
        return "Outline Notes";

    case L_OUTLINE:
        return "Outline";

    case TOP_COURTYARD:
        return "Top Courtyard";

    case TOP_ASSEMBLY:
        return "Top Assembly";

    case TOP_PACKAGE:
        return "Top Package";

    case TOP_PASTE:
        return "Top Paste";

    case TOP_SILKSCREEN:
        return "Top Silkscreen";

    case TOP_MASK:
        return "Top Mask";

    case TOP_COPPER:
        return "Top Copper";

    case IN1_COPPER:
    case IN2_COPPER:
    case IN3_COPPER:
    case IN4_COPPER:
    case IN5_COPPER:
    case IN6_COPPER:
    case IN7_COPPER:
    case IN8_COPPER:
        return "Inner " + std::to_string(-l);

    case BOTTOM_COPPER:
        return "Bottom Copper";

    case BOTTOM_MASK:
        return "Bottom Mask";

    case BOTTOM_SILKSCREEN:
        return "Bottom Silkscreen";

    case BOTTOM_PASTE:
        return "Bottom Paste";

    case BOTTOM_PACKAGE:
        return "Bottom Package";

    case BOTTOM_ASSEMBLY:
        return "Bottom Assembly";

    case BOTTOM_COURTYARD:
        return "Bottom Courtyard";

    case BOTTOM_NOTES:
        return "Bottom Notes";

    case USER1:
    case USER2:
    case USER3:
    case USER4:
    case USER5:
    case USER6:
    case USER7:
    case USER8:
        return "User " + std::to_string(l - FIRST_USER_LAYER + 1);
    }
    return "Invalid layer " + std::to_string(l);
}

static const std::vector<int> layers = {
        BoardLayers::TOP_NOTES,
        BoardLayers::OUTLINE_NOTES,
        BoardLayers::L_OUTLINE,
        BoardLayers::TOP_COURTYARD,
        BoardLayers::TOP_ASSEMBLY,
        BoardLayers::TOP_PACKAGE,
        BoardLayers::TOP_PASTE,
        BoardLayers::TOP_SILKSCREEN,
        BoardLayers::TOP_MASK,
        BoardLayers::TOP_COPPER,
        BoardLayers::IN1_COPPER,
        BoardLayers::IN2_COPPER,
        BoardLayers::IN3_COPPER,
        BoardLayers::IN4_COPPER,
        BoardLayers::IN5_COPPER,
        BoardLayers::IN6_COPPER,
        BoardLayers::IN7_COPPER,
        BoardLayers::IN8_COPPER,
        BoardLayers::BOTTOM_COPPER,
        BoardLayers::BOTTOM_MASK,
        BoardLayers::BOTTOM_SILKSCREEN,
        BoardLayers::BOTTOM_PASTE,
        BoardLayers::BOTTOM_PACKAGE,
        BoardLayers::BOTTOM_ASSEMBLY,
        BoardLayers::BOTTOM_COURTYARD,
        BoardLayers::BOTTOM_NOTES,
        BoardLayers::USER1,
        BoardLayers::USER2,
        BoardLayers::USER3,
        BoardLayers::USER4,
        BoardLayers::USER5,
        BoardLayers::USER6,
        BoardLayers::USER7,
        BoardLayers::USER8,
};

const std::vector<int> &BoardLayers::get_layers()
{
    return layers;
}

const unsigned int BoardLayers::max_inner_layers = 8;

const LayerRange BoardLayers::layer_range_through{BoardLayers::TOP_COPPER, BoardLayers::BOTTOM_COPPER};

} // namespace horizon
