/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.internal.html.docbook.editor;

import java.util.HashMap;

import org.dbdoclet.option.OptionException;
import org.dbdoclet.tag.docbook.DocBookTagFactory;
import org.dbdoclet.tag.docbook.Title;
import org.dbdoclet.tag.html.HtmlDocument;
import org.dbdoclet.tag.html.HtmlElement;
import org.dbdoclet.trafo.html.EditorException;
import org.dbdoclet.trafo.html.EditorInstruction;
import org.dbdoclet.trafo.html.docbook.SectionDetector;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class HeadingEditor extends DocBookEditor {

	public static HashMap<String, HashMap<String, String>> validHtmlParentPathMap;

	static {

		validHtmlParentPathMap = new HashMap<String, HashMap<String, String>>();
		validHtmlParentPathMap.put(new HtmlDocument().getNodeName(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.Html.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.Body.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.Center.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.Div.getTag(),
				HtmlElement.getAttributeMap());
		validHtmlParentPathMap.put(org.dbdoclet.tag.html.A.getTag(),
				HtmlElement.getAttributeMap());
	}

	// private HeaderElement header;

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		try {
			
			setValues(super.edit(values));

			DocBookTagFactory dbfactory = getTagFactory();

			ElementImpl headElement = values.getHtmlElement();
			HtmlElement parent = (HtmlElement) headElement.getParentNode();
			
			if (parent instanceof org.dbdoclet.tag.html.Section
					|| parent instanceof org.dbdoclet.tag.html.Article
					|| parent instanceof org.dbdoclet.tag.html.Header) {	
			
				Title title = dbfactory.createTitle();
				getCurrent().appendChild(title);
				setCurrent(title);
				return finalizeValues();
			}
			
			SectionDetector sectionDetector = new SectionDetector();
			sectionDetector.setScript(script);
			sectionDetector.setTagFactory(dbfactory);
			sectionDetector.edit(values, dbfactory);

			return finalizeValues();

		} catch (OptionException oops) {

			throw new EditorException(oops);
		} // end of try-catch
	}

}
